#pragma once

// -

namespace meta{

#define META_MIN(x,y) ((x)<(y) ? (x) : (y))
#define META_MIN_3(x,y,z) (META_MIN(META_MIN(x,y),z))

template <int x,int y> struct Min //   	template magic
{
	template <bool> struct onTrueFirst {enum {Value = y};};
	template <> struct onTrueFirst<true> {enum {Value = x};};
		
	enum {Value = onTrueFirst<(x<y)>::Value};
};

#define META_MAX(x,y) ((x)>(y) ? (x) : (y))
#define META_MAX_3(x,y,z) (META_MAX(META_MAX(x,y),z))

template <int x,int y> struct Max //   	template magic
{
	template <bool> struct onTrueFirst {enum {Value = y};};
	template <> struct onTrueFirst<true> {enum {Value = x};};
		
	enum {Value = onTrueFirst<(x>y)>::Value};
};

//  

template <int n> struct NextSimple;

#define META_NEXT_SIMPLE(n) meta::NextSimple<n>::Value

template <int n> struct IsSimple
{
	template <int m> struct onDenominator
	{
		template <bool> struct onDivided {enum {Value = onDenominator<META_NEXT_SIMPLE(m+m%2+1)>::Value};};
		template <> struct onDivided<true> {enum {Value = false};};
		
		template <bool> struct onEnough {enum {Value = onDivided<n%m==0>::Value};};
		template <> struct onEnough<true> {enum {Value = true};};
		
		enum {Value = onEnough<(m*m>n)>::Value};
	};

	enum {Value = onDenominator<2>::Value};
};
template <> struct IsSimple<0> {enum {Value = true};};
template <> struct IsSimple<1> {enum {Value = true};};
template <> struct IsSimple<2> {enum {Value = true};};

#define META_IS_SIMPLE(n) meta::IsSimple<n>::Value

template <int n> struct NextSimple
{
	template <bool> struct onSimple {enum {Value = META_NEXT_SIMPLE(n+n%2+1)};};
	template <> struct onSimple<true> {enum {Value = n};};
	
	enum {Value = onSimple<IsSimple<n>::Value>::Value};
};
template <> struct NextSimple<0> {enum {Value = 1};};
template <> struct NextSimple<1> {enum {Value = 1};};

//    

#define META_NOINDEX (-1)

#define META_MAX_NAME_SIZE(Last) meta::MaxNameSize<Last>::Value

template <class Last> struct MaxNameSize
{
	template <int> struct onIndex {enum {Value = META_MAX_3(Last::EngNameSize, Last::RusNameSize, META_MAX_NAME_SIZE(Last::Prev))};};
	template <> struct onIndex<META_NOINDEX> {enum {Value = 1};};
	
	enum {Value = onIndex<Last::Index>::Value};
};

} // namespace meta

//  

namespace hashstr{

__declspec(selectany) char lowerTable[0x100] = {0};

inline void Init()
{
	for (UINT n=0;n<0x100;n++) 
		lowerTable[n]=_mbctolower(n);
}

//    (?),  if 0

#if 1
	#pragma warning(disable: 4035)

	//  DestSize=0,    Dest   (  4)      Source

	inline __declspec(naked) UINT GetHashAndLower(LPCSTR Source/*esp+4*/,LPSTR Dest/*esp+8*/,UINT DestSize/*esp+12*/)
	{
		_asm
		{
			push esi
			push edi
			push ebx

			mov esi,/*Source*/[esp+4 + 12]
			mov edi,/*Dest*/[esp+8 + 12]
			mov ebx,/*DestSize*/[esp+12 + 12]
			mov ecx,123
			xor edx,edx
			xor eax,eax
__loop:
			dec ebx
			je short __end_zero

			lodsb
			test eax,eax
			je short __end
			mov al,lowerTable[eax]
			stosb

			rol ecx,3
			add edx,ecx; adc edx,0
			add edx,eax; adc edx,0
			ror edx,5
			jmp short __loop
__end_zero:
			xor eax,eax
__end:
			stosb
			mov eax,edx

			pop ebx
			pop edi
			pop esi
			ret
		}
	}

	#pragma warning(default: 4035)
#else
	inline static UINT GetHashAndLower(LPCSTR Source,LPSTR Dest,UINT DestSize)
	{
		UINT adx=0;
		for (UINT acx=213;*Source && --DestSize;Source++,Dest++)
		{
			_asm rol acx,3
			adx+=acx+(BYTE)(*Dest=lowerTable[(BYTE)*Source]);
			_asm ror adx,5
		}
		*Dest=0;
		return adx;
	}
#endif

} // namespace hashstr

using hashstr::GetHashAndLower;

//  

struct metaProp {};
struct metaMeth {};

namespace contimpl{

#define BL_METHOD __cdecl

//    

typedef struct CItem
{
	LPCSTR Names[2];
}
*PItem;

typedef struct CItemList
{
	int Index;
	char *Name;
	char *LowerName;
	CItemList *Prev;
}
*PItemList;

template <class Descr>
	struct CNoFind
{
	void Add(CItemList &Item)
	{
	}
	PItemList Find(LPCSTR Name)
	{
		return 0;
	}
	void Print()
	{
		Debug("<NULL>\n");
	}
};

template <class Descr>
	struct CHashFind
{
	enum {HashCount = META_NEXT_SIMPLE(Descr::Count*3+1)};
	enum {MaxNameSize = META_MAX_NAME_SIZE(Descr::Last)};

	PItemList Items[HashCount];

	void Add(CItemList &Item)
	{
		PItemList &Curr=Items[GetHashAndLower(Item.Name,Item.LowerName,0)%(UINT)HashCount];
		Item.Prev=Curr;
		Curr=&Item;
	}
	PItemList Find(LPCSTR Name)
	{
		//Debug("Find '%s'\n",Name);

		//     ,         
		//        ,     

		static char LowerName[MaxNameSize+4];
		PItemList Curr=Items[GetHashAndLower(Name,LowerName,sizeof(LowerName))%(UINT)HashCount];
		while (Curr && strcmp(LowerName,Curr->LowerName))
			Curr=Curr->Prev;
		return Curr;
	}
	void Print()
	{
		Debug("HashCount %i MaxNameSize %i\n",HashCount,MaxNameSize);
		for (int n=0;n<HashCount;n++)
		{
			PItemList Item=Items[n];
			Debug("Hash %i:",n);
			if (!Item) Debug(" <NULL>"); else
				while (Item)
				{
					Debug(" <NODE>%s",Item->LowerName);
					Item=Item->Prev;
				}
			Debug("\n");
		}
	}
};

template <class Descr>
	struct CFindSelector
{
	template <int> struct onCount {typedef CHashFind<Descr> Type;};
	template <> struct onCount<0> {typedef CNoFind<Descr> Type;};

	typedef onCount<Descr::Count>::Type Type;
};

#define BL_FIND_SELECTOR(Descr) contimpl::CFindSelector<Descr>::Type

// -      

#define PREV_META_TYPE_EX(Kind,Line) prevMetaType<Kind,Line-1>::Type
#define PREV_META_TYPE(Kind) PREV_META_TYPE_EX(Kind,__LINE__)

#define NULL_META_TYPE(Kind,Name) \
	template <class Kind,int Line> struct prevMetaType {typedef PREV_META_TYPE_EX(Kind,Line) Type;}; \
	struct Kind##Name \
	{ \
		enum {Index = META_NOINDEX};

#define BEGIN_META_TYPE(Kind,Name) \
	struct Kind##Name \
	{ \
		typedef PREV_META_TYPE(Kind) Prev; \
		enum {Index = Prev::Index+1};

#define END_META_TYPE(Kind,Name) \
	}; \
	friend struct Kind##Name; \
	template <> struct prevMetaType<Kind,__LINE__> {typedef Kind##Name Type;};

// ***

#define NULL_ITEM(Kind) \
	NULL_META_TYPE(Kind,_Null) \
		template <class Type> \
			static void GetItems(contimpl::PItem *Items,Type &Find) \
		{ \
		} \
		static void Print() \
		{ \
		} \
	END_META_TYPE(Kind,_Null)

#define BEGIN_ITEM(Kind,Name,RusName) \
	BEGIN_META_TYPE(Kind,Name) \
		enum {EngNameSize = sizeof(#Name)}; \
		enum {RusNameSize = sizeof(RusName)}; \
		\
		static LPCSTR GetEngName() \
		{ \
			return #Name; \
		} \
		static LPCSTR GetRusName() \
		{ \
			return RusName; \
		} \
		\
		static contimpl::CItemList &GetEngItem() \
		{ \
			static char LowerName[EngNameSize]; \
			static contimpl::CItemList Item = {Index, #Name, LowerName}; \
			return Item; \
		} \
		static contimpl::CItemList &GetRusItem() \
		{ \
			static char LowerName[RusNameSize]; \
			static contimpl::CItemList Item = {Index, RusName, LowerName}; \
			return Item; \
		} \
		\
		template <class Type> \
			static void GetItems(contimpl::PItem *Items,Type &Find) \
		{ \
			Items[Index]=&GetItem(); \
			Find.Add(GetEngItem()); \
			Find.Add(GetRusItem()); \
			Prev::GetItems(Items,Find); \
		} \
		static void Print() \
		{ \
			Prev::Print(); \
			Debug("%i: %s=%i (%s=%i)\n",Index,GetRusItem().LowerName,RusNameSize,GetEngItem().LowerName,EngNameSize); \
		}

#define END_ITEM(Kind,Name) \
	END_META_TYPE(Kind,Name)

#define DESCR_ITEM(Kind) \
	BEGIN_META_TYPE(Kind,_Descr) \
		enum {Count = Index}; \
		typedef Prev Last; \
		\
		template <class Type> \
			static void GetItems(contimpl::PItem *Items,Type &Find) \
		{ \
			Last::GetItems(Items,Find); \
		} \
		static void Print() \
		{ \
			Debug("Count %i MaxNameSize %i\n",Count,META_MAX_NAME_SIZE(Last)); \
			Last::Print(); \
		} \
	END_META_TYPE(Kind,_Descr)

//    (    1)

struct CNoInitDone
{
	static void Init()
	{
	}
	static void Done()
	{
	}
};

class CNoBase
{
};

typedef void BL_METHOD TPropRead(CValue &Value);
typedef void BL_METHOD TPropWrite(CValue const &Value);

typedef void BL_METHOD TProcCall(CValue **Params);
typedef void BL_METHOD TFuncCall(CValue **Params,CValue &Value);
typedef int BL_METHOD TMethGetDef(int Index,CValue &Value);

template <class CContext,class CInitDone = CNoInitDone,class CBase = CNoBase>
	class CContextImplBase: public CBase
{
public:
	typedef CContext CThis;

	static void InitContext()
	{
		Debug("Init '%s'\n",CContext::GetRusName());
		CContext::InitMaps();
		CInitDone::Init();
	}
	static void DoneContext()
	{
		Debug("Done '%s'\n",CContext::GetRusName());
		CInitDone::Done();
	}

	typedef TPropRead (CContext::*PPropRead);
	typedef TPropWrite (CContext::*PPropWrite);

	typedef struct CPropItem
	{
		CItem Base; /*     ,     */
		PPropRead Read;
		PPropWrite Write;
	}
	*PPropItem;

	typedef TProcCall (CContext::*PProcCall);
	typedef TFuncCall (CContext::*PFuncCall);
	typedef TMethGetDef (CContext::*PMethGetDef);

	typedef struct CMethItem
	{
		CItem Base; /*     ,     */
		int ParamCount;
		PProcCall Proc;
		PFuncCall Func;
		PMethGetDef GetDef;
	}
	*PMethItem;
};

#define BL_BEGIN_CONTEXT(EngName,RusName) \
	NULL_ITEM(metaProp) \
	NULL_ITEM(metaMeth) \
	\
	static LPCSTR GetEngName() \
	{ \
		return EngName; \
	} \
	static LPCSTR GetRusName() \
	{ \
		return RusName; \
	}

#define BL_END_CONTEXT() \
	DESCR_ITEM(metaProp) \
	DESCR_ITEM(metaMeth) \
	\
	typedef BL_FIND_SELECTOR(metaProp_Descr) CFindProp; \
	typedef BL_FIND_SELECTOR(metaMeth_Descr) CFindMeth; \
	\
	enum {PropCount = metaProp_Descr::Count}; \
	enum {MethCount = metaMeth_Descr::Count}; \
	\
	static contimpl::PItem *GetProps() \
	{ \
		static contimpl::PItem Items[META_MAX(PropCount,1)]; \
		return Items; \
	} \
	static CFindProp &GetFindProp() \
	{ \
		static CFindProp Find; \
		return Find; \
	} \
	static PPropItem GetProp(int Index) \
	{ \
		return !(Index<0) && Index<PropCount ? (PPropItem)GetProps()[Index] : 0; \
	} \
	static int FindProp(LPCSTR Name) \
	{ \
		contimpl::PItemList Item=GetFindProp().Find(Name); \
		return Item ? Item->Index : META_NOINDEX; \
	} \
	int PropRead(int Index) /*   */ \
	{ \
		PPropItem Item=GetProp(Index); \
		return Item && Item->Read ? (this->*Item->Read)(*(CValue*)0),1 : 0; \
	} \
	int PropWrite(int Index) /*   */ \
	{ \
		PPropItem Item=GetProp(Index); \
		return Item && Item->Write ? (this->*Item->Write)(*(CValue*)0),1 : 0; \
	} \
	\
	static contimpl::PItem *GetMeths() \
	{ \
		static contimpl::PItem Items[META_MAX(MethCount,1)]; \
		return Items; \
	} \
	static CFindMeth &GetFindMeth() \
	{ \
		static CFindMeth Find; \
		return Find; \
	} \
	static PMethItem GetMeth(int Index) \
	{ \
		return !(Index<0) && Index<MethCount ? (PMethItem)GetMeths()[Index] : 0; \
	} \
	static int FindMeth(LPCSTR Name) \
	{ \
		contimpl::PItemList Item=GetFindMeth().Find(Name); \
		return Item ? Item->Index : META_NOINDEX; \
	} \
	int CallProc(int Index) /*   */ \
	{ \
		PMethItem Item=GetMeth(Index); \
		return Item && Item->Proc ? (this->*Item->Proc)(0),1 : 0; \
	} \
	int CallFunc(int Index) /*   */ \
	{ \
		PMethItem Item=GetMeth(Index); \
		return Item && Item->Func ? (this->*Item->Func)(0,*(CValue*)0),1 : 0; \
	} \
	\
	static void InitMaps() \
	{ \
		metaProp_Descr::GetItems(GetProps(),GetFindProp()); \
		metaMeth_Descr::GetItems(GetMeths(),GetFindMeth()); \
	}

// ***

#define BL_PROP_EX(Name,RusName,Read,Write) \
	BEGIN_ITEM(metaProp,Name,RusName) \
		static contimpl::CItem &GetItem() \
		{ \
			static CPropItem Item={{{#Name, RusName}}, Read, Write}; \
			return Item.Base; \
		} \
	END_ITEM(metaProp,Name) \
	void __cdecl get##Name(CValue &Value)

#define BL_PROP_R(Name,RusName) BL_PROP_EX(Name,RusName,CThis::get##Name,0)
#define BL_PROP_RW(Name,RusName) BL_PROP_EX(Name,RusName,CThis::get##Name,CThis::set##Name)

#define BL_PROP_W(Name) \
	void BL_METHOD set##Name(CValue const &Value)

// ***

#define BL_METH_EX(Name,RusName,ParamCount,Proc,Func,GetDef) \
	BEGIN_ITEM(metaMeth,Name,RusName) \
		static contimpl::CItem &GetItem() \
		{ \
			static CMethItem Item={{{#Name, RusName}}, ParamCount, Proc, Func, GetDef}; \
			return Item.Base; \
		} \
	END_ITEM(metaMeth,Name)

#define BL_PROC_EX(Name,RusName,ParamCount,GetDef) \
	BL_METH_EX(Name,RusName,ParamCount,CThis::call##Name,0,GetDef) \
	void BL_METHOD call##Name(CValue **Params)

#define BL_PROC(Name,RusName,ParamCount) BL_PROC_EX(Name,RusName,ParamCount,0)
#define BL_PROC_DEF(Name,RusName,ParamCount) BL_PROC_EX(Name,RusName,ParamCount,CThis::getdef##Name)

#define BL_FUNC_EX(Name,RusName,ParamCount,GetDef) \
	BL_METH_EX(Name,RusName,ParamCount,0,CThis::call##Name,GetDef) \
	void BL_METHOD call##Name(CValue **Params,CValue &Value)

#define BL_FUNC(Name,RusName,ParamCount) BL_FUNC_EX(Name,RusName,ParamCount,0)
#define BL_FUNC_DEF(Name,RusName,ParamCount) BL_FUNC_EX(Name,RusName,ParamCount,CThis::getdef##Name)

#define BL_DEF(Name) \
	int BL_METHOD getdef##Name(int Index,CValue &Value)

//   

typedef void (*PSimpleMethod)();

#pragma data_seg(".blc$a")
__declspec(selectany) PSimpleMethod initStart = 0;
#pragma data_seg(".blc$b")
#pragma data_seg(".blc$c")
__declspec(selectany) PSimpleMethod initEnd = 0;
__declspec(selectany) PSimpleMethod doneStart = 0;
#pragma data_seg(".blc$d")
#pragma data_seg(".blc$e")
__declspec(selectany) PSimpleMethod doneEnd = 0;
#pragma data_seg()
#pragma comment(linker, "/MERGE:.blc=.data")

#define BL_INIT_CONTEXT(Name) \
	__declspec(allocate(".blc$b")) contimpl::PSimpleMethod init##Name = &Name::InitContext; \
	__declspec(allocate(".blc$d")) contimpl::PSimpleMethod done##Name = &Name::DoneContext

__declspec(selectany) int Lang = 0;

//    1

class CContextBase: public CBLContext
{
public:
	virtual char const *GetCode(void) const		{return NULL;}
	virtual int GetDestroyUnRefd(void) const	{return TRUE;}
	virtual CObjID GetID(void) const			{return CObjID();}
	virtual long GetTypeID(void) const			{return 100;}
	virtual CType GetValueType(void) const		{return CType(100);}
	virtual int IsExactValue(void) const		{return TRUE;}
	virtual int IsOleContext(void) const		{return FALSE;}
	virtual int IsSerializable(void)			{return FALSE;}
	virtual int SaveToString(CString &)			{return FALSE;}

	static void InitAllContextClasses()
	{
		hashstr::Init();
		Lang=MD->GetTaskDef()->GetDefaultLanguage();
		for (PSimpleMethod *Meth=&initStart+1;Meth<&initEnd;Meth++)
		{
			Debug("Call Init %08X\n",(UINT)*Meth);
			if (*Meth) (*Meth)();
		}
	}
	static void DoneAllContextClasses()
	{
		for (PSimpleMethod *Meth=&doneStart+1;Meth<&doneEnd;Meth++)
		{
			Debug("Call Done %08X\n",(UINT)*Meth);
			if (*Meth) (*Meth)();
		}
	}
};

template <class	CContext>
	struct CNoCreate: public CNoInitDone
{
	//  ,       RuntimeClass

	// (1)         GetRuntimeClass  CContextImpl,
	// CCreateInstanceBoost  1++     CBLContext   

	// (2)      NULL  GetRuntimeClass,  1  
	//    (  RefCount)      ,    

	// (3)      ,     GetBaseClass,  !

	// (4)         GetBaseClass,     NULL,     (2)

	static CRuntimeClass *PASCAL GetBaseClass()
	{
		return (CRuntimeClass*)&CBLContext::classCBLContext;
	}
	static CRuntimeClass *GetRuntimeClass()
	{
		static CRuntimeClass RuntimeClass = {NULL, sizeof(CContext), 0xFFFF, NULL, GetBaseClass};
		return &RuntimeClass;
	}
};

template <class CContext>
	struct CCreateObject: public CNoCreate<CContext>
{
	static CObject *PASCAL CreateObject()
	{
		Debug("CreateObject '%s'\n",CContext::GetRusName());
		return new CContext;
	}
	static CRuntimeClass *GetRuntimeClass()
	{
		static CRuntimeClass RuntimeClass = {NULL, sizeof(CContext), 0xFFFF, CreateObject, GetBaseClass};
		return &RuntimeClass;
	}

	static void Init()
	{
		Debug("Reg '%s'\n",CContext::GetRusName());
		CBLContext::RegisterContextClass(GetRuntimeClass(), CContext::GetEngName(), CType(100));
		CBLContext::RegisterContextClass(GetRuntimeClass(), CContext::GetRusName(), CType(100));
	}
	static void Done()
	{
		Debug("UnReg '%s'\n",CContext::GetRusName());
		CBLContext::UnRegisterContextClass(GetRuntimeClass());
	}
};

template <class CContext,class CInitDone = CCreateObject<CContext> >
	class CContextImpl: public CContextImplBase<CContext,CInitDone,CContextBase>
{
public:
#ifdef __DEBUG
	CContextImpl()
	{
		Debug("Create '%s'\n",CContext::GetRusName());
	}
	~CContextImpl()
	{
		Debug("Destroy '%s'\n",CContext::GetRusName());
	}
#endif

	#define cThis static_cast<const CContext*>(this)
	#define This static_cast<CContext*>(this)

	virtual CRuntimeClass *GetRuntimeClass() const
	{
		return CInitDone::GetRuntimeClass();
	}
	virtual char const *GetTypeString(void) const
	{
		return Lang ? CContext::GetRusName() : CContext::GetEngName();
	}

	// 

	virtual int GetNMethods(void) const
	{
		return CContext::MethCount;
	}
	virtual int FindMethod(char const *name) const
	{
		return CContext::FindMeth(name);
	}
	virtual char const *GetMethodName(int nMethod, int nLang) const
	{
		PMethItem Item=CContext::GetMeth(nMethod);
		return Item ? Item->Base.Names[nLang] : 0;
	}
	virtual int HasRetVal(int nMethod) const
	{
		PMethItem Item=CContext::GetMeth(nMethod);
		return Item && Item->Func ? TRUE : 0;
	}
	virtual int GetNParams(int nMethod) const
	{
		PMethItem Item=CContext::GetMeth(nMethod);
		return Item ? Item->ParamCount : 0;
	}

	virtual int GetParamDefValue(int nMethod, int nParam, CValue *pValue) const
	{
		PMethItem Item=CContext::GetMeth(nMethod);
		return Item && Item->GetDef && pValue ? (cThis->*Item->GetDef)(nParam,*pValue) : 0;
		//  nParam	 ParamCount  ,         GetDef
	}
	virtual int CallAsFunc(int nMethod, CValue &retVal, CValue **ppParams)
	{
		PMethItem Item=CContext::GetMeth(nMethod);
		return Item && Item->Func ? (This->*Item->Func)(ppParams,retVal),TRUE : 0;
		//  1     FALSE,        GetDef
		//     ,   BL_METHOD,     void  int   TRUE   return
	}
	virtual int CallAsProc(int nMethod, CValue **ppParams)
	{
		PMethItem Item=CContext::GetMeth(nMethod);
		return Item && Item->Proc ? (This->*Item->Proc)(ppParams),TRUE : 0;
		//  1     FALSE,        GetDef
		//     ,   BL_METHOD,     void  int   TRUE   return
	}

	// 

	virtual int GetNProps(void) const
	{
		return CContext::PropCount;
	}
	virtual int FindProp(char const *name) const
	{
		return CContext::FindProp(name);
	}
	virtual char const *GetPropName(int nProp, int nLang) const
	{
		PPropItem Item=CContext::GetProp(nProp);
		return Item ? Item->Base.Names[nLang] : 0;
	}

	virtual int IsPropReadable(int nProp) const
	{
		PPropItem Item=CContext::GetProp(nProp);
		return Item && Item->Read ? TRUE : 0;
	}
	virtual int GetPropVal(int nProp, CValue &Value) const
	{
		PPropItem Item=CContext::GetProp(nProp);
		return Item && Item->Read ? (cThis->*Item->Read)(Value),TRUE : 0;
		//  1     FALSE,        GetDef
		//     ,   BL_METHOD,     void  int   TRUE   return
	}

	virtual int IsPropWritable(int nProp) const
	{
		PPropItem Item=CContext::GetProp(nProp);
		return Item && Item->Write ? TRUE : 0;
	}
	virtual int SetPropVal(int nProp, CValue const &Value)
	{
		PPropItem Item=CContext::GetProp(nProp);
		return Item && Item->Write ? (This->*Item->Write)(Value),TRUE : 0;
		//  1     FALSE,        GetDef
		//     ,   BL_METHOD,     void  int   TRUE   return
	}

	#undef This
	#undef cThis
};

} // namespace contimpl

using contimpl::CNoCreate;
using contimpl::CContextBase;
using contimpl::CContextImplBase;
using contimpl::CContextImpl;
