// 1cheaders.h

#ifndef _1C_HEADERS_H
#define _1C_HEADERS_H

#include <afxcview.h> 
#include <comdef.h>
#include <afxctl.h>
#include <afxtempl.h>
#include <functional>
#include <set>
#include <vector>
#include <map>

//   1 
#define IMPORT_1C __declspec(dllimport)

#include "../1cheaders/types.h"
#include "../1cheaders/type32.h"
#include "../1cheaders/bkend.h"
#include "../1cheaders/br32.h"
#include "../1cheaders/frame.h"
#include "../1cheaders/basic.h"
#include "../1cheaders/blang.h"
#include "../1cheaders/dbeng32.h"
#include "../1cheaders/editr.h"
#include "../1cheaders/moxel.h"
//#include "../1cheaders/mxl2xl.h"
#include "../1cheaders/seven.h"
#include "../1cheaders/rgproc.h"
#include "../1cheaders/txtedt.h"
#include "../1cheaders/userdef.h"

using namespace std;

extern CApp7 *App;
extern CBkEndUI *UI;
extern CMetaDataCont *MD;
extern IzlibEngine *zlib;

int Init1CGlobal();
void Done1CGlobal();

#ifdef __DEBUG
	#define Debug DoDebug
#else
	#define Debug
#endif

CString GetErrorDescr(DWORD Error = 0);
void DoDebug(char *Format,...);
void StatusLine(LPCSTR Format,...);
void SMessage(MessageMarker Icon,LPCSTR Msg);
void SMessage(LPCSTR Msg);
void Message(LPCSTR Format,...);
void Message(MessageMarker Icon,LPCSTR Format,...);
void SRuntimeError(LPCSTR Msg);
void RuntimeError(LPCSTR Format,...);

inline bool Assert(bool Error,LPCSTR Msg)
{
	if (Error) return SRuntimeError(Msg),true;
	return false;
}

inline bool AssertPtr(LPCVOID Ptr,LPCSTR Msg)
{
	if (!Ptr) return SRuntimeError(Msg),true;
	return false;
}

inline bool AssertRes(HRESULT Result,LPCSTR Format)
{
	if (Result) return RuntimeError(Format,Result),true;
	return false;
}

#endif