//settings.h
//     
#pragma once

//   
#define OPT_SECTION(cppName)\
	struct cppName{\
		typedef prev_type<2, __LINE__-1>::type prev;\
		enum{idx = prev::idx+1};\
		static LPCSTR GetName(){return #cppName;}\
	};template<>struct prev_type<2, __LINE__>{typedef cppName type;};

#define STR_OPTION(cppName)\
	struct cppName{\
		typedef prev_type<1, __LINE__-1>::type prev;\
		typedef prev_type<2, __LINE__-1>::type section;\
		typedef cstr ret_val;\
		enum{idx = prev::idx + 1};\
		static LPCSTR GetName(){return #cppName;}\
	};template<>struct prev_type<1, __LINE__>{typedef cppName type;};\
	friend struct param<cppName>;

#define INT_OPTION(cppName)\
	struct cppName{\
		typedef prev_type<0, __LINE__-1>::type prev;\
		typedef prev_type<2, __LINE__-1>::type section;\
		typedef DWORD ret_val;\
		enum{idx = prev::idx + 1};\
		static LPCSTR GetName(){return #cppName;}\
	};template<>struct prev_type<0, __LINE__>{typedef cppName type;};\
	friend struct param<cppName>;

#define CMD_ARG(cppName, argName, HasParam)\
	struct cppName{\
		typedef prev_type<3, __LINE__-1>::type prev;\
		enum{idx = prev::idx + 1, iHasParam=HasParam,};\
		static LPCSTR GetArgName(){return argName;}\
	};template<>struct prev_type<3, __LINE__>{typedef cppName type;};\
	friend struct cmdargs<cppName>;

struct first_option{enum{idx = -1};};

//   

class CSettings
{
public:
	static CSettings& GetSettings(){return *m_pOneSettings;}
	static void Init(){new CSettings;}
	static void Done(){delete m_pOneSettings;}

	//   
	template<int t, int I>struct prev_type{typedef typename prev_type<t, I-1>::type type;};
	template<>struct prev_type<0, __LINE__>{typedef first_option type;};	// DWORD option
	template<>struct prev_type<1, __LINE__>{typedef first_option type;};	// CString option
	template<>struct prev_type<2, __LINE__>{typedef first_option type;};	// Section
	template<>struct prev_type<3, __LINE__>{typedef first_option type;};	// CmdArgs

	
	template<typename T>
	struct param{
		static typename T::ret_val Get(){return options<T::ret_val>::Get(T::idx);}
		static void Set(typename T::ret_val value){options<T::ret_val>::Set(T::idx, value);}
	};
	
	template<typename T>
	struct cmdargs
	{
		cstr val;
		cmdargs() : val(m_pOneSettings->m_cmdLineArgs[T::idx]){}
		operator cstr (){return val;}
		operator BOOL () {return !val.IsEmpty();}
		BOOL operator !() {return val.IsEmpty();}
	};
	//   

	/*
	 :
		OPT_SECTION() -   
		STR_OPTION() -   
		INT_OPTION() -   
	 :
		value = CSettings::param<>::Get();
	 :
		CSettings::param<>::Set(value);
	
	   :
	CSettings::cmdargs<NameOfArg>();
	*/
	
	OPT_SECTION(Main)
		STR_OPTION(PathTo1C)
		STR_OPTION(LastBase)
	OPT_SECTION(Position)
		INT_OPTION(Top)
		INT_OPTION(Left)
		INT_OPTION(Right)
		INT_OPTION(Bottom)
	OPT_SECTION(HotKeys)
		INT_OPTION(RunEnterprise)
		INT_OPTION(RunMonopole)
		INT_OPTION(RunConfig)
		INT_OPTION(RunDebug)
		INT_OPTION(RunMonitor)

	CMD_ARG(DefaultDir, "--cd", 1)
	CMD_ARG(CmdRunEnterprise, "enterprise", 0)
	CMD_ARG(CmdRunMonopole, "/m", 0)
	CMD_ARG(CmdRunConfig, "config", 0)
	CMD_ARG(CmdRunDebug, "debug", 0)
	CMD_ARG(CmdRunMonitor, "monitor", 0)
	CMD_ARG(CmdIBDir, "/d", 1)

	//   
	typedef prev_type<0, __LINE__>::type lastIntOption;
	typedef prev_type<1, __LINE__>::type lastStrOption;
	typedef prev_type<3, __LINE__>::type lastCmdArg;
	//   


	void Save();
	cstr GetIniDir()		{return m_iniDir;}
	cstr GetCmnIniDir()		{return m_cmnIniDir;}

	template<typename T>
	struct options{
		static cstr Get(DWORD idx){return m_pOneSettings->GetString(idx);}
		static void Set(DWORD idx, cstr value){m_pOneSettings->SetString(idx, value);}
	};
	template<>
	struct options<DWORD>{
		static DWORD Get(DWORD idx){return m_pOneSettings->GetDword(idx);}
		static void Set(DWORD idx, DWORD value){m_pOneSettings->SetDword(idx, value);}
	};
	friend options<cstr>;
	friend options<DWORD>;
	
	cstr GetString(DWORD idx)				{return m_strParams[idx];}
	DWORD GetDword(DWORD idx)				{return m_dwParams[idx];}
	void SetString(DWORD idx, cstr value)	{m_strParams[idx] = value;}
	void SetDword(DWORD idx, DWORD value)	{m_dwParams[idx] = value;}

	cstr GetUnknownCmdArg(){return m_UnknownCmdArg;}
	
protected:
	CSettings();
	~CSettings();
	void Load();
	
	static CSettings* m_pOneSettings;

	CString m_iniDir, m_cmnIniDir, m_iniPath, m_UnknownCmdArg;

	
	CString m_strParams[lastStrOption::idx+1];
	CString m_cmdLineArgs[lastCmdArg::idx + 1];
	DWORD m_dwParams[lastIntOption::idx+1];
};

void LoadString(LPCSTR section, LPCSTR key, cstr path, CString& str);
