//settings.cpp
#include "StdAfx.h"
#include "settings.h"

CSettings* CSettings::m_pOneSettings = NULL;

void LoadString(LPCSTR section, LPCSTR key, cstr path, CString& str)
{
	for(DWORD len, size=64;;)
	{
		if((len=GetPrivateProfileString(section, key, "", str.GetBuffer(size), size, path)) < size-1)
			break;
		size*=2;
	}
	str.ReleaseBuffer(len);
}

template<typename T>
void LoadStringKey(cstr iniPath, CString strArray[], const T&)
{
	LoadString(T::section::GetName(), T::GetName(), iniPath, strArray[T::idx]);
	LoadStringKey(iniPath, strArray, T::prev());
}
template<>
void LoadStringKey<first_option>(cstr iniPath, CString strArray[], const first_option&)
{
}

template<typename T>
void LoadDwordKey(cstr iniPath, DWORD dwArray[], const T&)
{
	dwArray[T::idx]=GetPrivateProfileInt(T::section::GetName(), T::GetName(), -1, iniPath);
	LoadDwordKey(iniPath, dwArray, T::prev());
}
template<>
void LoadDwordKey<first_option>(cstr iniPath, DWORD dwArray[], const first_option&)
{
}

template<typename T>
void SaveStringKey(cstr iniPath, CString strArray[], const T&)
{
	SaveStringKey(iniPath, strArray, T::prev());
	WritePrivateProfileString(T::section::GetName(), T::GetName(), strArray[T::idx], iniPath);
}
template<>
void SaveStringKey<first_option>(cstr iniPath, CString strArray[], const first_option&)
{
}

template<typename T>
void SaveDwordKey(cstr iniPath, DWORD dwArray[], const T&)
{
	SaveDwordKey(iniPath, dwArray, T::prev());
	CString val;
	val.Format("0x%X", dwArray[T::idx]);
	WritePrivateProfileString(T::section::GetName(), T::GetName(), val, iniPath);
}
template<>
void SaveDwordKey<first_option>(cstr iniPath, DWORD dwArray[], const first_option&)
{
}

template<typename T>
void PrepeareCmdArgKeys(const T& t, CNoCaseMap<DWORD, DWORD, refkey_map>& strKeys)
{
	strKeys[T::GetArgName()] = T::idx | (T::iHasParam ? 0x80000000 : 0);
	PrepeareCmdArgKeys(T::prev(), strKeys);
}
template<>
void PrepeareCmdArgKeys<first_option>(const first_option& t, CNoCaseMap<DWORD, DWORD, refkey_map>& strKeys){}

void GetNextArg(LPCSTR& lpCmdLine, CString& val)
{
	val.Empty();
	//   
	while(*lpCmdLine && *lpCmdLine<=32)
		lpCmdLine++;
	if(!*lpCmdLine)
		return;
	//    ,     ,
	//  .
	char delim=' ';
	if(*lpCmdLine=='\"')
		delim='\"', lpCmdLine++;	//     
	LPCSTR pArg=lpCmdLine;
	while(*lpCmdLine && *lpCmdLine!=delim)
		lpCmdLine++;
	DWORD len = lpCmdLine - pArg;
	memcpy(val.GetBufferSetLength(len), pArg, len);
	if(*lpCmdLine == '\"')
		lpCmdLine++;
}

CSettings::CSettings()
{
	m_pOneSettings = this;
	LPCSTR lpCmdLine = GetCommandLine();
	CNoCaseMap<DWORD, DWORD, refkey_map> strKeys;
	PrepeareCmdArgKeys(lastCmdArg(), strKeys);
	CString val;
	GetNextArg(lpCmdLine, val);	//    
	for(;;)
	{
		GetNextArg(lpCmdLine, val);
		if(val.IsEmpty())
			break;
		DWORD idx;
		if(strKeys.Lookup(val, idx))
		{
			if(idx & 0x80000000) //  
			{
				GetNextArg(lpCmdLine, val);
				idx &=~ 0x80000000;
			}
			else
				val = " ";
			m_cmdLineArgs[idx] = val;
		}
		else
		{
			m_UnknownCmdArg += ' ';
			if(lpCmdLine[-1]=='\"')
				m_UnknownCmdArg += '\"';
			m_UnknownCmdArg += val;
			if(lpCmdLine[-1]=='\"')
				m_UnknownCmdArg += '\"';
		}
	}
	
	val = cmdargs<DefaultDir>();
	if(!val.IsEmpty())
	{
		if(FILE_ATTRIBUTE_DIRECTORY != (GetFileAttributes(val) & (0x80000000|FILE_ATTRIBUTE_DIRECTORY)))
			val.Empty();
	}
	if(val.IsEmpty())
		val.ReleaseBuffer(GetCurrentDirectory(MAX_PATH, val.GetBufferSetLength(MAX_PATH)));
	
	char uname[MAX_PATH];
	DWORD size = MAX_PATH;
	GetUserName(uname, &size);
	CString strFormat;
	strFormat.Format("\\ini\\%s\\", uname);

	LinkPath(val, strFormat, m_iniDir);
	if(m_iniDir[m_iniDir.GetLength()-1]=='\\')
		m_iniDir.GetBufferSetLength(m_iniDir.GetLength()-1);
	LinkPath(val, "\\ini\\+\\", m_cmnIniDir);
	if(m_cmnIniDir[m_cmnIniDir.GetLength()-1]=='\\')
		m_cmnIniDir.GetBufferSetLength(m_cmnIniDir.GetLength()-1);

	LinkPath(m_iniDir, "\\starter.ini", m_iniPath);

	Load();
}

CSettings::~CSettings()
{
	Save();
}

void CSettings::Load()
{
	LoadStringKey(m_iniPath, m_strParams, lastStrOption());
	LoadDwordKey(m_iniPath, m_dwParams, lastIntOption());
}

void CSettings::Save()
{

	if(CreateDirs(m_iniDir))
	{
		SaveStringKey(m_iniPath, m_strParams, lastStrOption());
		SaveDwordKey(m_iniPath, m_dwParams, lastIntOption());
	}
}