// iconlist.hpp
#pragma once
#include "resource.h"

struct SIconList
{
	SIconList()
	{
		SHFILEINFO fi;
		if(dwOSVersion>5000)
		{
			hList=ImageList_Duplicate((HIMAGELIST)SHGetFileInfo(NULL, 0, &fi, sizeof(fi),
				SHGFI_SYSICONINDEX|SHGFI_SMALLICON));
			ImageList_RemoveAll(hList);
		}
		else
			hList = ImageList_Create(16, 16, ILC_MASK | ILC_COLOR32, 0, 1);

		HIMAGELIST hShellList = (HIMAGELIST)SHGetFileInfo(NULL, 0, &fi, sizeof(fi),
			SHGFI_USEFILEATTRIBUTES|SHGFI_SYSICONINDEX|SHGFI_SMALLICON);
		HICON hOverlay = ImageList_GetIcon(hShellList, 1, ILD_TRANSPARENT);
		ImageList_AddIcon(hList, hOverlay);
		ImageList_SetOverlayImage(hList, 0, 1);
		DestroyIcon(hOverlay);
		
		SHGetFileInfo(NULL, FILE_ATTRIBUTE_DIRECTORY, &fi, sizeof(fi),
			SHGFI_ICON|SHGFI_SMALLICON|SHGFI_USEFILEATTRIBUTES);
		ImageList_AddIcon(hList, fi.hIcon);
		DestroyIcon(fi.hIcon);

		fi.hIcon = (HICON)LoadImage(hMyInst, (LPCTSTR)IDI_BASE, IMAGE_ICON, 16, 16, 0);
		ImageList_AddIcon(hList, fi.hIcon);
		DestroyIcon(fi.hIcon);
	}
	~SIconList()
	{
		ImageList_Destroy(hList);
	}
	
	DWORD GetIdxFromPath(cstr iconPath, int iconIdx, BOOL bIsBase)
	{
		int idx = bIsBase + 1;
		if(!iconPath.IsEmpty())
		{
			CString key;
			char strIconPathFull[MAX_PATH];
			ExpandEnvironmentStrings(iconPath, strIconPathFull, MAX_PATH);		
			key.Format("%s,%i", strIconPathFull, iconIdx);
			if(!mapIdx.Lookup(key, idx))
			{
				HICON hIcon;
				if(1==ExtractIconEx(iconPath, iconIdx, NULL, &hIcon, 1))
				{
					idx = ImageList_AddIcon(hList, hIcon);
					mapIdx[key] = idx;
					DestroyIcon(hIcon);
				}
			}
		}
		return idx;
	}

	HIMAGELIST hList;
	CNoCaseMap<int> mapIdx;
};
