//linkinfo.hpp
#pragma once
#include "data_gui_impl.hpp"

struct SLinkInfo
{
	SLinkInfo(cstr path, IShellLinkAPtr& pLink, IPersistFilePtr& pFile)
	{
		if(S_OK==pFile->Load(_bstr_t(path.operator LPCSTR()), STGM_READ))
		{
			//  . ,     .
			char buf[MAX_PATH];
			WIN32_FIND_DATA linkInfo;
			if(S_OK==pLink->GetPath(buf, MAX_PATH, &linkInfo, 0)
				&& (linkInfo.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				path2dst = buf;
				
				pLink->GetDescription(buf, MAX_PATH);
				descr = buf;
				
				pLink->GetIconLocation(buf, MAX_PATH, &icoIdx);
				iconPath = buf;

				pLink->GetArguments(cmdArgs.GetBuffer(4048), 4048);
				cmdArgs.ReleaseBuffer();
			}
		}
	}
	CString path2dst, iconPath, descr, cmdArgs;
	int icoIdx;
};

//   ,  
template<typename GUI, typename Impl>
class CLink : public CDataGuiItemImpl<GUI, Impl>
{
protected:
	enum	{IsLink = TRUE};
	typedef CLink<GUI, Impl> LinkBase;
	typedef BaseType::main_creator mc;

	CString m_path2dst, m_cmdArgs;
	CLink(DG_BaseType* parent, cstr t, cstr p, cstr path2dst, cstr cmdArgs)
		:BaseType(parent, t, p), m_path2dst(path2dst), m_cmdArgs(cmdArgs){}
	
	struct link_creator : mc
	{
		link_creator(DG_BaseType* p, cstr _t, cstr _p, const SLinkInfo& _li)
			:mc(p, _t, _p), li(_li){}
		ImplType* operator ()()const{return new ImplType(parent, t, p, li.path2dst, li.cmdArgs);}
		const SLinkInfo& li;
	};

	//       
	void SetIcon(gui_base& gui, const link_creator& lc)
	{
		//      ,     
		if(lc.li.iconPath.IsEmpty())
			BaseType::SetIcon(gui, lc);
		else	//   
			m_dwIconIdx = gui.GetIconIdx(lc.li.iconPath, lc.li.icoIdx, ImplType::IsBase);
	}
	//    
	void SetComment(const link_creator& lc)
	{
		//      ,    
		if(lc.li.descr.IsEmpty())
			BaseType::SetComment(lc);
		else	//   
			m_comment = lc.li.descr;
	}
	//    
	cstr GetFolder(){return m_path2dst;}

public:
	static DG_BaseType* Create(gui_base& gui, DG_BaseType* parent, cstr t, cstr p, const SLinkInfo& li)
	{
		return BaseType::Create(gui, link_creator(parent, t, p, li));
	}
};