// data_gui_impl.hpp
#pragma once
#include "data_gui.h"
#include "../injector/injector.h"
#include "../settings.h"

/*
     GUI    .
      ,    
     
*/
template<typename GUI>
class CDataGuiItemCmn : public CDataGuiItem<GUI>
{
protected:
	typedef CDataGuiItemCmn<GUI> DGC_BaseType;
	
	CString m_path, m_comment;
	DWORD m_dwIconIdx;

	CDataGuiItemCmn(DG_BaseType* parent, cstr t, cstr p)
		:DG_BaseType(parent, t), m_path(p){}
	BOOL DeleteFileObject(cstr file, HWND hParentWnd, BOOL bForce)
	{
		SHFILEOPSTRUCT fs;
		fs.hwnd = hParentWnd;
		fs.wFunc = FO_DELETE;
		fs.pTo = NULL;
		fs.fFlags = bForce || (GetKeyState(VK_SHIFT) & 0x8000) ? 0 : FOF_ALLOWUNDO;
		fs.fAnyOperationsAborted = FALSE;
		DWORD dwLen = file.GetLength() + 1;
		char* buf = new char[dwLen + 1];
		memcpy(buf, (LPCSTR)file, dwLen);
		buf[dwLen] = 0;
		fs.pFrom = buf;
		int ret = SHFileOperation(&fs);
		delete [] buf;
		return ret == 0 && fs.fAnyOperationsAborted==FALSE;
	}
	void OpenProps(cstr strPath, HWND hWnd)
	{
		SHELLEXECUTEINFO shi;
		memset(&shi, 0, sizeof(shi));
		shi.cbSize = sizeof(shi);
		shi.fMask = SEE_MASK_INVOKEIDLIST;
		shi.hwnd = hWnd;
		shi.lpVerb = "properties";
		shi.lpFile = strPath;
		ShellExecuteEx(&shi);
	}
};

template<typename GUI, typename Impl>
class CDataGuiItemImpl : public CDataGuiItemCmn<GUI>
{
protected:
	typedef CDataGuiItemImpl<GUI, Impl> BaseType;
	typedef Impl ImplType;

	enum{
		IsLink = FALSE, IsBase = FALSE,
	};
	
	CDataGuiItemImpl(DG_BaseType* parent, cstr t, cstr p)
		:DGC_BaseType(parent, t, p){}
	
	struct main_creator
	{
		main_creator(DG_BaseType* p, cstr _t, cstr _p) : parent(p), t(_t), p(_p){}
		ImplType* operator ()()const {return new ImplType(parent, t, p);}
		DG_BaseType* parent;
		cstr t;
		cstr p;
	};
	
	template<typename T>
	static DG_BaseType* Create(gui_base& gui, const T& t)
	{
		ImplType* pData = t();
		pData->SetIcon(gui, t);
		pData->SetComment(t);
		return pData;
	}
	
	ImplType* real_this()
		{return static_cast<ImplType*>(this);}


	//   ,       
	//     -,    .
	//
	//       
	void SetIcon(gui_base& gui, const main_creator&)
	{
		CString iniFile = real_this()->GetFolder()+"\\desktop.ini";
		char strIconPath[MAX_PATH];
		GetPrivateProfileString(".shellclassinfo", "IconFile", "", strIconPath, MAX_PATH, iniFile);
		int idx = GetPrivateProfileInt(".shellclassinfo", "IconIndex", 0, iniFile);
		m_dwIconIdx = gui.GetIconIdx(strIconPath, idx, ImplType::IsBase);
	}
	//    
	void SetComment(const main_creator&)
	{
		CString iniFile = real_this()->GetFolder()+"\\desktop.ini";
		GetPrivateProfileString(".shellclassinfo", "InfoTip", "", m_comment.GetBuffer(MAX_PATH), MAX_PATH, iniFile);
		m_comment.ReleaseBuffer();
		if(m_comment.IsEmpty())
			m_comment = real_this()->GetFolder();
	}
	//    
	cstr GetFolder(){return m_path;}
	//       
	LPCSTR GetCmdLineArgs(){return NULL;}

	WORD GetAllowedModes(){return ImplType::IsBase ? gui_base::idRunAll : 0;}
	WORD GetAllowedOperations()
	{
		return
			gui_base::idOpenObject |
			(ImplType::IsLink ? gui_base::idDeleteLink : 0 );
	}

	void OnSelectImpl(gui_base& gui){}

	//    .
	virtual BOOL IsItBase(){return ImplType::IsBase;}
	virtual void GetToolTip(CString& text)
	{
		text = m_title;
		CString folder = real_this()->GetFolder();
		if(ImplType::IsBase)
			text=text + "\n  : \"" + folder + '\"';
		else
			text=text + "\n: \"" + folder + '\"';
		if(m_comment.CompareNoCase(folder))
			text = text + '\n' + m_comment;
	}
	//    GUI
	virtual void Insert(gui_base& gui, gui_item& parent)
	{
		gui.InsertItem(this, m_guiItem, m_dwIconIdx, ImplType::IsBase, ImplType::IsLink, parent);
	}
	
	//  -    GUI
	virtual void OnSelect(gui_base& gui)
	{
		gui.SetComment(m_comment);
		gui.SetRunModes(real_this()->GetAllowedModes());
		gui.SetOperation(real_this()->GetAllowedOperations());
		gui.SetOperToolTip(gui_base::idOpenObject, real_this()->GetFolder());
		real_this()->OnSelectImpl(gui);
	}
	//  
	virtual void DeleteLink(gui_base& gui, BOOL bForce)
	{
		if(ImplType::IsLink && DeleteFileObject(m_path, gui.GetHwnd(), bForce))
		{
			gui.DeleteItem(this);
			DeleteFromParent();
		}
	}
	//  
	virtual void OpenObject(gui_base& gui)
	{
		ShellExecute(gui.GetHwnd(), "open", real_this()->GetFolder(), NULL, NULL, SW_SHOW);
	}
	//   
	virtual void CreateLinkFolder(gui_base& gui)
	{
		if(real_this()->GetAllowedOperations() & gui_base::idCreateLinkFolder)
			gui.GetBaseList()->CreateLinkFolder(gui, this, real_this()->GetFolder());
	}
	//     
	virtual void CreateLink2LinkFolder(gui_base& gui)
	{
		if(real_this()->GetAllowedOperations() & gui_base::idCreateLink2LinkFolder)
			gui.GetBaseList()->CreateLink2LinkFolder(gui, this, real_this()->GetFolder());
	}
	//       
	virtual void CreateLink2BasesFolder(gui_base& gui)
	{
		if(real_this()->GetAllowedOperations() & gui_base::idCreateLink2BasesDir)
			gui.GetBaseList()->CreateLink2BasesFolder(gui, this, real_this()->GetFolder());
	}
	//      
	virtual void CreateLink2BaseDir(gui_base& gui)
	{
		if(real_this()->GetAllowedOperations() & gui_base::idCreateLink2BaseDir)
			gui.GetBaseList()->CreateLink2BaseDir(gui, this, real_this()->GetFolder());
	}
	//    
	virtual void CreateBaseDir(gui_base& gui)
	{
		if(real_this()->GetAllowedOperations() & gui_base::idCreateBaseDir)
			gui.GetBaseList()->CreateBaseDir(gui, this, real_this()->GetFolder());
	}
	//  
	virtual DWORD RunBase(WORD runMode)
	{
		if(real_this()->GetAllowedModes() & runMode)
		{
			DWORD dwRunMode = 0;
			switch(runMode)
			{
			case gui_base::idRunEnterprise:
				dwRunMode = runEnterprise;
				break;
			case gui_base::idRunMonopole:
				dwRunMode = runMonopole;
				break;
			case gui_base::idRunConfig:
				dwRunMode = runConfig;
				break;
			case gui_base::idRunDebug:
				dwRunMode = runDebug;
				break;
			case gui_base::idRunMonitor:
				dwRunMode = runMonitor;
				break;
			default:
				return ERROR_BAD_ARGUMENTS;
			}
			SetEnvironmentVariable(envUserIniPath, CSettings::GetSettings().GetIniDir());
			SetEnvironmentVariable(envCmnIniPath, CSettings::GetSettings().GetCmnIniDir());
			return Run1C(dwRunMode, real_this()->GetFolder(), real_this()->GetCmdLineArgs(),
				CSettings::param<CSettings::PathTo1C>::Get());
		}
		return -1;
	}
	virtual void OpenProps(gui_base& gui)
	{
		DGC_BaseType::OpenProps(real_this()->GetFolder(), gui.GetHwnd());
	}
	//   
	virtual void OpenLinkProps(gui_base& gui)
	{
		if(ImplType::IsLink)
			DGC_BaseType::OpenProps(m_path, gui.GetHwnd());
	}
	
	virtual void ToString(CString& str)
	{
		if(ImplType::IsBase)
			str = m_path;
		else
			str.Empty();
	}
	
public:
	
	static DG_BaseType* Create(gui_base& gui, DG_BaseType* parent, cstr t, cstr p)
	{
		return Create(gui, main_creator(parent, t, p));
	}
};
