// InputDlg.cpp : implementation file
//

#include "stdafx.h"
#include "starter.h"
#include "InputDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SHACF_DEFAULT                   0x00000000  // Currently (SHACF_FILESYSTEM | SHACF_URLALL)
#define SHACF_FILESYSTEM                0x00000001  // This includes the File System as well as the rest of the shell (Desktop\My Computer\Control Panel\)
#define SHACF_URLALL                    (SHACF_URLHISTORY | SHACF_URLMRU)
#define SHACF_URLHISTORY                0x00000002  // URLs in the User's History
#define SHACF_URLMRU                    0x00000004  // URLs in the User's Recently Used list.
#define SHACF_USETAB                    0x00000008  // Use the tab to move thru the autocomplete possibilities instead of to the next dialog/window control.
#define SHACF_FILESYS_ONLY              0x00000010  // This includes the File System
#define SHACF_AUTOSUGGEST_FORCE_ON      0x10000000  // Ignore the registry default and force the feature on.
#define SHACF_AUTOSUGGEST_FORCE_OFF     0x20000000  // Ignore the registry default and force the feature off.
#define SHACF_AUTOAPPEND_FORCE_ON       0x40000000  // Ignore the registry default and force the feature on. (Also know as AutoComplete)
#define SHACF_AUTOAPPEND_FORCE_OFF      0x80000000  // Ignore the registry default and force the feature off. (Also know as AutoComplete)

/////////////////////////////////////////////////////////////////////////////
// CInputDlg dialog


CInputDlg::CInputDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInputDlg)
	//}}AFX_DATA_INIT
}


void CInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_TEXT1, const_cast<CString&>(m_pInput->title1));
	DDX_Text(pDX, IDC_TEXT2, const_cast<CString&>(m_pInput->title2));
	DDX_Text(pDX, IDC_TEXT3, const_cast<CString&>(m_pInput->title3));
	DDX_Text(pDX, IDC_EDIT1, m_pInput->value1);
	DDX_Text(pDX, IDC_EDIT2, m_pInput->value2);
	DDX_Text(pDX, IDC_EDIT3, m_pInput->value3);
	//{{AFX_DATA_MAP(CInputDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInputDlg, CDialog)
	//{{AFX_MSG_MAP(CInputDlg)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInputDlg message handlers

BOOL CInputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	HWND lastInvisible = 0;
	
	m_he1 = ::GetDlgItem(m_hWnd, IDC_EDIT1);
	m_he2 = ::GetDlgItem(m_hWnd, IDC_EDIT2);
	m_he3 = ::GetDlgItem(m_hWnd, IDC_EDIT3);

	if(m_pInput->type1==ftNone)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_TEXT1), SW_HIDE);
		::ShowWindow(m_he1, SW_HIDE);
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON1), SW_HIDE);
		lastInvisible = m_he1;
	}
	else
	{
		if(m_pInput->type1 != ftPath)
			::ShowWindow(::GetDlgItem(m_hWnd, IDC_BUTTON1), SW_HIDE);
		else
		{
			HINSTANCE hShell = GetModuleHandle("shlwapi.dll");
			if(hShell)
			{
				HRESULT (__stdcall *pFunc)(HWND,DWORD) = (HRESULT(__stdcall *)(HWND,DWORD))GetProcAddress(hShell, "SHAutoComplete");
				if(pFunc)
					pFunc(m_he1, SHACF_FILESYSTEM | SHACF_AUTOSUGGEST_FORCE_ON);
			}
		}
	}

	if(m_pInput->type2==ftNone)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_TEXT2), SW_HIDE);
		::ShowWindow(m_he2, SW_HIDE);
		if(!lastInvisible)
			lastInvisible = m_he2;
	}

	if(m_pInput->type3==ftNone)
	{
		::ShowWindow(::GetDlgItem(m_hWnd, IDC_TEXT3), SW_HIDE);
		::ShowWindow(m_he3, SW_HIDE);
		if(!lastInvisible)
			lastInvisible =  m_he3;
	}
	if(lastInvisible)
	{
		CRect rcLastInvisible, rcButton;
		::GetWindowRect(lastInvisible, &rcLastInvisible);
		
		ScreenToClient(rcLastInvisible);
		GetDlgItem(IDOK)->GetWindowRect(rcButton);
		ScreenToClient(rcButton);
		int h = rcButton.bottom - rcButton.top;
		rcButton.top = rcLastInvisible.top;
		rcButton.bottom = rcButton.top + h;
		GetDlgItem(IDOK)->MoveWindow(rcButton);

		GetDlgItem(IDCANCEL)->GetWindowRect(rcButton);
		ScreenToClient(rcButton);
		h = rcButton.bottom - rcButton.top;
		rcButton.top = rcLastInvisible.top;
		rcButton.bottom = rcButton.top + h;
		GetDlgItem(IDCANCEL)->MoveWindow(rcButton);

		CRect rcWindow;
		GetWindowRect(rcWindow);
		GetClientRect(rcLastInvisible);
		rcWindow.bottom -= rcLastInvisible.bottom - rcButton.bottom - 4;

		MoveWindow(rcWindow);
	}

	SetWindowText(m_pInput->title);
	return TRUE;
}

BOOL CInputDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_CHAR)
	{
		int t = 0;
		if(pMsg->hwnd == m_he1 && m_pInput->type1 == ftTitle)
			t = 1;
		else if(pMsg->hwnd == m_he1 && m_pInput->type1 == ftPath)
			t = 2;
		else if(pMsg->hwnd == m_he2 && m_pInput->type2 == ftTitle)
			t = 1;
		else if(pMsg->hwnd == m_he2 && m_pInput->type2 == ftPath)
			t = 2;
		else if(pMsg->hwnd == m_he3 && m_pInput->type3 == ftTitle)
			t = 1;
		else if(pMsg->hwnd == m_he3 && m_pInput->type3 == ftPath)
			t = 2;
		if(t)
		{
			LPCSTR chInvalid = t==1 ? "\\/:*?\"><|" : "*?\"><|";
			if(strchr(chInvalid, pMsg->wParam))
			{
				CString text;
				text.Format(" : %c\n   %s",
					(char)pMsg->wParam, chInvalid);
				AfxMessageBox(text);
				return TRUE;
			}
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

static int CALLBACK BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	if(uMsg==BFFM_INITIALIZED && lpData)
		SendMessage(hwnd, BFFM_SETSELECTION, TRUE, lpData);
	return 0;
}

void CInputDlg::OnButton1() 
{
	UpdateData();
	char buf[MAX_PATH];
	BROWSEINFO bInfo;
	bInfo.hwndOwner=m_hWnd;
	bInfo.pidlRoot=NULL;
	bInfo.pszDisplayName=buf;
	bInfo.lpszTitle=" ";
	bInfo.ulFlags=(ULONG)BIF_RETURNONLYFSDIRS | 0x40;
	bInfo.iImage=0;
	bInfo.lpfn=BrowseCallbackProc;
	bInfo.lParam=(LPARAM)(LPCSTR)m_pInput->value1;

	LPITEMIDLIST lid=SHBrowseForFolder(&bInfo);
	if(lid)
	{
		SHGetPathFromIDList(lid,m_pInput->value1.GetBuffer(MAX_PATH));
		m_pInput->value1.ReleaseBuffer();
		if(m_pInput->type2 == ftTitle && m_pInput->value2.IsEmpty())
		{
			int delim = m_pInput->value1.ReverseFind('\\');
			if(delim>=0)
				m_pInput->value2 = m_pInput->value1.Mid(delim + 1);
		}
		UpdateData(FALSE);
	}
}
