// userform.cpp
#include "StdAfx.h"
#include "userform.h"
#include "../gui/olectrlwnd.h"
#include "../Traps'n'Hooks/mainframetrap.h"
#include <OLEIMPL2.H>

IMPLEMENT_DYNCREATE(CUserFormView, CView);
IMPLEMENT_DYNCREATE(CUserFormDoc, CDocument);

CMultiDocTemplate* CUserFormDoc::m_pTemplate = NULL;

void CUserFormCntrItem::OnActivateUI()
{
	COleDocObjectItem::OnActivateUI();
	//  NotifyHook   ,     
	//    .        .
	if(m_pInPlaceFrame != NULL && m_pInPlaceFrame->m_pFrameWnd->m_pNotifyHook == m_pInPlaceFrame)
		m_pInPlaceFrame->m_pFrameWnd->m_pNotifyHook = NULL;
	if(m_pInPlaceDoc != NULL && m_pInPlaceDoc->m_pFrameWnd->m_pNotifyHook == m_pInPlaceDoc)
		m_pInPlaceDoc->m_pFrameWnd->m_pNotifyHook = NULL;
}

CUserFormCntrItem::~CUserFormCntrItem()
{
	if(m_pInPlaceFrame != NULL && m_pInPlaceFrame->m_pFrameWnd->m_pNotifyHook == m_pInPlaceFrame)
		m_pInPlaceFrame->m_pFrameWnd->m_pNotifyHook = NULL;
	if(m_pInPlaceDoc != NULL && m_pInPlaceDoc->m_pFrameWnd->m_pNotifyHook == m_pInPlaceDoc)
		m_pInPlaceDoc->m_pFrameWnd->m_pNotifyHook = NULL;
}

BEGIN_MESSAGE_MAP(CUserFormView, CView)
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_COMMAND(ID_SET_PICTURE, OnSetControlPicture)
	ON_UPDATE_COMMAND_UI(ID_SET_PICTURE, OnUpdateSetControlPicture)
END_MESSAGE_MAP()

void CUserFormView::OnInitialUpdate()
{
	CView::OnInitialUpdate();
	ModifyStyle(0, WS_CLIPCHILDREN);
	m_pForm = static_cast<CUserFormDoc*>(m_pDocument)->GetUserFormItem();
	m_pForm->Activate(OLEIVERB_INPLACEACTIVATE, this);
	ResizeForm();
	_UserFormPtr form = m_pForm->m_lpObject;
	form->put_DesignMode(static_cast<CUserFormDoc*>(m_pDocument)->GetDesignMode() ? fmModeOn : fmModeOff);
	if(m_pDocument->GetDocTemplate())
	{
		CWnd* pWnd = GetParentFrame();
		static HICON hIcon = (HICON)LoadImage(hMyInst, (LPCSTR)IDI_MAIN, IMAGE_ICON, 16, 16, 0);
		pWnd->SetIcon(hIcon, FALSE);
	}
}

void CUserFormView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	ResizeForm();
}

void CUserFormView::ResizeForm()
{
	if(m_pForm)
	{
		CRect rc;
		GetClientRect(rc);
		CSize size(rc.Size());
		CClientDC dc(NULL);
		dc.DPtoHIMETRIC(&size);
		m_pForm->SetExtent(size);
		m_pForm->SetItemRects(&rc, &rc);
	}
}

void CUserFormView::OnDestroy()
{
	CView::OnDestroy();
	m_pForm->Deactivate();
	if(!m_pDocument->GetDocTemplate())	//    
		m_pDocument = NULL;
}

BOOL CUserFormView::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN)
	{
		if(m_pForm->m_pInPlaceFrame && m_pForm->m_pInPlaceFrame->m_lpActiveObject)
		{
			if(S_OK == m_pForm->m_pInPlaceFrame->m_lpActiveObject->TranslateAccelerator(pMsg))
				return TRUE;
		}
	}
	return FALSE;
}

void CUserFormView::Create(CDocument* pDoc, CWnd* pParent)
{
	m_pDocument = pDoc;
	m_pDocument->AddView(this);
	CreateEx(0, NULL, NULL, WS_CHILD|WS_VISIBLE, 0, 0, 0, 0, pParent->m_hWnd, 0);
	OnInitialUpdate();
}

struct SArrOfCtrls : CTypedPtrArray<CPtrArray, IDispatch*>
{
	~SArrOfCtrls()
	{
		IDispatch** ppDisp = (IDispatch**)GetData();
		for(DWORD s = m_nSize; s-- ;)
			(*ppDisp++)->Release();
	}
};

static void GetSelectedControlsWithPicture(_UserFormPtr& form, SArrOfCtrls& arrOfControls)
{
	ControlsPtr ctrls;
	form->get_Selected(&ctrls);
	if(ctrls == NULL)
		return;
	long count;
	ctrls->get_Count(&count);
	if(!count)	//     ,      
	{
		arrOfControls.Add((IDispatch*)form);
		form->AddRef();
	}
	else	//   - .  ,   ,    ""
	{
		IControlPtr ctrl;
		IDispatch* pObject;
		VARIANT vtPict;
		VariantInit(&vtPict);
		DISPPARAMS dParams={0, 0, 0, 0};

		for(long idx = 0; idx < count; idx++)
		{
			ctrls->_GetItemByIndex(idx, &ctrl);
			_UserFormPtr isForm = ctrl;
			if(isForm)	//    .     .
				GetSelectedControlsWithPicture(isForm, arrOfControls);
			else
			{
				//   ,  ,      ""
				ctrl->get_Object(&pObject);
				if(S_OK == pObject->Invoke(DISPID_PICTURE, IID_NULL, 0, DISPATCH_PROPERTYGET, &dParams, &vtPict, NULL, NULL))
				{
					VariantClear(&vtPict);
					arrOfControls.Add(pObject);
				}
				else
					pObject->Release();
			}
		}
	}
}

void CUserFormView::OnSetControlPicture()
{
	_UserFormPtr form = m_pForm->m_lpObject;
	SArrOfCtrls arrOfControls;
	GetSelectedControlsWithPicture(form, arrOfControls);
	if(DWORD s = arrOfControls.GetSize())
	{
		VARIANT vtPict;
		CPictureDialog7 dialog(TRUE);
		if(dialog.DoModal()==IDOK)
		{
			CPictureHolder7 pict;
			if(pict.CreateFromFile(dialog.GetPathName()))
				vtPict.pdispVal = pict.GetDispatch();
			else
				return;
		}
		else
		{
			if(AfxMessageBox(" ?", MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON2)==IDYES)
				vtPict.pdispVal = NULL;
			else
				return;
		}

		vtPict.vt = VT_DISPATCH;
		DISPID dPut = DISPID_PROPERTYPUT;
		DISPPARAMS dParams = {&vtPict, &dPut, 1, 1};
		for(DWORD i = 0; i<s ; i++)
			arrOfControls[i]->Invoke(DISPID_PICTURE, IID_NULL, 0, DISPATCH_PROPERTYPUT, &dParams, NULL, NULL, NULL);
	}
}

void CUserFormView::OnUpdateSetControlPicture(CCmdUI* pCmdUI)
{
	_UserFormPtr form = m_pForm->m_lpObject;
	SArrOfCtrls arrOfControls;
	GetSelectedControlsWithPicture(form, arrOfControls);
	pCmdUI->Enable(arrOfControls.GetSize() != 0);
}

void CUserFormDoc::Init()
{
	struct SUserFormTemplate : CMultiDocTemplate
	{
		SUserFormTemplate() : CMultiDocTemplate(0,
			RUNTIME_CLASS(CUserFormDoc),
			RUNTIME_CLASS(CChildFrame7),
			RUNTIME_CLASS(CUserFormView))
		{
			m_strDocStrings = "UserForm\nUserForm\nUserForm\n   (*.ufr)\n.ufr";
			m_hMenuShared = LoadMenu(hMyInst, (LPCSTR)IDR_USER_FORM_MENU);
			pMainApp->AddDocTemplate(this);
		}
	};
	m_pTemplate = new SUserFormTemplate;
}

CUserFormDoc::CUserFormDoc() : m_bDesignMode(TRUE), m_pItem(NULL)
{
	AfxGetModuleState()->m_nObjectCount-=2;
	EnableCompoundFile();
}

CUserFormDoc::~CUserFormDoc()
{
	AfxGetModuleState()->m_nObjectCount+=2;
}

void CUserFormDoc::SetDesignMode(BOOL bMode)
{
	if(bMode != m_bDesignMode)
	{
		m_bDesignMode = bMode;
		_UserFormPtr form = GetUserFormItem()->m_lpObject;
		form->put_DesignMode(m_bDesignMode ? fmModeOn : fmModeOff);
	}
}

BOOL CUserFormDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	//    MFC     .
	//      .  
	//   ,   IStorage   ,   .
	char buf[MAX_PATH];
	if(!SearchPath(NULL, lpszPathName, NULL, MAX_PATH, buf, NULL))
		return FALSE;
	try
	{
		CFile file(buf, CFile::modeRead | CFile::shareDenyWrite);
		DWORD size = file.GetLength();
		BYTE* pbData;
		HGLOBAL hGlobal;
		if (((hGlobal = GlobalAlloc(GMEM_FIXED, size)) != NULL) &&
			((pbData = (BYTE*)GlobalLock(hGlobal)) != NULL))
		{
			file.Read(pbData, size);
			GlobalUnlock(hGlobal);
		}
		else
			return FALSE;
		if(S_OK == CreateILockBytesOnHGlobal(hGlobal, TRUE, &m_lb))
		{
			if(S_OK == StgOpenStorageOnILockBytes(m_lb, NULL,
				STGM_READWRITE | STGM_SHARE_EXCLUSIVE, NULL, 0, &m_lpRootStg))
			{
				LoadFromStorage();	//     COleDocument
				m_strPathName = buf;
				return TRUE;
			}
		}
	}
	catch(CFileException* e)
	{
		e->ReportError();
		e->Delete();
	}
	return FALSE;
}

//     ,    ,
//    .
void CUserFormDoc::Serialize(CArchive& ar)
{
	if(ar.IsLoading())
		m_pItem = new CUserFormCntrItem(this);
	m_pItem->Serialize(ar);
}

BOOL CUserFormDoc::OnSaveDocument(LPCTSTR lpszPathName)
{
	try
	{
		CFile file(lpszPathName, CFile::modeWrite|CFile::modeCreate|CFile::shareExclusive);
		SaveToStorage();
		CommitItems(TRUE);
		HGLOBAL hGlobal;
		GetHGlobalFromILockBytes(m_lb, &hGlobal);
		DWORD size = GlobalSize(hGlobal);
		BYTE* pData = (BYTE*)GlobalLock(hGlobal);
		file.Write(pData, size);
		GlobalUnlock(hGlobal);
		return TRUE;
	}
	catch(CFileException* e)
	{
		e->ReportError();
		e->Delete();
	}
	return FALSE;
}

BOOL CUserFormDoc::OnNewDocument()
{
	if(!COleDocument::OnNewDocument())
		return FALSE;
	CreateILockBytesOnHGlobal(NULL, TRUE, &m_lb);
	StgCreateDocfileOnILockBytes(m_lb, STGM_CREATE | STGM_READWRITE | STGM_SHARE_EXCLUSIVE,
		0, &m_lpRootStg);
	
	m_pItem = new CUserFormCntrItem(this);
	if(!m_pItem->CreateNewItem(__uuidof(UserForm)))
	{
		delete m_pItem;
		return FALSE;
	}
	return TRUE;
}

void CUserFormDoc::SetModifiedFlag(BOOL bModified)
{
	if(!m_bDesignMode)
		return;
	COleDocument::SetModifiedFlag(bModified);
}

BOOL CUserFormDoc::IsModified()
{
	if(m_bDesignMode && m_pItem)
		return m_pItem->IsModified();
	return FALSE;
}

CUserFormDoc* CUserFormDoc::DesignForm(LPCSTR lpFile)
{
	if(lpFile)
	{
		char path[MAX_PATH];
		if(!SearchPath(NULL, lpFile, NULL, MAX_PATH, path, NULL))
			return NULL;
		for(POSITION pos = m_pTemplate->GetFirstDocPosition(); pos ;)
		{
			CDocument* pDoc = m_pTemplate->GetNextDoc(pos);
			if(!pDoc->GetPathName().CompareNoCase(path))
			{
				pos = pDoc->GetFirstViewPosition();
				pMainFrame->MDIActivate(pDoc->GetNextView(pos)->GetParentFrame());
				return (CUserFormDoc*)pDoc;
			}
		}
	}
	return (CUserFormDoc*)m_pTemplate->CMultiDocTemplate::OpenDocumentFile(lpFile, TRUE);
}
