// scriptimpl.cpp
#include "StdAfx.h"
#include "scriptimpl.h"
#include "../com_interfaces/tlibversion.h"
#include "../ov7.h"
#include "../com_interfaces/commontlb.h"
#include "../addin_work/addinmgrimpl.h"
#include "../Traps'n'Hooks/idletrap.h"


CNoCaseMap<CString> CScript::m_mapEngineNames;
IProcessDebugManager* CScript::m_pProcDebugManager = NULL;
IDebugApplication* CScript::m_pDebugApplication = NULL;
DWORD CScript::m_dwDebugCookie = 0;
CTypedPtrArray<CPtrArray, CScript*> CScript::m_unload;

static void ReleaseDisp(IDispatch* pDisp) {reinterpret_cast<IDispatch*>(reinterpret_cast<DWORD>(pDisp) & ~0x80000000)->Release();}
static void ReleaseScript(CScript* pScript) {pScript->CloseScript();}

CScript::CScript()
{
	m_dwRef = 1;
	m_EnterCount = 0;
	m_DelayUnload = 0;
	m_pForm = NULL;
}

CScript::~CScript()
{
	if(m_pEngine)
		m_pEngine = NULL;
	if(m_pDebugDocumentHelper)
	{
		m_pDebugDocumentHelper->Detach();
		m_pDebugDocumentHelper = NULL;
	}
	m_Items.ForEachValue(ReleaseDisp);
	FreeForm();
}

STDMETHODIMP CScript::GetLCID(LCID *plcid)
{
	return E_NOTIMPL;
}

STDMETHODIMP CScript::GetDocVersionString(BSTR *pszVersion)
{
	return E_NOTIMPL;
}

STDMETHODIMP CScript::OnScriptTerminate(const VARIANT *pvarResult, const EXCEPINFO *pexcepinfo)
{
	return S_OK;
}

STDMETHODIMP CScript::OnStateChange(SCRIPTSTATE ssScriptState)
{
	return S_OK;
}

STDMETHODIMP CScript::OnEnterScript(void)
{
	m_EnterCount++;
	return S_OK;
}

STDMETHODIMP CScript::GetWindow(HWND* phWnd)
{
	*phWnd = pMainFrame ? pMainFrame->m_hWnd : NULL;
	return S_OK;
}

STDMETHODIMP CScript::EnableModeless(BOOL)
{
	return S_OK;
}

HRESULT STDMETHODCALLTYPE CScript::QueryInterface(REFIID riid,void **ppvObject)
{
	if(!ppvObject)
		return E_POINTER;
	if(riid==IID_IActiveScriptSite)
		*ppvObject=static_cast<IActiveScriptSite*>(this);
	else if(riid==IID_IActiveScriptSiteWindow)
		*ppvObject=static_cast<IActiveScriptSiteWindow*>(this);
	else if(riid==IID_IActiveScriptSiteDebug)
		*ppvObject=static_cast<IActiveScriptSiteDebug*>(this);
	else if(riid==IID_IUnknown)
		*ppvObject=static_cast<IUnknown*>(static_cast<IActiveScriptSite*>(this));
	else
		return E_NOINTERFACE;
	m_dwRef++;
	return S_OK;
}

ULONG STDMETHODCALLTYPE CScript::AddRef()
{
	return ++m_dwRef;
}

ULONG STDMETHODCALLTYPE CScript::Release()
{
	ULONG dwRef = m_dwRef;
	if(!--dwRef)
		delete this;
	else
		m_dwRef = dwRef;
	return dwRef;
}

STDMETHODIMP CScript::OnLeaveScript(void)
{
	if(!--m_EnterCount && m_DelayUnload)
	{
		m_unload.Add(this);
		CIdleTrap::SetIdleHandler(&CScript::DelayUnload);
	}
	return S_OK;
}

int CScript::ReportError(IActiveScriptError *pse, BOOL bDebug)
{
	EXCEPINFO ei;
	BSTR      bstrLine = NULL;
	HRESULT   hr;
	DWORD ctx;
	ULONG lineNum;
	LONG posNum;
	hr=pse->GetSourceLineText(&bstrLine);
	pse->GetSourcePosition(&ctx, &lineNum, &posNum);
	CString line(bstrLine);
	::SysFreeString(bstrLine);
	pse->GetExceptionInfo(&ei);
	CString source(ei.bstrSource);
	CString descr(ei.bstrDescription);
	CString msg;
	msg.Format("  .\n"
		":   %s\n"
		":     %s\n"
		":   %i\n"
		":  %i\n"
		":      %i\n"
		": %s\n"
		": %s",
		m_DisplayName, m_Path, lineNum, posNum, ei.wCode, source, descr);
	if(!line.IsEmpty())
		msg=msg+"\n : "+line;
	UINT mbType=MB_OK;
	if(bDebug)
	{
		msg+="\n  ?";
		mbType = MB_YESNO;
	}
	return AfxMessageBox(msg, mbType);
}

STDMETHODIMP CScript::OnScriptError(IActiveScriptError *pse)
{
	ReportError(pse);
	return S_OK;
}

/*
bool CScriptImpl::Unload()
{
	if(m_pEngine!=NULL)
	{
		try{
			if(m_EnterCount)
			{
				m_pEngine->SetScriptState(SCRIPTSTATE_DISCONNECTED);
				m_DelayUnReload=1;
				return false;
			}
			m_pEngine->SetScriptState(SCRIPTSTATE_CLOSED);		
			m_pEngine=NULL;
		}
		catch(_com_error err)
		{
			DoMsgLine(err.ErrorMessage());
		}
		catch(...)
		{
			DoMsgLine("Error Unload Script");
		}
	}
	return true;
}
*/

STDMETHODIMP CScript::GetItemInfo(LPCOLESTR pstrName, DWORD dwReturnMask,
		IUnknown**  ppunkItem, ITypeInfo** ppti)
{
	if(dwReturnMask & SCRIPTINFO_ITYPEINFO)
	{
		if(!ppti)
			return E_POINTER;
		*ppti=NULL;
	}
	if(dwReturnMask & SCRIPTINFO_IUNKNOWN)
	{
		if(!ppunkItem)
			return E_POINTER;
		*ppunkItem = NULL;
	}
	CString name(pstrName);
	
	IDispatch* pItem;
	if(!m_Items.Lookup(CString(pstrName), pItem))
		return TYPE_E_ELEMENTNOTFOUND;

	if(dwReturnMask & SCRIPTINFO_IUNKNOWN)
	{
		*ppunkItem = pItem;
		pItem->AddRef();
	}
	if(dwReturnMask & SCRIPTINFO_ITYPEINFO)
	{
		IProvideClassInfoPtr pci = pItem;
		if(pci)
			pci->GetClassInfo(ppti);
		else
			pItem->GetTypeInfo(0, 0, ppti);
	}
	return S_OK;
}

LPCTSTR CScript::GetCurrentState()
{
	static const char* states[]={
		" ",
		"",
		"",
		"",
		"",
		""
	};
	SCRIPTSTATE st;
	m_pEngine->GetScriptState(&st);
	return states[st];
}

/*
bool CScriptImpl::ReloadScript()
{
	if(m_EnterCount)
	{
		m_DelayUnReload=2;
		CScriptImplManager::GetScriptManager()->AddDelayed(this);
		return false;
	}
	DoStsLine("  %s ...",m_FileName);
	CString FileText;
	// Open file
	try{
		CFile f(m_FileName,CFile::modeRead);
		int len=f.GetLength();
		f.Read(FileText.GetBufferSetLength(len),len);
		FileText.ReleaseBuffer();
	}catch(CFileException* pEx)
	{
		char buf[1024];
		pEx->GetErrorMessage(buf,1024);
		pEx->Delete();
		DoMsgLine("  \r\n%s\r\n%s  (%i)",mmRedErr,m_FileName,buf,pEx->m_lOsError);
		return false;
	}
	Unload();		//   
	m_pSelf->ResetAdded();
	CString name,engine;
	LPCTSTR pRead=FileText;
	ExtractEngineAndName(pRead,engine,name);	//        
	bool ret=CreateScript(pRead);
	if(ret)
		CScriptImplManager::GetScriptManager()->ConnectScript(this);
	DoStsLine("");
	m_DelayUnReload=0;
	if(m_pViewItem)
		m_pViewItem->FillMacros();
	return ret;
}
*/


/******************************************************************************
*  GetDocumentContextFromPosition -- Used by the language engine to delegate 
*  IDebugCodeContext::GetSourceContext and get the IDebugDocumentContext
*  associated with a position.
*  Parameters: dwSourceContext -- Host defined cookie which was passed to 
*                                 IActiveScriptParse::ParseScriptText or 
*                                 IActiveScriptParse::AddScriptlet when the 
*                                 text the engine is interested in was added.
*              uCharacterOffset -- Offset from the beginning of the script 
*                                  block
*              uNumChars -- Length of the script block
*              ppsc -- Address of the IDebugDocumentContext reference to be
*                      returned by this method
*  Returns: S_OK
*           E_INVALIDARG
*           E_POINTER
*           E_FALI
******************************************************************************/
STDMETHODIMP CScript::GetDocumentContextFromPosition(
		DWORD dwSourceContext,
		ULONG uCharacterOffset,
		ULONG uNumChars,
		IDebugDocumentContext **ppsc)
{
	HRESULT hr = E_FAIL;
	//Use the IDebugDocumentHelper for this CScriptImpl to delegate this call
	if(m_pDebugDocumentHelper)
	{
		ULONG ulStartPos;
		//Find out where this source context starts.
		hr = m_pDebugDocumentHelper->GetScriptBlockInfo(dwSourceContext,NULL, 
			&ulStartPos, NULL);
		//If that succeeded, then create an IDebugDocumentContext
		if(SUCCEEDED(hr))
		{
			hr=m_pDebugDocumentHelper->CreateDebugDocumentContext(
				ulStartPos + uCharacterOffset,uNumChars,ppsc);
		}
	}
	return hr;
}

/******************************************************************************
*  GetApplication -- Returns the debug application object associated with this 
*  script site. Provides a means for a smart host to define what application 
*  object each script belongs to. Script engines should attempt to call this 
*  method to get their containing application and resort to 
*  IProcessDebugManager::GetDefaultApplication if this fails. 
*
*  Parameters: ppda -- Address of the IDebugApplication pointer which this 
*                      method should fill.
*  Returns: S_OK
*           E_POINTER
*           E_FAIL
******************************************************************************/
STDMETHODIMP CScript::GetApplication(IDebugApplication **ppda)
{
	//if we were successful in creating an IDebugApplication in Initialize,
	//then return it here.
	if(m_pDebugApplication)
		return m_pDebugApplication->QueryInterface(IID_IDebugApplication, (void**)ppda);
	return E_FAIL;
}

/******************************************************************************
*  GetRootApplicationNode -- Gets the application node under which script 
*  documents should be added.  This method can return NULL if script documents 
*  should be top-level.
*  Parameters: ppdanRoot -- Address of the IDebugApplicationNode pointer which
*                           this method should fill
*  Returns: S_OK
*           E_POINTER
*           E_FAIL
******************************************************************************/
STDMETHODIMP CScript::GetRootApplicationNode(
                                          IDebugApplicationNode **ppdanRoot)
{
	HRESULT hr=E_FAIL;
	//If we were successful in creating an IDebugApplication in Initialize,
	//then call GetRootNode on it here.
	if(m_pDebugDocumentHelper)
	{
		hr=m_pDebugDocumentHelper->GetDebugApplicationNode(ppdanRoot);
		//hr=m_pDebugApplication->GetRootNode(ppdanRoot);
	}
	return hr;
}

/******************************************************************************
*  OnScriptErrorDebug -- Allows a smart host to control the handling of runtime 
*  errors.
*  Parameters: pErrorDebug -- the runtime error that occurred 
*              pfEnterDebugger -- whether to pass the error to the debugger to 
*                                 do JIT debugging
*              pfCallOnScriptErrorWhenContinuing -- whether to call 
*                                 IActiveScriptSite::OnScriptError() when the 
*                                 user decides to continue without debugging. 
*  Returns: S_OK
*           E_POINTER
*           E_FAIL
******************************************************************************/
STDMETHODIMP CScript::OnScriptErrorDebug(
                                      IActiveScriptErrorDebug *pErrorDebug,
                                      BOOL *pfEnterDebugger,
                                      BOOL *pfCallOnScriptErrorWhenContinuing)
{
	*pfCallOnScriptErrorWhenContinuing = TRUE;
	*pfEnterDebugger = TRUE;
	IActiveScriptError* pError=NULL;
	HRESULT hr=pErrorDebug->QueryInterface(IID_IActiveScriptError, (void**)&pError);
	if(hr==S_OK && pError)
	{
		*pfEnterDebugger = ReportError(pError, TRUE)==IDYES;
		pError->Release();
	}
	return S_OK;
}

void CScript::Init()
{
	m_mapEngineNames[".vbs"]="VBScript";
	m_mapEngineNames[".js"] ="JScript";

	BOOL IsDebugInit = FALSE;
	if(S_OK == CoCreateInstance(CLSID_ProcessDebugManager, NULL,
		CLSCTX_INPROC_SERVER | CLSCTX_INPROC_HANDLER | CLSCTX_LOCAL_SERVER, 
		IID_IProcessDebugManager, (void **)&m_pProcDebugManager))
	{
		//Next, create a debugger application to associate with the script we're 
		//running.  An "application" is the smallest unit that can be debugged.
		if(S_OK == m_pProcDebugManager->CreateApplication(&m_pDebugApplication))
		{
			//Set the name that will appear in the debugger heirarchy for this app.
			CString strName;

			strName.Format("OpenV7-%s <%s>", addin_mgr::GetModeName(), strInfos.strIBDirInCmdLine);
			if(S_OK == m_pDebugApplication->SetName(_bstr_t(strName.operator LPCTSTR())))
			{
				//Add the debugger application to the debug heirarchy of the debug manager
				//so it will appear in the debug window.
				if(S_OK == m_pProcDebugManager->AddApplication(m_pDebugApplication, &m_dwDebugCookie))
				{
					IsDebugInit = ((m_pDebugApplication->FIsAutoJitDebugEnabled()==TRUE) &&
						m_pDebugApplication->FCanJitDebug()==TRUE);
				}
			}
		}
	}
	
	if(!IsDebugInit)
	{
		if(m_pDebugApplication)
		{
			m_pProcDebugManager->RemoveApplication(m_dwDebugCookie);
			m_pDebugApplication->Release();
			m_pDebugApplication=NULL;
		}
		if(m_pProcDebugManager)
		{
			m_pProcDebugManager->Release();
			m_pProcDebugManager=NULL;
		}
	}
}

void CScript::Done()
{
	if(m_pDebugApplication)
	{
		m_pProcDebugManager->RemoveApplication(m_dwDebugCookie);
		m_pDebugApplication->Release();
		m_pDebugApplication=NULL;
	}
	if(m_pProcDebugManager)
	{
		m_pProcDebugManager->Release();
		m_pProcDebugManager=NULL;
	}
}

BOOL CScript::Create(cstr strPath)
{
	CString strSource;
	try
	{
		CFile file(strPath, CFile::modeRead | CFile::shareDenyWrite);
		DWORD len = file.GetLength();
		file.Read(strSource.GetBufferSetLength(len), len);
	}
	catch(CFileException* e)
	{
		e->Delete();
		return FALSE;		
	}
	m_Path = strPath;

	AddAddin("OpenV7", NULL, TRUE);
	AddAddin(addin_mgr::GetModeName(), NULL, TRUE);

	if(!ProcessSource(strSource))
		return FALSE;
	return TRUE;
}

static void GetLine(LPCSTR& ptr, CString& line)
{
	LPCSTR pStart = ptr;
	while(*ptr && *ptr!='\r')
		ptr++;
	if(DWORD len = ptr - pStart)
		memcpy(line.GetBufferSetLength(len), pStart, len);
	else
		line.Empty();
	if(*ptr)
		ptr+=2;
}

static inline DWORD sym(LPCSTR& ptr){return static_cast<DWORD>(static_cast<BYTE>(*ptr));}


static void SplitStr2Array(LPCSTR ptr, CStringArray& args)
{
	args.RemoveAll();
	LPCSTR pStart = ptr;
	for(;;)
	{
		while(sym(ptr) && sym(ptr) <= ' ')
			ptr++;
		if(!sym(ptr))
			break;
		pStart = ptr;
		DWORD delim = ' ';
		if(sym(ptr) == '\"')
			delim = '\"', pStart++, ptr++;

		while(sym(ptr) && sym(ptr) != delim)
			ptr++;
		args.Add(CString(pStart, ptr - pStart));

		if(sym(ptr) == '\"')
			ptr++;
	}
}

struct AddItems
{
	IActiveScriptPtr& engine;
	AddItems(IActiveScriptPtr& e) : engine(e){}
	void operator()(LPCSTR strItem, IDispatch*& pDisp)
	{
		DWORD dwFlags = SCRIPTITEM_ISVISIBLE|SCRIPTITEM_ISSOURCE;
		DWORD dwDisp = reinterpret_cast<DWORD>(pDisp);
		if(dwDisp & 0x80000000)
		{
			pDisp = reinterpret_cast<IDispatch*>(dwDisp & ~0x80000000);
			dwFlags |= SCRIPTITEM_GLOBALMEMBERS;
		}
		engine->AddNamedItem(_bstr_t(strItem), dwFlags);
	}
};

BOOL CScript::ProcessSource(cstr strSource)
{
	CString line;
	CStringArray args;
	LPCSTR ptr = strSource;
	int lines = 0;
	struct ModeFinder 
	{
		CNoCaseMap<int> mapKeys;
		ModeFinder()
		{
			mapKeys["$engine"] = 0;
			mapKeys["$displayname"] = 1;
			mapKeys["$addin"] = 2;
			mapKeys["$form"] = 3;
			mapKeys["$uniquename"] = 4;
		}
	};
	static ModeFinder mf;
	for(;;)
	{
		GetLine(ptr, line);
		if(!line.IsEmpty())
		{
			SplitStr2Array(line, args);
			int key, size = args.GetSize();

			if(mf.mapKeys.Lookup(args[0], key))
			{
				switch(key)
				{
				case 0:		// $engine
					if(size > 1)
						m_EngineName = args[1];
					break;
				case 1:		// $displayname
					if(size > 1)
						m_DisplayName = args[1];
					break;
				case 2:		// $addin
					if(size > 1)
					{
						LPCSTR strAlias = NULL;
						BOOL bIsGlobal = FALSE;
						if(size == 3)
						{
							if(!args[2].CompareNoCase("global"))
								bIsGlobal = TRUE;
							else
								strAlias = args[2];
						}
						else if(size > 3)
						{
							strAlias = args[2];
							bIsGlobal = args[3].CompareNoCase("global") == 0;
						}
						if(!AddAddin(args[1], strAlias, bIsGlobal))
						{
							DoMsgLine(" %s.\r\n    %s", mmRedErr, (LPCSTR)m_Path, (LPCSTR)args[1]);
							return FALSE;
						}
					}
					else
					{
						DoMsgLine(" %s.\r\n     $addin", mmRedErr, (LPCSTR)m_Path);
						return FALSE;
					}
					break;
				case 3:		// $form
					if(size > 1)
					{
						CString name = size > 2 ? args[2] : CString("Form");
						CString file = args[1];
						m_pForm = new CUserFormDoc;
						char buf[MAX_PATH];
						GetCurrentDirectory(MAX_PATH, buf);
						CString path = m_Path.Left(m_Path.ReverseFind('\\'));
						SetCurrentDirectory(path);
						
						BOOL bOpen = m_pForm->OnOpenDocument(file);
						SetCurrentDirectory(buf);
						if(!bOpen)
						{
							delete m_pForm;
							m_pForm = NULL;
							DoMsgLine(" %s.\r\n    %s", mmRedErr, (LPCSTR)m_Path, (LPCSTR)file);
							return FALSE;
						}
						_UserFormPtr form = m_pForm->GetUserFormItem()->m_lpObject;
						if(!m_Items.InsertExist(name, form))
						{
							form->AddRef();
							ControlsPtr ctrls;
							form->get_Controls(&ctrls);
							long cnt;
							ctrls->get_Count(&cnt);
							for(long i = 0; i<cnt ; i++)
							{
								IControlPtr ctrl;
								ctrls->_GetItemByIndex(i, &ctrl);
								BSTR bName;
								ctrl->get_Name(&bName);
								CString ctrlName(bName);
								SysFreeString(bName);
								if(!m_Items.InsertExist(ctrlName, ctrl))
									ctrl->AddRef();
							}
						}
						m_pForm->SetDesignMode(FALSE);
					}
					break;
				case 4:		// $uniquename
					if(size > 1)
					{
						m_UniqueName = args[1];
					}
				}
				lines++;
				continue;
			}
		}
		if(*ptr)
			ptr-=2;
		ptr -= line.GetLength();
		break;
	}
	if(m_UniqueName.IsEmpty())
		m_UniqueName = m_Path.Mid(m_Path.ReverseFind('\\') + 1);
	if(m_DisplayName.IsEmpty())
		m_DisplayName = m_UniqueName;
	
	CString strExist;

	InitEngine();
	if(m_pEngine == NULL)
		return FALSE;
	
	// Script Engine must support IActiveScriptParse for us to use it
	IActiveScriptParsePtr pParse=m_pEngine;
	if(pParse == NULL)
	{
		DoMsgLine(" %s\r\n  %s    .",
			mmRedErr, m_Path, m_EngineName);
		return FALSE;
	}
	BOOL bIsInit=FALSE;
	if(S_OK == pParse->InitNew() && S_OK == m_pEngine->SetScriptSite(this))
	{
		if(S_OK == m_pEngine->AddTypeLib(LIBID_OpenV7Lib, TLIB_MAJOR, TLIB_MINOR,0))
		{
			bIsInit = S_OK == pParse->ParseScriptText(_bstr_t((LPCSTR)ptr), NULL, NULL, NULL,
				0, lines, SCRIPTTEXT_ISVISIBLE, NULL, NULL);
		}
	}
	if(!bIsInit)
	{
		DoMsgLine(" %s\r\n    .",mmRedErr, m_Path);
		return FALSE;
	}

	m_Items.ForEachPair(AddItems(m_pEngine));

	return TRUE;
}

void CScript::InitEngine()
{
	if(m_EngineName.IsEmpty())
	{
		CString ext = m_Path.Mid(m_Path.ReverseFind('.'));
		if(!m_mapEngineNames.Lookup(ext, m_EngineName))
		{
			HKEY hKey;
			if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT, ext, 0, KEY_READ, &hKey))
			{
				char type[MAX_PATH];
				DWORD size=MAX_PATH;
				if(ERROR_SUCCESS == RegQueryValueEx(hKey, NULL, 0, NULL, (BYTE*)type, &size))
				{
					strcat(type,"\\ScriptEngine");
					HKEY hSubKey;
					if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT, type, 0, KEY_READ, &hSubKey))
					{
						size=MAX_PATH;
						if(ERROR_SUCCESS == RegQueryValueEx(hSubKey, NULL, 0, NULL, (BYTE*)type, &size))
							m_EngineName = type;
						RegCloseKey(hSubKey);
					}
				}
				RegCloseKey(hKey);
			}
			if(!m_EngineName.IsEmpty())
				m_mapEngineNames[ext]=m_EngineName;
		}
	}
	if(m_EngineName.IsEmpty())
		return;
	
	//Now we need to set up for Smart Debugging.  First, we need a Process Debug Manager.
	BOOL IsDebugInit = FALSE;
	if(m_pProcDebugManager)
	{
		//Create a new DebugDocumentHelper to use with the script added by the simple host.
		if(S_OK == m_pProcDebugManager->CreateDebugDocumentHelper(NULL, &m_pDebugDocumentHelper))
		{
			//Initialize the DebugDocumentHelper so it's ready to handle the script.
			if(S_OK == m_pDebugDocumentHelper->Init(m_pDebugApplication,
				_bstr_t(m_DisplayName), _bstr_t(m_Path), TEXT_DOC_ATTR_READONLY))
			{
				//Attach our DebugDocumentHelper to the debugger application.  The NULL
				//parameter indicates that the DebugDocumentHelper should be at the root
				//of the debug tree.
				IsDebugInit=(m_pDebugDocumentHelper->Attach(NULL)==S_OK);
			}
		}
	}
	if(!IsDebugInit)
	{
		if(m_pDebugDocumentHelper)
		{
			m_pDebugDocumentHelper->Detach();
			m_pDebugDocumentHelper=NULL;
		}
	}
	m_pEngine.CreateInstance(m_EngineName, NULL, CLSCTX_INPROC_SERVER|CLSCTX_INPROC_HANDLER);
}

BOOL CScript::AddAddin(cstr strName, LPCSTR cstrAlias, BOOL bGlobal)
{
	AddinObject* pAddinObject;
	AddinStore* pStore = addin_mgr::GetByUniqueName(strName);
	if(pStore && (pAddinObject = (AddinObject*)pStore->GetAddin()->Cast(aiObject)))
	{
		IDispatch* pDisp;
		pAddinObject->GetAddinObject(&pDisp);
		if(pDisp)
		{
			IDispatch* pDispStore = reinterpret_cast<IDispatch*>(reinterpret_cast<DWORD>(pDisp) | (bGlobal ? 0x80000000 : 0));
			if(m_Items.InsertExist(cstrAlias ? cstrAlias : strName, pDispStore))	// TRUE,    ,    
				pDisp->Release();
			return TRUE;
		}
	}
	return FALSE;
}

void CScript::CloseScript()
{
	if(m_pEngine)
	{
		if(m_EnterCount)
		{
			m_pEngine->SetScriptState(SCRIPTSTATE_DISCONNECTED);
			m_DelayUnload = 1;
		}
		else
			CloseEngine();
	}
	CScript::Release();
}

void CScript::CloseEngine()
{
	CScript::AddRef();
	m_pEngine->SetScriptState(SCRIPTSTATE_CLOSED);
	m_pEngine = NULL;
	CScript::Release();
}

void CScript::DelayUnload()
{
	for(DWORD i = 0, s = m_unload.GetSize(); i<s ;i++)
		m_unload[i]->CloseEngine();
	m_unload.RemoveAll();
	CIdleTrap::RemoveIdleHandler(&CScript::DelayUnload);
}
