// olectrlwnd.cpp
#include "StdAfx.h"
#include "olectrlwnd.h"
#include <occimpl.h>

class COleControlSiteWrap : public COleControlSite
{
public:
	void DoAttach(IOleControlPtr& ctrl, CWnd* pWnd, UINT id, DWORD dwStyle, const CRect& rc)
	{
		m_pWndCtrl=pWnd;
		ctrl->QueryInterface(IID_IOleObject, (void**)&m_pObject);
		m_pObject->SetClientSite(&m_xOleClientSite);
		GetEventIID(&m_iidEvents);
		// Try to quick-activate first
		BOOL bQuickActivated = QuickActivate();
		
		if (!bQuickActivated)
		{
			m_pObject->GetMiscStatus(DVASPECT_CONTENT, &m_dwMiscStatus);
			if (m_dwMiscStatus & OLEMISC_SETCLIENTSITEFIRST)
				m_pObject->SetClientSite(&m_xOleClientSite);
		}
		IPersistStoragePtr storage = m_pObject;
		ILockBytesPtr lb;
		IStoragePtr store;
		CreateILockBytesOnHGlobal(NULL, TRUE, &lb);
		StgCreateDocfileOnILockBytes(lb, STGM_CREATE|STGM_READWRITE|STGM_SHARE_EXCLUSIVE, 0, &store);
		HRESULT hr = storage->InitNew(store);

		if(!bQuickActivated)
		{
			if(!(m_dwMiscStatus & OLEMISC_SETCLIENTSITEFIRST))
			m_dwEventSink = ConnectSink(m_iidEvents, &m_xEventSink);
			m_dwPropNotifySink = ConnectSink(IID_IPropertyNotifySink,
				&m_xPropertyNotifySink);
		}
		m_dwNotifyDBEvents = ConnectSink(IID_INotifyDBEvents, &m_xNotifyDBEvents);
		m_nID = id;

		m_dwStyleMask = WS_GROUP | WS_TABSTOP;

		if(m_dwMiscStatus & OLEMISC_ACTSLIKEBUTTON)
			m_dwStyleMask |= BS_DEFPUSHBUTTON;

		if(m_dwMiscStatus & OLEMISC_INVISIBLEATRUNTIME)
			dwStyle &= ~WS_VISIBLE;

		m_dwStyle = dwStyle & m_dwStyleMask;
		
		m_pObject->QueryInterface(IID_IOleInPlaceObject,(LPVOID*)&m_pInPlaceObject);
		m_rect = rc;
		SetExtent();
		try{
		if(dwStyle & WS_VISIBLE)
			m_pObject->DoVerb(OLEIVERB_INPLACEACTIVATE, NULL, &m_xOleClientSite, 0, m_pCtrlCont->m_pWnd->m_hWnd, m_rect);
		else
		{
			m_rect.OffsetRect(-32000, -32000);
			DoVerb(OLEIVERB_INPLACEACTIVATE);
			DoVerb(OLEIVERB_HIDE);
			m_rect.OffsetRect(32000, 32000);
			m_pInPlaceObject->SetObjectRects(m_rect, m_rect);
		}
		}catch(...)
		{
		}

		GetControlInfo();
		AttachWindow();
	}
};


void COleCtrlWnd::AttachToCtrl(IOleControlPtr& ctrl, CWnd* pParent, CWnd* pWnd, const CRect& rc, UINT id, DWORD dwStyle)
{
	COleControlSiteWrap* pSite = NULL;
	COleCtrlWnd* pSiteParent = static_cast<COleCtrlWnd*>(pParent);
	pSiteParent->InitControlContainer();
	TRY
	{
		pSite = (COleControlSiteWrap*)afxOccManager->CreateSite(pSiteParent->GetCtrlCont());
	}
	END_TRY
	
	COleCtrlWnd* pOleWnd = (COleCtrlWnd*)pWnd;
	pOleWnd->SetSite(pSite);
	pSite->DoAttach(ctrl, pOleWnd, id, dwStyle, rc);
	pSiteParent->GetCtrlCont()->m_siteMap.SetAt(pSite->m_hWnd, pSite);
}