// ov7panel.cpp
#include "StdAfx.h"
#include "ov7panel.h"
#include "paneldoc.h"
#include "panelview.h"
#include "panelframe.h"
#include "../../com_interfaces/COMOpenV7.h"
#include "../../com_interfaces/panelsdef.h"
#include "../../addin_work/addinmgr.h"
#include "../../addin_work/addinmgrimpl.h"

BEGIN_MESSAGE_MAP(COpenV7Panel, CDockableWindow)
	//{{AFX_MSG_MAP(COpenV7Panel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

typedef CTypedPtrArray<CPtrArray, COpenV7Panel::SPanelInfo*> PanelsInfo;

static DWORD pUserPanelDef = 0;

SECControlBar* COpenV7Panel::FindBar(LPCSTR strCaption)
{
	for(POSITION pos=pMainFrame->m_listControlBars.GetHeadPosition();pos;)
	{
		SECControlBar* pCB=(SECControlBar*)pMainFrame->m_listControlBars.GetNext(pos);
		CString txt;
		pCB->GetWindowText(txt);
		if(!txt.CompareNoCase(strCaption))
		{
			if(strcmp("CDockBar7",pCB->GetRuntimeClass()->m_lpszClassName))
				return pCB;
		}
	}
	return NULL;
}

void COpenV7Panel::ShowBar(SECControlBar* pBar, BOOL bShow /* = TRUE */)
{
	if(pBar)
	{
		if(pBar->IsMDIChild())
		{
			CMDIChildWnd* pHolder=(CMDIChildWnd*)pBar->GetParentFrame();
			if(bShow)
			{
				pMainFrame->MDIActivate(pHolder);
				if(pBar->IsWindowVisible())
				{
					CWnd* pChild = pBar->GetWindow(GW_CHILD);
					while(pChild)
					{
						if(pChild->IsKindOf(RUNTIME_CLASS(CView)))
						{
							pChild->SetFocus();
							break;
						}
						pChild = pChild->GetWindow(GW_CHILD);
					}
					return;
				}
			}
			else
			{
				CMDIChildWnd* pChild = pMainFrame->MDIGetActive();
				if(pChild == pHolder)
					pMainFrame->MDINext();
				pHolder->SendMessage(WM_CLOSE);
				return;
			}
		}
		pMainFrame->ShowControlBar(pBar, bShow, TRUE);
		if(bShow)
		{
			CWnd* pChild = pBar->GetWindow(GW_CHILD);
			while(pChild)
			{
				if(pChild->IsKindOf(RUNTIME_CLASS(CView)))
				{
					pChild->SetFocus();
					break;
				}
				pChild = pChild->GetWindow(GW_CHILD);
			}
		}
		else
		{
			CMDIChildWnd* pChild = pMainFrame->MDIGetActive();
			if(pChild && pChild->IsWindowVisible())
			{
				pChild->ActivateFrame();
				if(CView* pView = pChild->GetActiveView())
					pView->SetFocus();
			}
		}
	}
}

int COpenV7Panel::DefineUserPanel(cstr strName, DWORD dwFlags, CString& strError)
{
	if(!(pUserPanelDef & 0x80000000))
	{
		strError = "      DefineUserPanels";
		return -1;
	}
	PanelsInfo* pPanels = reinterpret_cast<PanelsInfo*>(pUserPanelDef & ~0x80000000);

	DWORD s = pPanels->GetSize();
	if(s > idPanelLast - idPanelFirst)
	{
		strError.Format("  %i .  .", s);
		return -1;
	}
	if(strName.IsEmpty())
	{
		strError = "  ";
		return -1;
	}
	for(DWORD i = 0; i<s ;i++)
	{
		if(!strName.CompareNoCase(pPanels->GetAt(i)->name))
		{
			strError.Format(" %s     ", (LPCSTR)strName);
			return -1;
		}
	}
	SPanelInfo* pInfo = new SPanelInfo;
	pInfo->name = strName;
	pInfo->dwFlags = dwFlags;
	pInfo->pView = NULL;
	pPanels->Add(pInfo);
	return s;
}

BOOL COpenV7Panel::DefinePanelTab(DWORD idx, cstr strOwner, CString& strError)
{
	if(!(pUserPanelDef & 0x80000000))
	{
		strError = "      DefineUserPanels";
		return FALSE;
	}
	PanelsInfo* pPanels = reinterpret_cast<PanelsInfo*>(pUserPanelDef & ~0x80000000);
	DWORD s = pPanels->GetSize();
	if(idx >= s)
	{
		strError.Format("   : %i", idx);
		return FALSE;
	}
	
	for(DWORD i = 0 ; i < s ;i++)
	{
		SPanelInfo* pInfo = pPanels->GetAt(i);
		for(DWORD j = 0, k = pInfo->tabs.GetSize(); j<k ; j++)
		{
			if(!strOwner.CompareNoCase(pInfo->tabs.ElementAt(j)))
			{
				strError.Format(" %s     %i  %s",
					(LPCSTR)strOwner, j, (LPCSTR)pInfo->name);
				return FALSE;
			}
		}
	}
	AddinStore* pStore = addin_mgr::GetByUniqueName(strOwner);
	if(!pStore)
	{
		strError.Format("     %s", strOwner);
		return FALSE;
	}
	AddinWindow* pAddinWnd = (AddinWindow*)pStore->GetAddin()->Cast(aiWindow);
	if(!pAddinWnd || !pAddinWnd->CanCreateWnd())
	{
		strError.Format(" %s    ", strOwner);
		return FALSE;
	}
	pPanels->GetAt(idx)->tabs.Add(strOwner);
	return TRUE;
}

struct EventPanels : CCOMOpenV7::EventParam<CCOMOpenV7::idDefineUserPanels, 1>
{
	EventPanels()
	{
		pVars[0].vt = VT_DISPATCH;
		pVars[0].pdispVal = new CIPanelsDef;
	}
};

void COpenV7Panel::Init()
{
	//     ,   ,  
	//  
	pUserPanelDef = reinterpret_cast<DWORD>(new PanelsInfo) | 0x80000000;
	//   DefineUserPanels,     
	CCOMOpenV7::Get()->RaiseEvent(EventPanels());
	//     
	pUserPanelDef &= ~0x80000000;

	//  
	PanelsInfo* pPanels = reinterpret_cast<PanelsInfo*>(pUserPanelDef);
	DWORD s = pPanels->GetSize();
	for(DWORD idx = 0, id = idPanelFirst; idx < s ; idx++, id++)
	{
		SPanelInfo* pInfo = pPanels->GetAt(idx);
		if(pInfo->tabs.GetSize())
		{
			// 
			pMainApp->AddDocTemplate(new CTemplate7(
				id,
				RUNTIME_CLASS(CPanelDocument),
				RUNTIME_CLASS(CPanelFrame),
				RUNTIME_CLASS(CPanelView)));

			//       ToolBarManager
			//         /  
			//  trad'  .
			GetToolBarManager()->FUNC3(id, (char*)(LPCTSTR)pInfo->name, id, id,
				NULL, 0xE81D, 0, 1, 0x3F800000, 0x96);
		}
	}
}

COpenV7Panel::SPanelInfo* COpenV7Panel::GetInfo(CDocument* pDoc)
{
	int id = CTemplate7::GetDocumentTemplateID(pDoc) - idPanelFirst;
	if(id>=0)
	{
		PanelsInfo* pPanels = reinterpret_cast<PanelsInfo*>(pUserPanelDef);
		if(id < pPanels->GetSize())
			return pPanels->GetAt(id);
	}
	return NULL;
}