// OpenV7wnd.cpp
#include "StdAfx.h"
#include "OpenV7wnd.h"
#include "../../addin_work/addinmgrimpl.h"
#include "../../resource.h"
#include "../../Traps'n'Hooks/mainframetrap.h"
#include "../../ov7.h"
using namespace addin_mgr::impl;

COpenV7Wnd* COpenV7Wnd::m_pOne;

BEGIN_MESSAGE_MAP(COpenV7Wnd, CTreeCtrl)
	//{{AFX_MSG_MAP(COpenV7Wnd)
	ON_WM_CREATE()
	ON_WM_KEYDOWN()
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

int COpenV7Wnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	int ret = CTreeCtrl::OnCreate(lpCreateStruct);
	SendMessage(TVM_SETIMAGELIST, TVSIL_NORMAL, (LPARAM)m_icons.GetList());
	SHFILEINFO info;
	SHGetFileInfo(NULL, FILE_ATTRIBUTE_DIRECTORY, &info, sizeof(info), SHGFI_ICON | SHGFI_SMALLICON | SHGFI_USEFILEATTRIBUTES);
	ImageList_AddIcon(m_icons.GetList(), info.hIcon);
	DestroyIcon(info.hIcon);

	HICON hMacroses = (HICON)LoadImage(hMyInst, (LPCSTR)IDI_MACROS, IMAGE_ICON, 16, 16, 0);
	ImageList_AddIcon(m_icons.GetList(), hMacroses);
	DestroyIcon(hMacroses);
	FillTree(addin_mgr::pRootGroup, TVI_ROOT);
	return ret;
}

void COpenV7Wnd::FillTree(AddinGroup* pGroup, HTREEITEM hParent)
{
	HTREEITEM item = InsertItem(pGroup->Name(), 0, 0, hParent);
	static_cast<AddinGroupReal*>(pGroup)->hItem = item;
	AddinGroup* pChild = pGroup->Child();
	while(pChild)
	{
		FillTree(pChild, item);
		pChild = pChild->Next();
	}

	for(DWORD i = 0, size = pGroup->GetAddinsCount(); i < size; i++)
		InsertAddin(pGroup->GetAddin(i), item);
}

BOOL COpenV7Wnd::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN || pMsg->message == WM_CHAR)
	{
		if(!pMainFrame->PreTranslateMessage(pMsg))
		{
			::TranslateMessage(pMsg);
			::DispatchMessage(pMsg);
		}
		return TRUE;
	}
	return FALSE;
}

BOOL COpenV7Wnd::RunMacros()
{
	if(HTREEITEM hItem = GetSelectedItem())
	{
		if(1 == GetItemData(hItem))
		{
			if(AddinStore* pStore = (AddinStore*)GetItemData(GetNextItem(hItem, TVGN_PARENT)))
			{
				if(AddinMacroses* pMacroses = (AddinMacroses*)pStore->GetAddin()->Cast(aiMacroses))
				{
					if(!pMacroses->Invoke(GetItemText(hItem)))
						DoMsgLine("   ", mmRedErr);
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}

void COpenV7Wnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar == '\r')
	{
		if(RunMacros())
			return;
	}
	CTreeCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}

void COpenV7Wnd::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	HTREEITEM item = GetSelectedItem();
	if(item)
	{
		DWORD data = GetItemData(item);
		if(data > 1)
		{
			AddinStore* pStore = (AddinStore*)data;
			Addin* pAddin = pStore->GetAddin();
			HMENU hMenu = CreatePopupMenu();
			AddinUnload* pUnload = (AddinUnload*)pAddin->Cast(aiUnload);
			if(pUnload)
			{
				if(pUnload->CanUnload())
					AppendMenu(hMenu, MF_STRING, 1, "");
				if(pUnload->CanReload())
					AppendMenu(hMenu, MF_STRING, 2, "");
			}
			AddinMenu* pMenu = (AddinMenu*)pAddin->Cast(aiMenu);
			if(pMenu)
				pMenu->PrepeareMenu(hMenu);
			
			if(GetMenuItemCount(hMenu))
			{
				if(point.x < 0)
				{
					Select(item, TVGN_FIRSTVISIBLE);
					RECT rc;
					GetItemRect(item, &rc, TRUE);
					point.x = rc.left, point.y = rc.top;
					ClientToScreen(&point);
				}
				int ret = TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN|TPM_NONOTIFY|TPM_RETURNCMD|TPM_LEFTBUTTON,
					point.x, point.y, 0, m_hWnd, NULL);
				if(ret)
				{
					if(1 == ret)	// 
					{
						if(!addin_mgr::Unload(pStore, FALSE))
							AfxMessageBox(strOV7Error);
					}
					else if(2 == ret)
					{
						if(!addin_mgr::Unload(pStore, TRUE))
							AfxMessageBox(strOV7Error);
					}
					else
						pMenu->InvokeMenu(ret);
				}
			}
			DestroyMenu(hMenu);
		}
	}
}

void COpenV7Wnd::OnRButtonDown(UINT nFlags, CPoint point) 
{
	UINT fl;
	HTREEITEM item = HitTest(point,&fl);
	if(item)
		SelectItem(item);
}


void COpenV7Wnd::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	if(RunMacros())
		return;
	CTreeCtrl::OnLButtonDblClk(nFlags, point);
}

void COpenV7Wnd::RefreshTree(AddinStore *pStore, HTREEITEM hItem)
{
	if(!pStore)
	{
		DeleteItem(hItem);
		return;
	}
	Addin* pAddin = pStore->GetAddin();
	int iImage = pAddin->GetImageIdx(m_icons);
	SetItem(hItem, TVIF_PARAM|TVIF_IMAGE|TVIF_TEXT, pAddin->DisplayName(), iImage, iImage, 0, 0, (LPARAM)pStore);
	for(;;)
	{
		HTREEITEM hMacros = GetNextItem(hItem, TVGN_CHILD);
		if(hMacros)
			DeleteItem(hMacros);
		else
			break;
	}
	FillMacroses(hItem, pAddin);
	static_cast<AddinStoreReal*>(pStore)->hItem = hItem;
}

void COpenV7Wnd::FillMacroses(HTREEITEM hAddin, Addin* pAddin)
{
	if(AddinMacroses* pMacroses = (AddinMacroses*)pAddin->Cast(aiMacroses))
	{
		CStringArray names;
		pMacroses->GetMacroses(names);
		for(DWORD j = 0, s=names.GetSize(); j<s ;j++)
		{
			HTREEITEM hMacros = InsertItem(names[j], 1, 1, hAddin);
			SetItemData(hMacros, 1);
		}
	}
}

void COpenV7Wnd::InsertAddin(AddinStore* pStore, HTREEITEM hParent)
{
	AddinStoreReal* pRealStore = static_cast<AddinStoreReal*>(pStore);
	Addin* pAddin = pRealStore->GetAddin();
	int idx = pAddin->GetImageIdx(m_icons);
	pRealStore->hItem = InsertItem(pAddin->DisplayName(), idx, idx, hParent);
	SetItemData(pRealStore->hItem, (DWORD)pStore);
	FillMacroses(pRealStore->hItem, pAddin);
}

static void FreeGroup(AddinGroup* pGroup)
{
	static_cast<AddinGroupReal*>(pGroup)->hItem = NULL;
	AddinGroup* pChild = pGroup->Child();
	while(pChild)
	{
		FreeGroup(pChild);
		pChild = pChild->Next();
	}
}

void COpenV7Wnd::OnDestroy()
{
	CTreeCtrl::OnDestroy();
	for(DWORD idx = 0, size = addin_mgr::Addins.GetSize(); idx < size ; idx++)
		static_cast<AddinStoreReal*>(addin_mgr::Addins[idx])->hItem = NULL;
	FreeGroup(addin_mgr::pRootGroup);
		
}
