// tlb_holder.cpp
#include "StdAfx.h"
#include "tlb_holder.h"

BOOL tlb_holder::_InitTypeLib(ITypeLib*& pLib, HINSTANCE hInst, REFGUID libID, WORD wMajor, WORD wMinor)
{
	//          GUID ,
	//  ,     ,   
	//  .
	CString strMyPath;
	strMyPath.ReleaseBuffer(GetModuleFileName(hInst,
		strMyPath.GetBufferSetLength(MAX_PATH), MAX_PATH));
	BOOL bNeedReg = TRUE;
	BSTR bPath = NULL;
	if(S_OK == QueryPathOfRegTypeLib(libID, wMajor, wMinor, 0, &bPath))
	{
		CString strRegPath = bPath;
		SysFreeString(bPath);
		if(!strRegPath.CompareNoCase(strMyPath))
			bNeedReg = FALSE;
	}
	bPath = strMyPath.AllocSysString();
	BOOL bRet = S_OK == LoadTypeLib(bPath, &pLib) && pLib != NULL;

	if(bRet)
	{
		if(!bNeedReg)
		{
			TLIBATTR* tAttr;
			pLib->GetLibAttr(&tAttr);
			if(tAttr->wMajorVerNum != wMajor || tAttr->wMinorVerNum != wMinor)
				bNeedReg = TRUE;
			pLib->ReleaseTLibAttr(tAttr);
		}
		if(bNeedReg)
		{
			if(S_OK != RegisterTypeLib(pLib, bPath, NULL))
			{
				//    . ,     HKCR.
				//      HKCU\Software\classes
				HKEY hKey;
				CString subKey;
				subKey.Format("Software\\Classes\\TypeLib\\{%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}\\%i.%i\\0\\win32",
					libID.Data1, libID.Data2, libID.Data3, libID.Data4[0], libID.Data4[1],
					libID.Data4[2], libID.Data4[3], libID.Data4[4], libID.Data4[5], libID.Data4[6], libID.Data4[7],
					wMajor, wMinor);
				DWORD dw;
				if(ERROR_SUCCESS == RegCreateKeyEx(HKEY_CURRENT_USER, subKey, 0, NULL, 0, KEY_SET_VALUE, NULL, &hKey, &dw))
				{
					RegSetValueEx(hKey, NULL, 0, REG_SZ, (BYTE*)(LPCSTR)strMyPath, strMyPath.GetLength());
					RegCloseKey(hKey);
				}
			}
		}
	}
	SysFreeString(bPath);
	return bRet;
}
