// dispimpl.hpp
// (c)  

#pragma once
#include "tlb_holder.h"

template<typename T, typename C = T>
struct com_type : public T
{
	typedef T InterfaceType;
	typedef C CoClassType;
	static REFGUID GetIID() { return __uuidof(T); }
	static REFGUID GetCLSID() { return __uuidof(C); }
};

template<typename Impl, typename Base, typename TypeLibHolder = tlb_holder>
class CDispImpl :
	public Base
	,public ISupportErrorInfo
	,public IProvideClassInfo
{
public:
	typedef Impl ImplType;
	typedef Base BaseType;
	typedef TypeLibHolder TLH_Type;

	DWORD m_dwRef;
	static ITypeInfo*& GetTI(){static ITypeInfo* pInfo; return pInfo;}

	struct init_ti
	{
		init_ti()
		{
			TypeLibHolder::GetTypeLib()->GetTypeInfoOfGuid(Base::GetIID(), &GetTI());
		}
	};
	
	CDispImpl() : m_dwRef(1)
	{
		static init_ti _init_ti_;
	}
	virtual ~CDispImpl(){}
	// IDispatch
	STDMETHOD(GetTypeInfoCount)(UINT *pctinfo)
	{
		*pctinfo = 1;
		return S_OK;
	}
	STDMETHOD(GetTypeInfo)(UINT iTInfo, LCID, ITypeInfo **ppTInfo)
	{
		if(!ppTInfo)
			return E_POINTER;
		if(iTInfo != 0)
			return DISP_E_BADINDEX;
		*ppTInfo = GetTI();
		(*ppTInfo)->AddRef();
		return S_OK;
	}
	STDMETHOD(GetIDsOfNames)(REFIID, LPOLESTR *rgszNames, UINT cNames,
		LCID, DISPID *rgDispId)
	{
		return DispGetIDsOfNames(GetTI(), rgszNames, cNames, rgDispId);
	}

	STDMETHOD(Invoke)(DISPID dispIdMember, REFIID, LCID, WORD wFlags, DISPPARAMS *pDispParams,
		VARIANT *pVarResult, EXCEPINFO *pExcepInfo, UINT *puArgErr)
	{
		return DispInvoke(static_cast<IDispatch*>(this), GetTI(), dispIdMember, wFlags,
			pDispParams, pVarResult, pExcepInfo,puArgErr);
	}
	// ISupportErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		if(riid==BaseType::GetIID())
			return S_OK;
		return S_FALSE;
	}
	// IProvideClassInfo
	STDMETHOD(GetClassInfo)(ITypeInfo** ppTI)
	{
		if(!ppTI)
			return E_POINTER;
		return TLH_Type::GetTypeLib()->GetTypeInfoOfGuid(BaseType::GetCLSID(), ppTI);
	}
	// IUnknown
	STDMETHOD(QueryInterface)(REFIID riid, void **ppvObject)
	{
		if(!ppvObject)
			return E_POINTER;
		*ppvObject = NULL;
		if(!static_cast<ImplType*>(this)->QI(riid, ppvObject))
		{
			if(riid == IID_IDispatch)
				*ppvObject = static_cast<IDispatch*>(this);
			else if(riid == IID_IUnknown)
				*ppvObject= this;
			else if(riid == IID_ISupportErrorInfo)
				*ppvObject = static_cast<ISupportErrorInfo*>(this);
			else if(riid == IID_IProvideClassInfo)
				*ppvObject= static_cast<IProvideClassInfo*>(this);
			else
				return E_NOINTERFACE;
		}
		m_dwRef++;
		return S_OK;
	}
	virtual ULONG STDMETHODCALLTYPE AddRef(){return ++m_dwRef;}
	virtual ULONG STDMETHODCALLTYPE Release()
	{
		ULONG dwRef = m_dwRef;
		if(!--dwRef)
			delete static_cast<ImplType*>(this);
		else
			m_dwRef = dwRef;
		return dwRef;
	}
	void MakeErrorInfo(const CString& text)
	{
		ICreateErrorInfo* pError=NULL;
		CreateErrorInfo(&pError);
		if(pError)
		{
			BSTR bTxt = text.AllocSysString();
			pError->SetDescription(bTxt);
			SysFreeString(bTxt);
			pError->SetGUID(BaseType::GetIID());
			pError->SetSource(L"OpenV7");
			SetErrorInfo(0, (IErrorInfo*)pError);
		}

	}
	HRESULT SetError(HRESULT err, LPCTSTR format, ...)
	{
		va_list arg;
		va_start(arg, format);
		CString txt;
		txt.FormatV(format, arg);
		va_end(arg);
		MakeErrorInfo(txt);
		return err;
	}
	HRESULT SetOV7Error(HRESULT err = E_FAIL)
	{
		extern CString strOV7Error;
		MakeErrorInfo(strOV7Error);
		return err;
	}
	BOOL QI(REFIID riid, void** pObject)
	{
		if(riid == BaseType::GetIID())
		{
			*pObject = static_cast<BaseType::InterfaceType*>(this);
			return TRUE;
		}
		return FALSE;
	}
};

#define BEGIN_COM_MAP(par) BOOL QI(REFIID riid, void** pObject){
#define COM_INTERFACE_ENTRY(param) if(riid == __uuidof(param)){*pObject = static_cast<param*>(this);return TRUE;}
#define END_COM_MAP() return FALSE;}


template<typename E, typename Impl, typename I, typename C = I>
class CComEventsImpl
	:public com_type<I, C>
	,public IConnectionPoint
	,public IConnectionPointContainer
{
public:
	template<DISPID IDE, int PC>
	struct EventParam
	{
		enum{
			iParamCount = PC,
			idEvent = IDE,
		};
		DISPPARAMS dParams;
		VARIANTARG* pVars;
		
		EventParam()
		{
			pVars = iParamCount ? new VARIANTARG[iParamCount] : NULL;
			for(int i = 0; i < iParamCount; i++)
				VariantInit(pVars + i);
			dParams.cArgs = iParamCount;
			dParams.rgvarg = pVars;
			dParams.cNamedArgs = 0;
			dParams.rgdispidNamedArgs = NULL;
		}
		~EventParam()
		{
			if(iParamCount)
			{
				for(int i = 0; i < iParamCount; i++)
					VariantClear(pVars + i);
				delete [] pVars;
			}
		}
		DISPID GetDispID(){return idEvent;}
		void AfterInvoke(){}
	};

	struct EventNonParam : EventParam<0, 0>
	{
		DISPID dispIdEvent;
		EventNonParam(DISPID id) : dispIdEvent(id){}
		DISPID GetDispID(){return dispIdEvent;}
	};
	
	template<typename Op>
	void RaiseEvent(Op& op)
	{
		advisde_node* pNode = m_pFirstNode;
		while(pNode)
		{
			m_pProcessedNode = pNode;
			if(S_OK == pNode->pInterface->Invoke(op.GetDispID(), IID_NULL, 0,
				DISPATCH_METHOD, &op.dParams, NULL, NULL, NULL))
					op.AfterInvoke();
			if(!m_pProcessedNode)	//       
			{
				advisde_node* pDel = pNode;
				pNode = pNode->next;
				delete pDel;
			}
			else
				pNode = pNode->next;
		}
		m_pProcessedNode = NULL;
	}
	void RaiseEventNonParam(DISPID idEvent)
	{
		RaiseEvent(EventNonParam(idEvent));
	}
protected:
	struct advisde_node
	{
		advisde_node *next, *prev;
		E* pInterface;
	};
	advisde_node* m_pProcessedNode;
	advisde_node* m_pFirstNode;
	advisde_node* m_pLastNode;
	
	CComEventsImpl() : m_pFirstNode(NULL), m_pLastNode(NULL), m_pProcessedNode(NULL){}
	// IConnectionPoint
	STDMETHOD(GetConnectionInterface)(IID *pIID)
	{
		*pIID=__uuidof(E);
		return S_OK;
	}
	STDMETHOD(GetConnectionPointContainer)(IConnectionPointContainer **ppCPC)
	{
		if(!ppCPC)
			return E_POINTER;
		*ppCPC = static_cast<IConnectionPointContainer*>(this);
		return S_OK;
	}
	STDMETHOD(Advise)(IUnknown *pUnkSink, DWORD *pdwCookie)
	{
		E* pEvents = NULL;
		if(S_OK == pUnkSink->QueryInterface(__uuidof(E), (void**) &pEvents)
			&& pEvents)
		{
			advisde_node* pNode = new advisde_node;
			pNode->pInterface = pEvents;
			pNode->next = NULL;
			pNode->prev = m_pLastNode;
			if(m_pLastNode)
				m_pLastNode->next = pNode;
			m_pLastNode = pNode;
			if(!m_pFirstNode)
				m_pFirstNode = pNode;
			*pdwCookie = reinterpret_cast<DWORD>(pNode);
			return S_OK;
		}
		return CONNECT_E_CANNOTCONNECT;
	}
	STDMETHOD(Unadvise)(DWORD dwCookie)
	{
		advisde_node* pNode = reinterpret_cast<advisde_node*>(dwCookie);
		pNode->pInterface->Release();
		if(pNode->prev)
			pNode->prev->next = pNode->next;
		else
			m_pFirstNode = pNode->next;
		if(pNode->next)
			pNode->next->prev = pNode->prev;
		else
			m_pLastNode = pNode->prev;

		if(pNode != m_pProcessedNode)
			delete pNode;
		else
			m_pProcessedNode = NULL;
		return S_OK;
	}
	STDMETHOD(EnumConnections)(IEnumConnections **ppEnum)
	{
		return E_NOTIMPL;
	}
	// IConnectionPointContainer
	STDMETHOD(EnumConnectionPoints)(IEnumConnectionPoints **ppEnum)
	{
		return E_NOTIMPL;
	}
	STDMETHOD(FindConnectionPoint)(REFIID riid, IConnectionPoint **ppCP)
	{
		if(riid == __uuidof(E))
		{
			*ppCP = static_cast<IConnectionPoint*>(this);
			static_cast<Impl*>(this)->Impl::AddRef();
			return S_OK;
		}
		return CONNECT_E_NOCONNECTION;
	}
};
