// com_addinmgr.h
#pragma once
#include "dispimpl.hpp"
#include "commontlb.h"
#include "../addin_work/addinmgrimpl.h"

class CIAddinGroup : public CDispImpl<CIAddinGroup, com_type<IAddinGroup> >
{
public:
	CIAddinGroup(AddinGroup* pGroup);
	~CIAddinGroup();

	STDMETHOD(LoadAddin)(BSTR AddinPath, IAddin** ppAddin);
	STDMETHOD(get_Addin)(long Idx, IAddin* *pVal);
	STDMETHOD(get_AddinCount)(long *pVal);
	STDMETHOD(get_Next)(IAddinGroup* *pVal);
	STDMETHOD(get_FirstChild)(IAddinGroup* *pVal);
	STDMETHOD(get_Parent)(IAddinGroup* *pVal);
	STDMETHOD(get_Name)(BSTR *pVal);
	
	BEGIN_COM_MAP(CIAddinGroup)
		COM_INTERFACE_ENTRY(IAddinGroup)
	END_COM_MAP()
	
	AddinGroup* m_pGroup;
};

class CIAddin : public CDispImpl<CIAddin, com_type<IAddin> >
{
public:
	STDMETHOD(Unload)(/*[in, optional, defaultvalue(VARIANT_FALSE)]*/ VARIANT_BOOL Reload);
	STDMETHOD(get_Group)(/*[out, retval]*/ IAddinGroup* *pVal);
	STDMETHOD(InvokeMacros)(BSTR MacrosName, VARIANT_BOOL* Success);
	STDMETHOD(get_Macroses)(VARIANT *pVal);
	STDMETHOD(get_Object)(IDispatch* *pVal);
	
	STDMETHOD(get_FullPath)(BSTR *pVal);
	STDMETHOD(get_UniqueName)(BSTR *pVal);
	STDMETHOD(get_DisplayName)(BSTR *pVal);
	
	CIAddin(AddinStore* pStore);
	~CIAddin();
	AddinStore* m_pStore;

	BEGIN_COM_MAP(CIAddin)
		COM_INTERFACE_ENTRY(IAddin)
	END_COM_MAP()
	
};

class CIAddinMgr : public CDispImpl<CIAddinMgr, com_type<IAddinMgr> >
{
public:
	STDMETHOD(get_RootGroup)(IAddinGroup* *pVal);
	STDMETHOD(get_ByIdx)(long Idx, IAddin* *pVal);
	STDMETHOD(get_ByFullPath)(BSTR FullPath, IAddin* *pVal);
	STDMETHOD(get_ByUniqueName)(BSTR UniqueName, IAddin* *pVal);
	STDMETHOD(get_Count)(long *pVal);
	
	BEGIN_COM_MAP(CIAddinMgr)
		COM_INTERFACE_ENTRY(IAddinMgr)
	END_COM_MAP()
};

