// addinmgrimpl.cpp
#include "StdAfx.h"
#include <initguid.h>
#include "addinmgrimpl.h"
#include "ov7addin.h"
#include "../ov7.h"
#include "../Traps'n'Hooks/wininit.h"
#include "../traps'n'hooks/delaybkend.hpp"
#include "../Traps'n'Hooks/splash'n'main.h"
#include "../Traps'n'Hooks/idletrap.h"
#include "../Loaders/dll_loader.h"
#include "../Loaders/com_loader.h"
#include "../Loaders/script_loader.h"
#include "../com_interfaces/COMOpenV7.h"
#include "../com_interfaces/tlibversion.h"
#include "../com_interfaces/com_addinmgr.h"
#include "../gui/Panels/OpenV7wnd.h"


AddinGroup* AddinGroup::CreateChild(LPCSTR strName)
{
	AddinGroup **ppNext = &child;
	while(*ppNext)
	{
		if(!(*ppNext)->m_name.CompareNoCase(strName))
			return *ppNext;
		ppNext = &(*ppNext)->next;
	}
	return *ppNext = new AddinGroupReal(strName, this);
}

AddinGroupReal::~AddinGroupReal()
{
	if(pComGroup)
		pComGroup->m_pGroup = NULL;
}

AddinStoreReal::~AddinStoreReal()
{
	if(pComAddin)
		pComAddin->m_pStore = NULL;
}


namespace addin_mgr{
namespace impl{

AddinGroup* CreateGroup(cstr Name)
{
	return AddinGroupReal::CreateGroup(Name);
}

static inline char* ReadSection(LPCSTR strSection, LPCSTR strPath2ini)
{
	char *pLoad;
	DWORD size = 1024;
	for(;;)
	{
		pLoad = new char[size];
		if(GetPrivateProfileSection(strSection, pLoad, size, strPath2ini) == size -2)
		{
			delete [] pLoad;
			size *= 2;
		}
		else
			break;
	}
	return pLoad;
}

void DoLoadAddins(cstr strFolder, cstr strSection)
{
	if(strFolder.IsEmpty() || !SetCurrentDirectory(strFolder))
		return;
	CString strPath2ini = strFolder + "\\openv7.ini";
	//DoMsgLine("Load from %s", mmNone, strPath2ini);
	
	char *pLoad = ReadSection(strSection, strPath2ini);
	
	LPCSTR pRead = pLoad;
	AddinGroup* pGroup = pRootGroup;
	
	while(*pRead)
	{
		if(*pRead != '#')
		{
			if(!stricmp(pRead, "endgroup"))
			{
				if(pGroup->Parent())
					pGroup = pGroup->Parent();
			}
			else
			{
				BOOL bIsNewGroup = FALSE;
				LPCSTR pStart = pRead;
				while(*pRead && *pRead != '=')
					pRead++;
				if(*pRead == '=')
				{
					CString left(pStart, pRead - pStart);
					if(!left.CompareNoCase("group"))
					{
						CString right(++pRead);
						if(!right.IsEmpty())
						{
							pGroup = pGroup->CreateChild(right);
							bIsNewGroup = TRUE;
						}
					}
				}
				else
					pRead--;
				if(!bIsNewGroup)
					Load(pStart, pGroup);
			}
		}
		while(*++pRead);
		pRead++;
	}
	delete [] pLoad;
}

//      AfxWinInit  mfc42.dll
//      AfxGetApp()
void AddinMgrOnWinInit()
{
	//   
	pMainApp = static_cast<CApp7*>(AfxGetApp());
	//      
	SetTrapOnExitApp();
	//    OnIdle
	CIdleTrap::Init();
	
	//       
	CDelayedBkEndUI::On();
	//        
	SplashAndMainWndCreateTrap::Init();
	//   
	RegisterLoader(CDllLoader::GetPrefix(), new CDllLoader);
	RegisterLoader(CComLoader::GetPrefix(), new CComLoader);
	RegisterLoader(CScriptLoader::GetPrefix(), new CScriptLoader);

	//  
	char strCurDir[MAX_PATH], strProcessPath[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, strCurDir);
	
	GetModuleFileName(GetModuleHandle(NULL), strProcessPath, MAX_PATH);
	*strrchr(strProcessPath, '\\')=0;
	
	const CString& section = GetModeName();
	
	DoLoadAddins(strInfos.strIBDirInCmdLine, section);
	DoLoadAddins(strProcessPath, section);
	DoLoadAddins(strInfos.strStarterUserIniDir, section);
	DoLoadAddins(strInfos.strStarterCmnIniDir, section);
	DoLoadAddins(strInfos.strPath2OpenV7Starter.Left(strInfos.strPath2OpenV7Starter.ReverseFind('\\')), section);
	
	SetCurrentDirectory(strCurDir);
	//   AllPluginsInit
	CCOMOpenV7::Get()->RaiseEventNonParam(CCOMOpenV7::idAllAddinsInit);
}

void AddinMgrInit(Addin* pModeAddin)
{
	//    
	pRootGroup = CreateGroup(" ");

	//       
	tlb_holder::InitTypeLib(hMyInst, LIBID_OpenV7Lib, TLIB_MAJOR, TLIB_MINOR);
	//     - OpenV7    Init
	RegisterAddin(COV7Addin::Create(), pRootGroup);
	RegisterAddin(pModeAddin, pRootGroup);
	//    AfxWinInit
	SetTrapOnWinInit();
}

void AddinMgrDone()
{
	//    OnExitApp
	RaiseCppEvent(etBeforeExit, simple_handler());

	//     
	for(int i=0, s = Addins.GetSize(); i < s ; i++)
		delete (AddinStoreReal*) Addins[i];
	
	CoUninitialize();
}

AddinStore* RegisterAddin(Addin* pAddin, AddinGroup* pGroup)
{
	AddinStoreReal* pStore = new AddinStoreReal(pAddin, pGroup);
	AddinGroupReal::AddAddinToGroup(pStore, pGroup);
	idxByUniqueName.InsertExist(pAddin->UniqueName(), pStore);
	idxByFullPath.InsertExist(pAddin->FullPath(), pStore);
	Addins.Add(pStore);
	if(bAddinReload)
		bAddinReload = FALSE;
	else
	{
		if(static_cast<AddinGroupReal*>(pGroup)->hItem)
			COpenV7Wnd::Get()->InsertAddin(pStore, static_cast<AddinGroupReal*>(pGroup)->hItem);
	}

	pAddin->AfterRegister();
	return pStore;
}

void UnRegisterAddin(AddinStore* pStore)
{
	Addin* pAddin = pStore->GetAddin();
	AddinGroupReal* pGroup = static_cast<AddinGroupReal*>(pStore->GetGroup());
	idxByUniqueName.RemovePair(pAddin->UniqueName(), pStore);
	idxByFullPath.RemovePair(pAddin->FullPath(), pStore);
	for(DWORD i = 0, s = Addins.GetSize(); i<s ;i++)
	{
		if(Addins[i]==pStore)
		{
			Addins.RemoveAt(i);
			break;
		}
	}
	pGroup->RemoveAddin(pStore);
	delete static_cast<AddinStoreReal*>(pStore);
}

}//namespace impl
}//namespace addin_mgr

