// pluginmgr.cpp
#include "StdAfx.h"
#include "addinmgrimpl.h"
#include "../../injector/injector.h"
#include "../ov7.h"
#include "../gui/Panels/OpenV7wnd.h"

namespace addin_mgr{

LoadersMap Loaders;
AddinsArray Addins;
AddinIdx idxByUniqueName;
AddinIdx idxByFullPath;
AddinGroup* pRootGroup;

static inline void GetEnvVar(LPCSTR lpszVar, CString& dst)
{
	if(DWORD dwLen = GetEnvironmentVariable(lpszVar, NULL, 0))
		GetEnvironmentVariable(lpszVar, dst.GetBufferSetLength(dwLen-1), dwLen);
}

//   ov7x.dll   
void Init(Addin* pModeAddin)
{
	CoInitialize(NULL);
	//  ,  
	GetEnvVar(envUserIniPath, strInfos.strStarterUserIniDir);
	GetEnvVar(envCmnIniPath, strInfos.strStarterCmnIniDir);
	GetEnvVar(envStarterPath, strInfos.strPath2OpenV7Starter);
	GetEnvVar(envIBDir, strInfos.strIBDirInCmdLine);

	impl::AddinMgrInit(pModeAddin);
}

AddinStore* GetByUniqueName(LPCSTR strUniqueName)
{
	AddinStore* pStore = NULL;
	idxByUniqueName.Lookup(strUniqueName, pStore);
	return pStore;
}

AddinStore* GetByFullPath(LPCSTR strFullPath)
{
	AddinStore* pStore = NULL;
	idxByFullPath.Lookup(strFullPath, pStore);
	return pStore;
}

// ,  
AddinStore* Load(LPCSTR strPath, AddinGroup* pGroup)
{
	LPCSTR prefEnd = strchr(strPath, ':');
	if(prefEnd > strPath)
	{
		CString prefix(strPath, prefEnd - strPath);
		prefix.TrimLeft();
		prefix.TrimRight();
		AddinLoader* pLoader;
		if(Loaders.Lookup(prefix, pLoader))
		{
			AddinStore* pStore = NULL;
			Addin* pAddin = pLoader->LoadAddin(prefEnd + 1, pStore);
			if(pAddin)
			{
				if(!pStore)
					pStore = impl::RegisterAddin(pAddin, pGroup);
				return pStore;
			}
		}
	}
	return NULL;
}

//  
BOOL RegisterLoader(LPCSTR strPrefix, AddinLoader* pLoader)
{
	return !Loaders.InsertExist(strPrefix, pLoader);
}

BOOL Unload(AddinStore*& pStore, BOOL bReload)
{
	AddinStoreReal* pRealStore = static_cast<AddinStoreReal*>(pStore);
	Addin* pAddin = pRealStore->GetAddin();
	CString strUniqueName = pAddin->UniqueName();
	AddinUnload* pUnload = (AddinUnload*)pAddin->Cast(aiUnload);
	if(!pUnload)
	{
		strOV7Error.Format(" \"%s\"   ", (LPCSTR)strUniqueName);
		return FALSE;
	}
	if(!pUnload->CanUnload())
	{
		strOV7Error.Format(" \"%s\"    ", (LPCSTR)strUniqueName);
		return FALSE;
	}
	if(bReload && !pUnload->CanReload())
	{
		strOV7Error.Format(" \"%s\"    ", (LPCSTR)strUniqueName);
		return FALSE;
	}
	CString strLoadString;
	if(bReload)
		pUnload->GetLoadString(strLoadString);

	AddinWndSite* pSite = pRealStore->pWndSite;
	if(pSite)
		pSite->DestroyWnd();
	HTREEITEM hItem = pRealStore->hItem;
	
	if(!pUnload->Unload())
	{
		strOV7Error.Format(" \"%s\"   ", (LPCSTR)strUniqueName);
		if(pSite)
			pSite->CreateWnd(pAddin);
		return FALSE;
	}
	AddinGroup* pGroup = pStore->GetGroup();
	impl::UnRegisterAddin(pStore);
	impl::bAddinReload = bReload;
	pStore = bReload ? Load(strLoadString, pGroup) : NULL;
	pAddin = pStore ? pStore->GetAddin() : NULL;
	
	if(pSite)
	{
		if(pSite->CreateWnd(pAddin))
			static_cast<AddinStoreReal*>(pStore)->pWndSite = pSite;
	}
	if(hItem)
		COpenV7Wnd::Get()->RefreshTree(pStore, hItem);
	if(bReload && !pStore)
	{
		strOV7Error.Format(" \"%s\"   .  .", (LPCSTR)strUniqueName);
		return FALSE;
	}
	return TRUE;
}
}//	namespace addin_mgr
