// userhotkey.h
#pragma once
#include "../decl_import.h"
#include "../../common/common_api.h"

class CHotKeyTrap : public CWnd
{
public:
	class SKeyData
	{
	public:
		cstr GetAddin()			{ return addin; }
		cstr GetMacros()		{ return macros; }
		DWORD GetKey()			{ return key; }
		void SetCommand(cstr a, cstr m)
		{
			addin = a;
			macros = m;
		}
		OV7_COMMON_API BOOL SetKey(DWORD k);
		OV7_COMMON_API void GetString(CString& str);
	protected:
		friend class CHotKeyTrap;
		friend class CIHotKey;

		SKeyData(cstr a, cstr m, DWORD k)
			: addin(a), macros(m), key(k), pComObject(NULL) {}
		CString addin, macros;
		DWORD key;
		class CIHotKey* pComObject;
	};

	static void Init();

	static OV7_COMMON_API BOOL bCancelHotKey;
	
	static SKeyData* FindKey(DWORD key)
	{
		SKeyData* pData;
		if(Keys2Data.Lookup((void*)key, (void*&)pData))
			return pData;
		return NULL;
	}
	static DWORD GetCount()				{return Keys.GetSize();}
	static SKeyData* GetKey(DWORD idx)	{return Keys[idx];}

	static OV7_COMMON_API void RemoveKey(DWORD idx);
	static OV7_COMMON_API SKeyData* AddKey(DWORD key, cstr a, cstr m);
	static OV7_COMMON_API void ClearAll();

protected:
	friend class SKeyData;
	static CMapPtrToPtr OV7_COMMON_API Keys2Data;
	static CTypedPtrArray<CPtrArray, SKeyData*> OV7_COMMON_API Keys;
	BOOL PreTranslateMainFrameMsg(MSG* pMsg);
};
