// idletrap.cpp
#include "StdAfx.h"
#include "idletrap.h"
#include "../com_interfaces/COMOpenV7.h"

CTrapVirtual trOnIdle;
CMapPtrToPtr mapIdleFunc;

struct event_onidle
{
	typedef void (*type)();
	void operator ()(type p){p();}
};

BOOL CIdleTrap::OnIdleWrap(LONG lCount)
{
	if(!lCount)
	{
		CoFreeUnusedLibraries();
		void(*pFunc)();
		void* val;
		for(POSITION pos = mapIdleFunc.GetStartPosition(); pos ;)
		{
			mapIdleFunc.GetNextAssoc(pos, (void*&)pFunc, val);
			pFunc();
		}
		RaiseCppEvent(etOnIdle, event_onidle());
		CCOMOpenV7::Get()->RaiseEventNonParam(CCOMOpenV7::idIdle);
	}
	return (this->*mf_cast<BOOL(CIdleTrap::*)(long)>(trOnIdle.m_dwRealAdress))(lCount);
}

void CIdleTrap::SetIdleHandler(void(*pFunc)())
{
	mapIdleFunc[pFunc] = NULL;
}

void CIdleTrap::RemoveIdleHandler(void(*pFunc)())
{
	mapIdleFunc.RemoveKey(pFunc);
}

void CIdleTrap::Init()
{
	trOnIdle.SetTrap(pMainApp, 0x68/4, &CIdleTrap::OnIdleWrap);
}