// com_loader.cpp
#include "StdAfx.h"
#include "com_loader.h"
#include "../com_interfaces/commontlb.h"
#include "../com_interfaces/COMOpenV7.h"
#include "../com_interfaces/addininfo.hpp"
#include "../../common/common.h"
#include "../gui/olectrlwnd.h"
#include "../Traps'n'Hooks/mainframetrap.h"
#include "../scripts/userform.h"
#include <occimpl.h>

_COM_SMARTPTR_TYPEDEF(IComOpenV7Addin, __uuidof(IComOpenV7Addin));

class CTabWnd : public CWnd
{
public:
	BOOL PreTranslateMessage(MSG* pMsg)
	{
		if(pMsg->message == WM_KEYDOWN || pMsg->message == WM_CHAR)
		{
			if(m_pCtrlSite->m_pActiveObject &&
				m_pCtrlSite->m_pActiveObject->TranslateAccelerator(pMsg) == S_OK)
				return TRUE;
		}
		return FALSE;
	}
};


class CComAddin : public AddinImpl<type_list<
	AddinMacroses,	type_list<
	AddinObject,	type_list<
	AddinWindow,	type_list<
	AddinUnload,
	null_type> > > > >
{
public:
	static CComAddin* Create(IDispatchPtr& pObject, cstr strFullPath, cstr strID)
	{
		CString dn, un, lp("com");
		int iIconIdx = 0;
		
		IComOpenV7AddinPtr comaddin = pObject;
		if(comaddin)
		{
			CIAddinInfo* pInfo = new CIAddinInfo;
			if(S_OK == comaddin->Init(CCOMOpenV7::Get(), pInfo))
			{
				dn = pInfo->m_DispName;
				un = pInfo->m_UniName;
				iIconIdx = pInfo->m_IconIdx;
			}
			pInfo->Release();
		}
		if(dn.IsEmpty())
		{
			if(strFullPath.IsEmpty())
				dn = strID;
			else
				dn = strFullPath.Mid(strFullPath.ReverseFind('\\')+1);
		}
		if(un.IsEmpty())
			un = dn;
		return new CComAddin(pObject, iIconIdx, dn, un, strFullPath, lp);
	}
	CComAddin(IDispatchPtr& p, int iIconIdx, cstr dn, cstr un, cstr fp, cstr lp)
		:base_type(dn, un, fp, lp), m_pObject(p), m_IconIdx(iIconIdx) { }
	~CComAddin()
	{
		FreeObject();
		FreeWindow();
	}
protected:
	IDispatchPtr m_pObject;
	int m_IconIdx;

	void FreeObject()
	{
		IComOpenV7AddinPtr comaddin = m_pObject;
		if(comaddin)
			comaddin->Done();
		m_pObject = NULL;
	}
	void FreeWindow()
	{
		delete pAddinWnd;
	}

	// Addin
	virtual DWORD GetImageIdx(CIconList& IcoList)
	{
		DWORD idx = IcoList.GetImageIdx(strFullPath, m_IconIdx);
		if(-1 == idx)
			idx = IcoList.GetAssociatedIdx(strFullPath);
		return idx;
	}

	// AddinObject
	virtual void GetAddinObject(IDispatch** refObject)
	{
		*refObject = m_pObject;
		m_pObject->AddRef();
	}

	// AddinMacroses
	virtual void GetMacroses(CStringArray& names)
	{
		ExtractMacroses(m_pObject, names);
	}
	virtual BOOL Invoke(cstr Macros)
	{
		return InvokeMacros(m_pObject, Macros);
	}
	// AddinWindow
	virtual BOOL CanCreateWnd()
	{
		IOleControlPtr ctrl = m_pObject;
		return ctrl != NULL;
	}
	virtual void CreateWnd(CWnd* pParent)
	{
		IOleControlPtr ctrl = m_pObject;
		if(ctrl)
		{
			pAddinWnd = new CTabWnd;
			COleCtrlWnd::AttachToCtrl(ctrl, pParent, pAddinWnd, CRect(0, 0, 0, 0));
		}
	}
	virtual void FreeWnd() {FreeWindow();}
	// AddinUnload
	virtual BOOL CanUnload() { return TRUE; }
	virtual BOOL CanReload() { return FALSE;}
	virtual BOOL Unload()
	{
		FreeObject();
		CoFreeUnusedLibraries();
		return TRUE;
	}
	virtual void GetLoadString(CString& strLoad){}
};


Addin* CComLoader::LoadAddin(LPCSTR strPath, AddinStore*& pStore)
{
	//   com-:
	// 'com:'[] '|' ProgID | '{'CLSID'}'
	LPCSTR pDelim = strchr(strPath, '|');
	if(!pDelim)
		return NULL;
	CString strFile(strPath, pDelim - strPath), strIDObject(pDelim + 1);
	strFile.TrimLeft();
	strFile.TrimRight();
	strIDObject.TrimLeft();
	strIDObject.TrimRight();
	if(strIDObject.IsEmpty())
		return NULL;

	if(!strFile.IsEmpty())
	{
		char buf[MAX_PATH];
		if(SearchPath(NULL, strFile, NULL, MAX_PATH, buf, NULL))
			strFile = buf;
	}

	CString strFullPath = strFile + '|' + strIDObject;
	pStore = addin_mgr::GetByFullPath(strFullPath);
	if(pStore)
		return pStore->GetAddin();
	
	IDispatchPtr pObject;
	HINSTANCE hInst = NULL;
	if(strFile.IsEmpty())
	{
		if(S_OK != pObject.CreateInstance(strIDObject))
			return NULL;
	}
	else
	{
		if(!(hInst = CoLoadLibrary(_bstr_t(strFile), TRUE)))
			return NULL;
		typedef HRESULT(__stdcall *PREGISTER)(void);
		typedef HRESULT(__stdcall *PGETCO)(REFCLSID, REFIID, LPVOID*);
		PREGISTER pRegFunc = (PREGISTER)GetProcAddress(hInst, "DllRegisterServer");
		PGETCO pGetCO = (PGETCO)GetProcAddress(hInst, "DllGetClassObject");
		if(!pRegFunc || !pGetCO)
		{
			CoFreeLibrary(hInst);
			return NULL;
		}

		if(strIDObject[0] != '{')
		{
			CString strRegPath = strIDObject;
			strRegPath += "\\CLSID";
			HKEY hKey;
			BOOL bOpen = TRUE;
			if(ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, strRegPath, 0, KEY_QUERY_VALUE, &hKey))
			{
				//    .   
				pRegFunc();
				if(ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, strRegPath, 0, KEY_QUERY_VALUE, &hKey))
					bOpen = FALSE;
			}
			if(bOpen)
			{
				DWORD type, size = MAX_PATH;
				RegQueryValueEx(hKey, NULL, NULL, &type, (BYTE*)strIDObject.GetBuffer(MAX_PATH), &size);
				strIDObject.ReleaseBuffer();
				RegCloseKey(hKey);
			}
		}

		if(strIDObject[0]=='{')
		{
			CLSID clsid;
			if(Str2Clsid(strIDObject, clsid))	//   CLSID
			{
				IClassFactoryPtr pClassFactory;	//     ,     .
				if(S_OK == pGetCO(clsid, IID_IClassFactory, (void**)&pClassFactory) && pClassFactory != NULL)
					pClassFactory->CreateInstance(NULL, IID_IDispatch, (void**)&pObject);
			}
		}
		if(pObject == NULL)
		{
			CoFreeLibrary(hInst);
			return NULL;
		}
	}
	return CComAddin::Create(pObject, strFile, strIDObject);
}
