// common.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "common.h"
#include <afxdllx.h>

void InitPluginsMgr();


extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	if(dwReason == DLL_PROCESS_ATTACH)
	{
		DisableThreadLibraryCalls(hInstance);
		hMyInst = hInstance;
	}
	return 1;   // ok
}

void __stdcall LinkPath(cstr strStartDir, cstr path, CString& strResult)
{
	strResult = strStartDir;
	LPCSTR pStart = path, pRead = pStart;
	
	if(strResult[strResult.GetLength()-1] != '\\')
	{
		if(*pRead != '\\')
			strResult+='\\';
		else
			pRead++;
	}
	else
	{
		if(*pRead == '\\')
			pStart++, pRead++;
	}
	
	IShellLinkAPtr link;
	if(S_OK == link.CreateInstance(CLSID_ShellLink))
	{
		IPersistFilePtr file = link;
		if(file != NULL)
		{
			for(;;)
			{
				while(*pRead && '\\' != *pRead)
					pRead++;
				int len = pRead - pStart;
				if(len)
				{
					strResult += CString(pStart, len);
					strResult += ".lnk";
					BOOL bNotLink = TRUE;
					if(0 == (GetFileAttributes(strResult) & (0x80000000 | FILE_ATTRIBUTE_DIRECTORY)))
					{
						//  .
						if(S_OK==file->Load(_bstr_t(strResult.operator LPCSTR()), STGM_READ))
						{
							char buf[MAX_PATH];
							WIN32_FIND_DATA linkInfo;
							if(S_OK == link->GetPath(buf, MAX_PATH, &linkInfo, 0))
							{
								//  *pRead == '\\'     ,   
								if((linkInfo.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 
									DWORD(*pRead ? FILE_ATTRIBUTE_DIRECTORY : 0))
								{
									strResult = buf;
									bNotLink = FALSE;
								}
							}
						}
					}
					if(bNotLink)
					{
						//   .  .
						//   ,   ,   
						//  ,     
						strResult.GetBufferSetLength(strResult.GetLength()-4);
						if(*pRead)
						{
							if(FILE_ATTRIBUTE_DIRECTORY != (GetFileAttributes(strResult) &
								(0x80000000 | FILE_ATTRIBUTE_DIRECTORY)))
								break;
						}
					}
				}
				else
					break;
				if(!*pRead)
					return;
				strResult += *pRead++;
				pStart = pRead;
			}
		}
	}
	if(*pRead)
		strResult += pRead;
}

BOOL __stdcall CreateDirs(cstr path)
{
	if(FILE_ATTRIBUTE_DIRECTORY == (GetFileAttributes(path) & (FILE_ATTRIBUTE_DIRECTORY|0x80000000)))
		return TRUE;
	int delim = path.ReverseFind('\\');
	if(delim>-1)
	{
		if(!CreateDirs(path.Left(delim)))
			return FALSE;
		if(CreateDirectory(path, NULL))
			return TRUE;
		return 0x000000B7 == GetLastError();
	}
	return FALSE;
}

CVersionInfo::CVersionInfo(LPCSTR strFilePath, BOOL bFull) : m_pData(NULL)
{
	HINSTANCE hInst = GetModuleHandle(strFilePath);
	if(hInst)
		Init(hInst, bFull);
	else
	{
		hInst = LoadLibraryEx(strFilePath, NULL, LOAD_LIBRARY_AS_DATAFILE);
		if(hInst)
		{
			Init(hInst, bFull);
			FreeLibrary(hInst);
		}
	}
}

CVersionInfo::~CVersionInfo()
{
	delete [] m_pData;
	SBlockInfo** ppBlock = reinterpret_cast<SBlockInfo**>(m_blocks.GetData());
	for(int n=m_blocks.GetSize();n--;)
		delete *ppBlock++;
}

void CVersionInfo::Init(HINSTANCE hInst, BOOL bFull)
{
	HRSRC hRes = FindResource(hInst, (LPCSTR)1, RT_VERSION);
	if(!hRes)
		return;
	DWORD dwSize = SizeofResource(hInst, hRes);
	if(!dwSize)
		return;
	HGLOBAL hData = LoadResource(hInst, hRes);
	if(!hData)
		return;
	void* pData = LockResource(hData);
	if(!pData)
	{
		FreeResource(hData);
		return;
	}
	m_pData = new char[dwSize];
	memcpy(m_pData, pData, dwSize);
	UnlockResource(hData);
	FreeResource(hData);

	struct VS_BASE
	{
		WORD  wLength; 
		WORD  wValueLength; 
		WORD  wType;
		WCHAR* GetText() {return reinterpret_cast<WCHAR*>(this + 1);}
	};

	struct VS_VERSIONINFO : VS_BASE
	{
		WCHAR str[16];
		WORD padding;
		VS_FIXEDFILEINFO info;
	};

	struct StringFileInfo : VS_BASE
	{
		WCHAR str[sizeof("StringFileInfo")];
	};

	struct StringTable : VS_BASE
	{
		WCHAR str[sizeof("00000000")];
	};
	
	VS_VERSIONINFO* pVersion = reinterpret_cast<VS_VERSIONINFO*>(m_pData);
	m_wFileVersion[0] = (WORD)(pVersion->info.dwFileVersionMS >> 16);
	m_wFileVersion[1] = (WORD)pVersion->info.dwFileVersionMS;
	m_wFileVersion[2] = (WORD)(pVersion->info.dwFileVersionLS >> 16);
	m_wFileVersion[3] = (WORD)pVersion->info.dwFileVersionLS;
	
	m_wProdVersion[0] = (WORD)(pVersion->info.dwProductVersionMS >> 16);
	m_wProdVersion[1] = (WORD)pVersion->info.dwProductVersionMS;
	m_wProdVersion[2] = (WORD)(pVersion->info.dwProductVersionLS >> 16);
	m_wProdVersion[3] = (WORD)pVersion->info.dwProductVersionLS;

	if(!bFull)
		return;
	
	StringFileInfo* pSFI= reinterpret_cast<StringFileInfo*>(pVersion + 1);
	if(pSFI->str[0]==L'S')	// StringFileInfo
	{
		StringTable* pTable = reinterpret_cast<StringTable*>(pSFI + 1);
		StringTable* pTableEnd = reinterpret_cast<StringTable*>(reinterpret_cast<DWORD>(pSFI) + pSFI->wLength);
		while(pTable < pTableEnd)
		{
			SBlockInfo* pBlock = new SBlockInfo;
			m_blocks.Add(pBlock);
			pBlock->dwLangCP = 0;
			WCHAR* ptr = pTable->str;
			for(int i=0;i<8;i++, ptr++)
				pBlock->dwLangCP = (pBlock->dwLangCP<<4) |
				(*ptr<'A' ? *ptr - '0' : (*ptr<'a' ? *ptr-'A' : *ptr-'a')+10);
			VS_BASE* pString = reinterpret_cast<VS_BASE*>(pTable + 1);
			VS_BASE* pStringEnd = reinterpret_cast<VS_BASE*>(reinterpret_cast<DWORD>(pTable) + pTable->wLength);
			while(pString < pStringEnd)
			{
				WCHAR* pText = pString->GetText();
				CString key(pText);
				pBlock->names.Add(key);
				CString val;
				if(pString->wValueLength)
				{
					pText += key.GetLength() + 1;
					pText = reinterpret_cast<WCHAR*>((reinterpret_cast<DWORD>(pText) + 3) & ~3);
					val = CString(pText);
				}
				else
					val.Empty();
				pBlock->vals.Add(val);
				pBlock->Names2Vals[key] = val;
				pString = reinterpret_cast<VS_BASE*>((reinterpret_cast<DWORD>(pString) + pString->wLength + 3) & ~3);
			}
			pTable = reinterpret_cast<StringTable*>((reinterpret_cast<DWORD>(pTable) + pTable->wLength + 3) & ~3);
		}
	}
}

void CVersionInfo::SBlockInfo::GetStrLanguage(CString& str) const
{
	DWORD len = GetLocaleInfo(MAKELCID(dwLangCP>>16, SORT_DEFAULT), LOCALE_SLANGUAGE, NULL, 0);
	GetLocaleInfo(MAKELCID(dwLangCP>>16, SORT_DEFAULT), LOCALE_SLANGUAGE, str.GetBufferSetLength(len), len+1);
}

CString __stdcall GetErrDescription(DWORD err/*=0*/)
{
	if(!err)
		err=GetLastError();
	CString errMsg;
	errMsg.Format("  Windows: 0x%X",err);
	LPTSTR lpMsgBuf;
	if(FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,err,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&lpMsgBuf,0,NULL))
	{
		errMsg=errMsg+"\r\n"+lpMsgBuf;
		LocalFree(lpMsgBuf);
	}
	return errMsg;
}

template<typename T>
static inline BOOL AddHexDigit(T& dw, LPCSTR& ptr)
{
	DWORD s = static_cast<DWORD>(static_cast<BYTE>(*ptr++));
	if(s >='0' && s <='9')
		dw = static_cast<T>((dw << 4) | (s - '0'));
	else if(s >='A' && s <='F')
		dw = static_cast<T>((dw << 4) | (s - 'A' + 10));
	else if(s >='a' && s <='f')
		dw = static_cast<T>((dw << 4) | (s - 'a' + 10));
	else
		return FALSE;
	return TRUE;
}

BOOL __stdcall Str2Clsid(cstr str, CLSID& clsid)
{
	LPCSTR ptr = str;
	ptr++;
	for(int i = 0; i<8 ; i++)
	{
		if(!AddHexDigit(clsid.Data1, ptr))
			return FALSE;
	}
	if(*ptr++ != '-')
		return FALSE;
	
	for(i = 0; i<4 ; i++)
	{
		if(!AddHexDigit(clsid.Data2, ptr))
			return FALSE;
	}
	if(*ptr++ != '-')
		return FALSE;
	
	for(i = 0; i<4 ; i++)
	{
		if(!AddHexDigit(clsid.Data3, ptr))
			return FALSE;
	}
	if(*ptr++ != '-')
		return FALSE;
	for(i=0; i<4; i++)
	{
		if(!AddHexDigit(clsid.Data4[i/2], ptr))
			return FALSE;
	}
	if(*ptr++ != '-')
		return FALSE;
	for(; i<16; i++)
	{
		if(!AddHexDigit(clsid.Data4[i/2], ptr))
			return FALSE;
	}
	return *ptr == '}';
}

void __stdcall ExtractMacroses(IDispatchPtr& pDisp, CStringArray& names)
{
	ITypeInfoPtr ti;
	if(S_OK == pDisp->GetTypeInfo(0, 0, &ti) && ti!=NULL)
	{
		TYPEATTR* ta = NULL;
		if(S_OK == ti->GetTypeAttr(&ta) && ta)
		{
			for(int i = 0; i < ta->cFuncs ; i++)
			{
				FUNCDESC* pfd;
				if(S_OK == ti->GetFuncDesc(i, &pfd) && pfd)
				{
					if(!pfd->cParams && pfd->invkind == DISPATCH_METHOD)
					{
						BSTR bstr;
						UINT n;
						ti->GetNames(pfd->memid, &bstr, 1, &n);
						CString macros=bstr;
						if(macros != "AddRef" && macros != "Release")
							names.Add(macros);
						SysFreeString(bstr);
					}
					ti->ReleaseFuncDesc(pfd);
				}
			}
			ti->ReleaseTypeAttr(ta);
		}
	}
}

BOOL __stdcall InvokeMacros(IDispatchPtr& pDisp, cstr Macros)
{
	DISPID dispID;
	BSTR bMacros = Macros.AllocSysString();
	if(S_OK == pDisp->GetIDsOfNames(IID_NULL, &bMacros, 1, 0, &dispID))
	{
		DISPPARAMS none={0,0,0,0};
		return S_OK == pDisp->Invoke(dispID, IID_NULL, 0, DISPATCH_METHOD, &none, NULL, NULL, NULL);
	}
	return FALSE;
}
