#pragma once

#include <afx.h>
#include <windows.h>
#include <math.h>

#define NOINLINE

namespace hashstr{

//  

#define SYMB(n) static_cast<BYTE>(n)

LPCSTR __cdecl FindChar(LPCSTR Str,CHAR Char);
LPSTR __cdecl IntToBin(DWORD n);
DWORD __cdecl NextQuasiSimple(DWORD n);
DWORD __cdecl ReverseBits(DWORD n);

//  

extern char lowerTable[0x100];

void Init();
DWORD __cdecl GetHash(LPCSTR Source);
DWORD __cdecl GetHashAndLower(LPCSTR Source,LPSTR Dest,DWORD DestSize);

inline DWORD PtrHash(LPVOID Ptr)
{
	return ReverseBits((DWORD)Ptr);
}

inline DWORD lrand()
{
	return rand()^(rand()<<9)^(rand()<<17);
}

// **************************************************************************

class CWideString
{
private:
	wchar_t *Data;

	void Init(LPCSTR aData,int Length)
	{
		Data=new wchar_t[Length+1];
		if (Length) MultiByteToWideChar(CP_ACP,0,aData,Length,Data,Length);
		Data[Length]=0;
	}

public:
	CWideString(CString const &Source)
	{
		Init(Source,Source.GetLength());
	}
	CWideString(LPCSTR Source)
	{
		Init(Source,strlen(Source));
	}
	~CWideString()
	{
		delete Data;
	}
	operator wchar_t*()
	{
		return Data;
	}
};

class CStringEx: public CString
{
public:
	LPSTR AllocBuffer(int nLen)
	{
		CString::AllocBeforeWrite(nLen);
		return CString::m_pchData;
	}
};

template <class CObject>
	class CSmartRef
{
protected:
	CObject *Object;

public:
	CSmartRef(CObject &aObject):
		Object(&aObject) {}
	CSmartRef(CObject *aObject):
		Object(aObject) {}
	~CSmartRef()
	{
		delete Object;
	}
	operator CObject&()
	{
		return *Object;
	}
	operator CObject*()
	{
		return Object;
	}
};

// **************************************************************************

class CMemoryManager
{
protected:
	typedef struct CBlock
	{
		CBlock *Next; //   
		LPVOID GetData() {return this+1;}
	}
	*PBlock;

	PBlock CMemoryManager_Block;

public:
	CMemoryManager():
		CMemoryManager_Block(0) {}
	~CMemoryManager();

	LPVOID Alloc(UINT Size);
	
	// Chunk -  ,      
	// BlockSize 	   ChunkSize,  ,   

	static LPVOID __cdecl BuildChain(LPVOID Chunk,DWORD ChunkSize,LPVOID Block,DWORD BlockSize);
};

// **************************************************************************

class CMapIterator
{
private:
	LPVOID/* PAssoc */ CMapIterator_Next;
	LPVOID/* PAssoc* */ CMapIterator_Map;
	LPVOID/* PAssoc* */ CMapIterator_MapPos;
	LPVOID/* PAssoc* */ CMapIterator_MapEnd;

public:
	void Open(LPVOID Map,LPVOID MapEnd)
	{
		CMapIterator_MapPos=CMapIterator_Map=Map;
		CMapIterator_MapEnd=MapEnd;
		CMapIterator_Next=0;
	}
	void Reset()
	{
		CMapIterator_MapPos=CMapIterator_Map;
		CMapIterator_Next=0;
	}
	LPVOID GetMap()
	{
		return CMapIterator_Map;
	}
	LPVOID GetNext();
};

// **************************************************************************

#define _HASH_BLOCK_ALLOC

//#define _HASH_TEST_SIZE
//#define _HASH_TEST_COLLISIONS
//#define _HASH_MIN_COLLISIONS

#ifdef _HASH_TEST_SIZE
	#define MinHashCount 1 //   
#else
	#define MinHashCount 13 //   
#endif

// CKey
//    DWORD GetHash()
//    int Compare(CKey &Source) = 0  

template <class CKey,class CKeyArg,class CValue,class CValueArg>
	class CHashMap
{
public:
	typedef class CAssoc
	{
	protected:
		CAssoc *Next; //   

		friend class CMapIterator;
		friend template CHashMap;

	public:
		CKey Key;
		CValue Value;

		CAssoc(CKeyArg aKey,CValueArg aValue):
			Key(aKey),Value(aValue) {}
	}
	*PAssoc;

protected:
#if defined _HASH_TEST_SIZE	|| defined _HASH_TEST_COLLISIONS
	public:
#endif
	UINT Count,HashCount;
	PAssoc *Map;

	#ifdef _HASH_BLOCK_ALLOC
		PAssoc AvailAssoc;
		CMemoryManager Manager;

		NOINLINE PAssoc NewAssoc(CKeyArg Key,CValueArg Value);
		void FreeAssocEx(PAssoc Assoc)
		{
			Assoc->CAssoc::~CAssoc();
		}
		void FreeAssoc(PAssoc Assoc)
		{
			FreeAssocEx(Assoc);
			Assoc->Next=AvailAssoc,AvailAssoc=Assoc;
		}
	#else
		PAssoc NewAssoc(CKeyArg Key,CValueArg Value)
		{
			return new CAssoc(Key,Value);
		}
		void FreeAssocEx(PAssoc Assoc)
		{
			//Assoc->CAssoc::~CAssoc();
			delete Assoc;
		}
		void FreeAssoc(PAssoc Assoc)
		{
			FreeAssocEx(Assoc);
		}
	#endif

	PAssoc AddAssoc(PAssoc Assoc)
	{
		PAssoc &Curr=Map[Assoc->Key.GetHash()%HashCount];
		Assoc->Next=Curr,Curr=Assoc;
		return Assoc;
	}

	// ***

	NOINLINE void SetHashCount(int NewHashCount);
	void OnGrow()
	{
		//if (Count*3>>1>HashCount) SetHashCount(NextQuasiSimple(Count<<1));
		if (Count>HashCount>>1) SetHashCount(NextQuasiSimple(Count*3));
	}
	void OnShrink()
	{
		//if (Count<=HashCount>>2 && HashCount>MinHashCount) SetHashCount(NextQuasiSimple(Count*3>>1));
		if (Count*3<=HashCount>>1 && HashCount>MinHashCount) SetHashCount(NextQuasiSimple(Count<<1));
	}

public:
	CHashMap():
		Count(0),HashCount(0),Map(0)
	{
		#ifdef _HASH_BLOCK_ALLOC
			AvailAssoc=0;
		#endif
		#ifdef _HASH_TEST_COLLISIONS
			TotalCollisions=0;
			TotalMaxDepth=0;
		#endif
	}
	~CHashMap();

	#ifdef _HASH_TEST_COLLISIONS
		UINT TotalCollisions,TotalMaxDepth;
		void GetCollisions(UINT &Count,UINT &Collisions,UINT &MaxDepth);
	#endif

	UINT GetCount()
	{
		return Count;
	}
	void IterOpen(CMapIterator &Iter)
	{
		Iter.Open(Map,Map+HashCount);
	}
	PAssoc IterNext(CMapIterator &Iter)
	{
		return (PAssoc)Iter.GetNext();
	}

	#define SetAssoc(Assoc) AssocPtr=&(Assoc)
	#define Assoc (*AssocPtr)

	NOINLINE PAssoc *FindPtr(CKeyArg Key)
	{
		#ifndef _HASH_TEST_SIZE
			if (HashCount)
				for (PAssoc *SetAssoc(Map[Key.GetHash()%HashCount]);Assoc;SetAssoc(Assoc->Next))
					if (Key.Compare(Assoc->Key)==0)
						return AssocPtr;
		#endif
		return 0;
	}
	NOINLINE PAssoc *FindPtr(PAssoc Target)
	{
		#ifndef _HASH_TEST_SIZE
			if (HashCount)
				for (PAssoc *SetAssoc(Map[Target->Key.GetHash()%HashCount]);Assoc;SetAssoc(Assoc->Next))
					if (Assoc==Target)
						return AssocPtr;
		#endif
		return 0;
	}
	void RemovePtr(PAssoc *AssocPtr)
	{
		#ifndef _HASH_TEST_SIZE
			PAssoc Temp=Assoc;
			Assoc=Assoc->Next;
			FreeAssoc(Temp);
			Count--,OnShrink();
		#endif
	}

	#undef Assoc
	#undef SetAssoc

	NOINLINE PAssoc Add(CKeyArg Key,CValueArg Value)
	{
		#ifndef _HASH_TEST_SIZE
			Count++,OnGrow();
			return AddAssoc(NewAssoc(Key,Value));
		#endif
	}
	PAssoc FindAssoc(CKeyArg Key)
	{
		PAssoc *AssocPtr;
		return (AssocPtr=FindPtr(Key)) ? *AssocPtr : 0;
	}
	int Remove(CKeyArg Key)
	{
		PAssoc *AssocPtr;
		return (AssocPtr=FindPtr(Key)) ? RemovePtr(AssocPtr),1 : 0;
	}
	int Remove(PAssoc Assoc)
	{
		PAssoc *AssocPtr;
		return (AssocPtr=FindPtr(Assoc)) ? RemovePtr(AssocPtr),1 : 0;
	}
	NOINLINE void RemoveAll();
};

#ifdef _HASH_TEST_COLLISIONS
	#ifdef _HASH_MIN_COLLISIONS
		extern int Shift_1;
		extern int Shift_2;
		extern int Shift_3;
	#endif

	template <class CKey,class CKeyArg,class CValue,class CValueArg>
		void CHashMap<CKey,CKeyArg,CValue,CValueArg>::GetCollisions(UINT &Count,UINT &Collisions,UINT &MaxDepth)
	{
		Count=Collisions=MaxDepth=0;
		for (UINT n=0;n<HashCount;n++)
		{
			UINT Depth=0;
			for (PAssoc Next=Map[n];Next;Count++,Depth++)
				if (Next=Next->Next) Collisions++; 
			if (Depth>MaxDepth) MaxDepth=Depth;
		}
	}
#endif

template <class CKey,class CKeyArg,class CValue,class CValueArg>
	void CHashMap<CKey,CKeyArg,CValue,CValueArg>::SetHashCount(int NewHashCount)
{
	#ifdef _HASH_TEST_SIZE
		Debug("%i=%s (%lg%%) >>> ",HashCount,IntToBin(HashCount),HashCount ? ((double)HashCount-Count+1)/HashCount*100 : (double)0);
		Debug("%i (%lg%%) >>> ",Count,HashCount ? ((double)NewHashCount-HashCount)/HashCount*100 : (double)0);
		Debug("%i=%s (%lg%%)\n",NewHashCount,IntToBin(NewHashCount),NewHashCount ? ((double)NewHashCount-Count)/NewHashCount*100 : (double)0);
		HashCount=NewHashCount;
	#else
		#ifdef _HASH_TEST_COLLISIONS
			if (Count>1)
			{
				UINT OldCount=Count-1,RealCount,Collisions,MaxDepth;
				GetCollisions(RealCount,Collisions,MaxDepth);
				TotalCollisions+=Collisions;
				if (MaxDepth>TotalMaxDepth) TotalMaxDepth=MaxDepth;
				#ifndef _HASH_MIN_COLLISIONS
					Debug("Count %i RealCount %i HashCount %i Collisions %i (%lg%%) MaxDepth %i (%lg)\n",OldCount,RealCount,HashCount,Collisions,(double)Collisions/OldCount*100,MaxDepth,log(OldCount)/log(2));
				#endif
			}
		#endif

		CMapIterator Iter;
		IterOpen(Iter);

		UINT HashSize;
		Map=(PAssoc*)malloc(HashSize=(HashCount=NewHashCount)*sizeof(PAssoc));
		memset(Map,0,HashSize);

		PAssoc Assoc;
		while (Assoc=IterNext(Iter))
			AddAssoc(Assoc);
		free(Iter.GetMap());
	#endif
}

template <class CKey,class CKeyArg,class CValue,class CValueArg>
	CHashMap<CKey,CKeyArg,CValue,CValueArg>::~CHashMap()
{
	#ifndef _HASH_TEST_SIZE
		CMapIterator Iter;
		IterOpen(Iter);
		PAssoc Assoc;
		while (Assoc=IterNext(Iter))
			FreeAssocEx(Assoc);
	#endif
	free(Map);
}

template <class CKey,class CKeyArg,class CValue,class CValueArg>
	void CHashMap<CKey,CKeyArg,CValue,CValueArg>::RemoveAll()
{
	#ifndef _HASH_TEST_SIZE
		CMapIterator Iter;
		IterOpen(Iter);
		PAssoc Assoc;
		while (Assoc=IterNext(Iter))
			FreeAssoc(Assoc);
	#endif
	free(Map),Map=0;
	Count=HashCount=0;
}

#ifdef _HASH_BLOCK_ALLOC
	template <class CKey,class CKeyArg,class CValue,class CValueArg>
		CHashMap<CKey,CKeyArg,CValue,CValueArg>::PAssoc CHashMap<CKey,CKeyArg,CValue,CValueArg>::NewAssoc(CKeyArg Key,CValueArg Value)
		{
			if (!AvailAssoc)
			{
				#define Page ((0x4000-0x10)/sizeof(CAssoc))

				UINT Size=Count>Page/4 ? Page*sizeof(CAssoc) : (Count>16 ? Page/16*sizeof(CAssoc) : 4*sizeof(CAssoc));
				AvailAssoc=(PAssoc)CMemoryManager::BuildChain(AvailAssoc,sizeof(CAssoc),Manager.Alloc(Size),Size);

				#undef Page
			}

			PAssoc Assoc=AvailAssoc;
			AvailAssoc=Assoc->Next;

			return &Assoc->CAssoc::CAssoc(Key,Value);
		}
#endif

#undef MinHashCount

// **************************************************************************

#define AllocMask 15 //   2^N-1

template <class CKey,class CKeyArg,class CValue,class CValueArg>
	class CCollection
{
public:
	typedef class CItem
	{
	private:
		void operator =(CValueArg aValue) {}

	protected:
		UINT Index;

		friend template CCollection;

	public:
		CValue Value;

		CItem(CValueArg aValue):
			Value(aValue) {}
		UINT GetIndex()
		{
			return Index;
		}
	}
	*PItem;

	typedef CHashMap<CKey,CKeyArg,CItem,CValueArg> CItemHashMap;
	typedef CItemHashMap::PAssoc PAssoc;

protected:
#if defined _HASH_TEST_SIZE	|| defined _HASH_TEST_COLLISIONS
	public:
#endif
	CItemHashMap Map;
	UINT Count,AllocCount;
	PAssoc *Items;

	void OnGrow()
	{
		if (Count>AllocCount)
		{
			AllocCount=(AllocCount+(AllocCount>>3)+AllocMask)&~AllocMask;
			UINT MinAllocCount=(Count+AllocMask)&~AllocMask;
			if (AllocCount<MinAllocCount) AllocCount=MinAllocCount;
			Items=(PAssoc*)realloc(Items,AllocCount*sizeof(Items[0]));
		}
	}
	void OnShrink()
	{
		if (Count<AllocCount>>1 && AllocCount>AllocMask)
		{
			AllocCount=(Count+AllocMask)&~AllocMask;
			if (AllocCount<AllocMask+1) AllocCount=AllocMask+1;
			Items=(PAssoc*)realloc(Items,AllocCount*sizeof(Items[0]));
		}
	}
	void Reindex(UINT Index)
	{
		for (;Index<Count;Index++) Items[Index]->Value.Index=Index;
	}

	PAssoc AddAssoc(PAssoc Assoc)
	{
		Assoc->Value.Index=Count++,OnGrow();
		return Items[Count-1]=Assoc;
	}
	void DeleteAt(UINT Index)
	{
		if (Index<--Count) memmove(Items+Index,Items+Index+1,(Count-Index)*sizeof(Items[0])),Reindex(Index);
		OnShrink();
	}

public:
	NOINLINE CCollection():
		Count(0),AllocCount(0),Items(0) {}
	NOINLINE ~CCollection()
	{
		free(Items);
	}

	UINT GetCount()
	{
		return Count;
	}

	NOINLINE PAssoc Add(CKeyArg Key,CValueArg Value)
	{
		return AddAssoc(Map.Add(Key,Value));
	}
	PAssoc FindAssoc(CKeyArg Key)
	{
		return Map.FindAssoc(Key);
	}
	PAssoc GetAssoc(UINT Index)
	{
		return Items[Index];
	}
	NOINLINE void Remove(CKeyArg Key)
	{
		#define Assoc (*AssocPtr)

		PAssoc *AssocPtr;
		if (AssocPtr=Map.FindPtr(Key))
		{
			DeleteAt(Assoc->Value.Index);
			Map.RemovePtr(AssocPtr);
		}

		#undef Assoc
	}
	NOINLINE void Delete(UINT Index)
	{
		Map.Remove(Items[Index]);
		DeleteAt(Index);
	}
	NOINLINE void RemoveAll()
	{
		Map.RemoveAll();
		free(Items),Items=0;
		Count=AllocCount=0;
	}
};

#undef AllocMask

// **************************************************************************

class CStringKey
{
protected:
	CString Data,Cmp;
	DWORD Hash;

public:
	//    -   
	CStringKey():
		Hash(PtrHash(static_cast<CStringEx&>(Cmp).AllocBuffer(1))) {}
	CStringKey(DWORD aHash):
		Hash(aHash) {}

	CStringKey(CString const &aData):
		Data(aData),Cmp(aData),Hash(hashstr::GetHash(aData)) {}
	CStringKey(CStringKey const &Source):
		Data(Source.Data),Cmp(Source.Cmp),Hash(Source.Hash) {}
	CStringKey(CString const &aData,int CaseSens):
		Data(aData)
	{
		if (CaseSens)
			Hash=hashstr::GetHash(Cmp=Data);
		else
			Hash=hashstr::GetHashAndLower(Data,static_cast<CStringEx&>(Cmp).AllocBuffer(Data.GetLength()),0);
	}
	int Compare(CStringKey const &Source)
	{
		return Hash==Source.Hash ? memcmp(Cmp,Source.Cmp,Cmp.GetLength()+1) : 1/*  */;
	}
	DWORD GetHash()
	{
		return Hash;
	}
	CString const &GetData()
	{
		return Data;
	}
};

} // namespace hashstr
