#!/usr/bin/env python
# -*- coding: utf-8 -*-

#

"""
m_py
"""

import sys, imp,  os

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import uic

# globally accessible object for user modules
m_app = None
m_main_window = None
m_message_window = None
m_status_bar = None

class m_messages_window_class ( QObject ) :
    qTextEdit_Widget = None # widget on which the text of messages is shown
    qDock_Widget = None # QDockWidget o which qLabel_Widget resides
    def __init__ ( self,  m_main_window ) :
        QObject.__init__ ( self )

        self.qDock_Widget = QDockWidget ( "Messages", m_main_window )
        #m_Messages_Window.qDock_Widget.setAllowedAreas ( Qt.BottomDockWidgetArea | Qt.BottomDockWidgetArea )

        self.qTextEdit_Widget = QTextEdit ( self.qDock_Widget )
        self.qTextEdit_Widget.setAcceptRichText ( False )
        self.qTextEdit_Widget.setLineWrapMode ( QTextEdit.NoWrap )
        self.qTextEdit_Widget.setReadOnly ( True )
        #self.qLabel_Widget.setVerticalScrollBarPolicy ( Qt.ScrollBarAsNeeded )
        #self.qLabel_Widget.setHorizontalScrollBarPolicy ( Qt.ScrollBarAsNeeded )

        # create the context menu
        self.__menu = QMenu ( self.qTextEdit_Widget )
        self.__menu.addAction ( 'Clear', self.clear )
        self.__menu.addAction ( 'Copy', self.qTextEdit_Widget.copy )
        self.__menu.addAction ( 'Select All', self.qTextEdit_Widget.selectAll )
        
        self.qTextEdit_Widget.setContextMenuPolicy ( Qt.CustomContextMenu )
        self.qTextEdit_Widget.customContextMenuRequested.connect ( self.__handleShowContextMenu )

        self.qDock_Widget.setWidget ( self.qTextEdit_Widget )
        m_main_window.addDockWidget ( Qt.BottomDockWidgetArea, self.qDock_Widget )
        self.addMessage ( "<span style='color: green'>System started.</span><br/><b>Welcome!</b>" )

    def __handleShowContextMenu ( self, coord ) :
        coord = self.qTextEdit_Widget.mapToGlobal (coord )
        self.__menu.popup ( coord )


    def clear ( self, clearByScrolling = False ) :
        self.qTextEdit_Widget.clear ()
    def addMessage ( self,  txt ) :
        print ("addMessage called: " + str(txt))
        tc = self.qTextEdit_Widget.textCursor ()
        tc.movePosition ( QTextCursor.End )
        self.qTextEdit_Widget.setTextCursor ( tc )
        self.qTextEdit_Widget.insertHtml ( "<br>" + txt )
        self.qTextEdit_Widget.ensureCursorVisible ()

class m_main_window_class ( QMainWindow ) : # http://radpy.googlecode.com/svn/trunk/RadPy/src/RadPy.py
    def __init__ ( self, parent = None ) :
        QMainWindow.__init__ ( self, parent )

        self.mdi = QMdiArea ()
        self.mdi.setVerticalScrollBarPolicy ( Qt.ScrollBarAsNeeded )
        self.mdi.setHorizontalScrollBarPolicy ( Qt.ScrollBarAsNeeded )

        self.setCentralWidget ( self.mdi )

        global m_message_window
        m_message_window = m_messages_window_class ( self )


        #Create menu bar, file and window menus
        fileNewAction = self.createAction ( "&New...", self.fileNew, QKeySequence.New, "filenew", "Create a new scan" )
        fileOpenAction = self.createAction ( "&Open...", self.fileOpen, QKeySequence.Open, "fileopen", "Open an existing scan" )
        fileQuitAction = self.createAction ( "&Quit", self.close, "Ctrl+Q", "filequit", "Close the Application" )

        self.windowNextAction = self.createAction("&Next", self.mdi.activateNextSubWindow, QKeySequence.NextChild)
        self.windowPrevAction = self.createAction("&Previous", self.mdi.activatePreviousSubWindow,QKeySequence.PreviousChild)
        self.windowCascadeAction = self.createAction("Casca&de", self.mdi.cascadeSubWindows)
        self.windowTileAction = self.createAction("&Tile", self.mdi.tileSubWindows)
        self.windowRestoreAction = self.createAction("&Restore All", self.windowRestoreAll)
        self.windowMinimizeAction = self.createAction("&Iconize All", self.windowMinimizeAll)
        self.windowCloseAction = self.createAction("&Close", self.mdi.closeActiveSubWindow, QKeySequence.Close)

        self.fileMenu = self.menuBar().addMenu("&File")
        self.addActions(self.fileMenu, (fileNewAction,fileOpenAction))

        self.windowMenu = self.menuBar().addMenu("&Window")

        #Before window menu is shown, update the menu with the titles of each open window.
        self.windowMenu.aboutToShow.connect ( self.updateWindowMenu )
        self.updateWindowMenu()

        #For future use.  This section will write the main window
        #size and position (possibly other settings) to a file,
        #so that reopening the program will restore those settings.
        settings = QSettings()
        size = settings.value("MainWindow/Size", QVariant(QSize(1024, 768))).toSize()
        self.resize(size)
        position = settings.value("MainWindow/Position", QVariant(QPoint(0, 0))).toPoint()
        self.move(position)

        self.setWindowTitle ( "m_py" )

        global m_status_bar
        m_status_bar = self.statusBar ()
        m_status_bar.showMessage ( "Ready...", 5000 )

    def closeEvent ( self, event ) :
        #Passes a close event from main window to all subwindows.
        self.mdi.closeAllSubWindows()

    def fileOpen ( self ) :
        #Open a file and add it to the tree model.
        #Support for formats besides .rfb needs to be added here.

        fname = unicode ( QFileDialog.getOpenFileName ( self,
                            "Choose module", ".",
                            "Modules *.py (*.py);;All files *.* (*.*)" ) )
        if fname :
            loadModule ( self.mdi, fname )

    def fileNew(self):
        #Creates a new window to display scans.
        window = QMdiSubWindow()
        window.setAttribute(Qt.WA_DeleteOnClose)
        window.setWidget(QPlainTextEdit(self))
        self.mdi.addSubWindow(window)
        window.show()
        window.setMinimumSize(QSize(400,300))

    def createAction (self, text, slot = None, shortcut = None, icon = None,
                     tip = None, checkable = False, signal = "triggered()" ) :
        #Convenience function to create PyQt actions.
        action = QAction ( text, self )
        if icon is not None : action.setIcon ( QIcon ( ":/%s.png" % icon ) )
        if shortcut is not None : action.setShortcut ( shortcut )
        if tip is not None : 
            action.setToolTip ( tip )
            action.setStatusTip ( tip )
        if slot is not None : self.connect ( action, SIGNAL ( signal ), slot )
        if checkable : action.setCheckable ( True )
        return action

    def addActions(self, target, actions):
        #Add multiple actions to a menu
        for action in actions:
            if action is None:
                target.addSeparator()
            else:
                target.addAction(action)

    def windowRestoreAll(self):
        for window in self.mdi.subWindowList():
            window.widget().showNormal()

    def windowMinimizeAll(self):
        for window in self.mdi.subWindowList():
            window.widget().showMinimized()

    def updateWindowMenu(self):
        #Creates a window menu with actions to jump to any open subwindow.
        self.windowMenu.clear()
        self.addActions(self.windowMenu, (self.windowNextAction,
            self.windowPrevAction, self.windowCascadeAction,
            self.windowTileAction, self.windowRestoreAction,
            self.windowMinimizeAction, #self.windowArrangeIconsAction,
            None, self.windowCloseAction))
        windows = self.mdi.subWindowList()
        if not windows : return
        self.windowMenu.addSeparator()
        i = 1
        menu = self.windowMenu
        for window in windows:
            title = window.windowTitle()
            if i == 10:
                self.windowMenu.addSeparator()
                menu = menu.addMenu("&More")
            accel = ""
            if i < 10:
                accel = "&%d " % i
            elif i < 36:
                accel = "&%c " % chr(i + ord("@") - 9)
            action = menu.addAction("%s%s" % (accel, title))
            self.connect(action, SIGNAL("triggered()"),
                         lambda w = window : self.mdi.setActiveSubWindow(w)) # example of how to call procedures-slots with parameters
            i += 1

    def picked(self):
        return None #self.treeWidget.currentFields()

    def activated(self, record):
        #Retrieves scan data from active item and plots it.
        #Adds plot to active sub window.
        label, beam = record

        x = self.mdi.activeSubWindow()
        self.mdi.activeSubWindow().widget().add_plot(label, beam)


def loadModule ( mdiArea, fileName ) :
#    try :

        ui_filename = os.path.dirname ( fileName ) + "/form.ui"
        
        form_class, base_class = uic.loadUiType ( ui_filename )
        class m_ ( base_class, form_class ) : # base_class must be QDialog (for having signals 'accepted' and 'rejected')
            def __init__ ( self, parent ) :
                base_class.__init__ ( self, parent )
                self.setupUi ( self )
                if self.minimumSizeHint().isEmpty () :
                    self.setMinimumSize ( self.width (), self.height () )
                self.setLayout ( self.layout ) # form should have QLayout widget with name 'layout'
                #change size policy if layout is given?
                self.finished.connect ( self._finished )
            def _finished ( self ) :
                self.close ()
            def closeEvent ( self,  event ) :
                try :
                    res = self.module.on_form_close ()
                    print (str(res))
                    if res == False :
                        event.ignore()
                        self.show()
                        return
                except AttributeError :
                    print ("Procedure on_form_close() not found")
                self.parentWidget().close() # close sub window

        module = imp.load_source ( fileName, fileName )
        module.m_app = m_app

        try :
            if module.on_module_load () == False : # был СтатусВозврата (0)
                return 
        except AttributeError :
            print ("Procedure on_module_load() not found")

        widget = m_ ( mdiArea )
        try :
            module.form = widget
            widget.module = module
            module.on_form_load ()
        except AttributeError :
            print ("Procedure on_form_load() not found")

        window = QMdiSubWindow ()
        window.setAttribute ( Qt.WA_DeleteOnClose )
        window.setWidget ( widget )
        mdiArea.addSubWindow ( window )
        window.show ()
#        try :
#            getattr ( module,  "form" )
#        except AttributeError :            


#    except Exception, err:
#        print ('ERROR: %s\n' % str(err))
#        #print ("import error")
#        return


class m_app_class ( QApplication ) : # taken from Eric4
    def __init__(self, argv):
        QApplication.__init__(self, argv)
        self.__objectRegistry = {}
        
#    def registerObject(self, name, object):
#        if self.__objectRegistry.has_key(name):
#            raise KeyError('Object "%s" already registered.' % name)
#        else:
#            self.__objectRegistry[name] = object
#    def getObject(self, name):
#        if self.__objectRegistry.has_key(name):
#            return self.__objectRegistry[name]
#        else:
#            raise KeyError('Object "%s" is not registered.' % name)
#    def unregisterObject(self, name):
#        if self.__objectRegistry.has_key(name):
#            del self.__objectRegistry[name]
 

def main () :
    
    #sys.excepthook = excepthook
    global m_app
    m_app = m_app_class ( sys.argv )
    
    m_app.m_main_window = m_main_window_class ()
    m_app.m_message_window = m_message_window
    m_app.m_status_bar = m_status_bar
    #app.connect(m_app, SIGNAL("lastWindowClosed()"), app, SLOT("quit()"))
    m_app.m_main_window.show()
    
    #QTimer.singleShot(0, uiStartUp)
    
    sys.exit ( m_app.exec_ () ) # start the event loop


if __name__ == '__main__' : main()
