# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
import re, math
from ui_m_DecimalEdit import Ui_m_DecimalEdit
from ui_m_PopupCalculator import Ui_m_PopupCalculator

class m_PopupCalculator ( QDialog, Ui_m_PopupCalculator ) :
    """
    Popup calculator
    """
    def __init__ ( self, parent ) :
        QDialog.__init__ ( self, parent, Qt.CustomizeWindowHint ) # стандартный попап меня пока не устраивает
        self.setupUi ( self )
        #self.setLayout ( self.gridLayout )
        self.positionPopup ( parent )
        self.show()
        
        self.digits = ( '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' )
        self.operators = ( '+', '-', '*', '/' )

        value = parent.value
        self.display.setText ( str ( value ) if value != 0 else "" )

        def buttonConnect ( button, code ) :
            button.clicked.connect ( lambda : self.buttonClicked ( code ) )

        buttonConnect ( self.digitButton_0, '0' )
        buttonConnect ( self.digitButton_1, '1' )
        buttonConnect ( self.digitButton_2, '2' )
        buttonConnect ( self.digitButton_3, '3' )
        buttonConnect ( self.digitButton_4, '4' )
        buttonConnect ( self.digitButton_5, '5' )
        buttonConnect ( self.digitButton_6, '6' )
        buttonConnect ( self.digitButton_7, '7' )
        buttonConnect ( self.digitButton_8, '8' )
        buttonConnect ( self.digitButton_9, '9' )
        buttonConnect ( self.pointButton, '.' )
        buttonConnect ( self.changeSignButton, '+/-' )
        buttonConnect ( self.backspaceButton, 'b' )
        buttonConnect ( self.clearButton, 'c' )
        buttonConnect ( self.divisionButton, '/' )
        buttonConnect ( self.timesButton, '*' )
        buttonConnect ( self.minusButton, '-' )
        buttonConnect ( self.plusButton, '+' )
        buttonConnect ( self.equalButton, '=' )
        buttonConnect ( self.squareRootButton, 'sqrt' )
        buttonConnect ( self.powerButton, 'x**2' )
        buttonConnect ( self.reciprocalButton, '1/x' )
        buttonConnect ( self.percentButton, '%' )
        self.okButton.clicked.connect ( self.okButtonClicked )
 
    def buttonClicked ( self, code ) :
        txt = str ( self.display.text () )
        if code == 'b' : # backspace
            self.display.setText ( txt [ : -1 ] )
        elif code == 'c' : # clear
            self.calculateResult ( "" )
        elif code == '+/-' :
            self.calculateResult ( "-(" + txt + ")" )
        elif code == 'sqrt' :
            self.calculateResult ( "math.sqrt(" + txt + ")" )
        elif code == 'x**2' :
            self.calculateResult ( "(" + txt + ")**2" )
        elif code == '.' :            
            i = len ( txt )
            while i > 0 : 
                i -= 1
                if txt [ i ] in self.operators :
                    last_word = txt [ i + 1 : ]
                    break
            else :
                last_word = txt
            if code not in last_word :
                self.display.setText ( txt + code )                    
        elif code == '1/x' :
            self.calculateResult ( "1.0/(" + txt + ")" )
        elif code == '=' :
            self.calculateResult ( txt )
        elif code in self.operators :
            last_symbol = txt [ -1 : ]
            if last_symbol in self.operators :
                self.display.setText ( txt [ : -1 ] + code ) # overwrite last operator
            elif last_symbol : # not empty
                self.display.setText ( txt + code )
        elif code in self.digits :
            self.display.setText ( txt + code )

    def calculateResult ( self, expr ) :
        if not expr :
            result = ""
        else :
            try:
                result = str ( eval ( "1.0*(" + expr + ")" ) )
            except Exception, err:
                print ( 'Calculate error: {0}\n'.format ( err ) )
                self.display.setStyleSheet ( "background-color: red" )
                return
        self.display.setText ( result )
        self.display.setStyleSheet ( "background-color: white" )

    def okButtonClicked ( self ) :
        self.calculateResult ( str ( self.display.text () ) )
        self.parent().value = self.display.text()
        self.close ()
        
    def keyPressEvent ( self, event ) :
        key = event.key ()
        if key == Qt.Key_Insert :
            self.okButton.animateClick ()
        elif key == Qt.Key_Enter or key == Qt.Key_Return or key == Qt.Key_Equal :
            self.equalButton.animateClick ()
        elif key == Qt.Key_0 :
            self.digitButton_0.animateClick ()
        elif key == Qt.Key_1 :
            self.digitButton_1.animateClick ()
        elif key == Qt.Key_2 :
            self.digitButton_2.animateClick ()
        elif key == Qt.Key_3 :
            self.digitButton_3.animateClick ()
        elif key == Qt.Key_4 :
            self.digitButton_4.animateClick ()
        elif key == Qt.Key_5 :
            self.digitButton_5.animateClick ()
        elif key == Qt.Key_6 :
            self.digitButton_6.animateClick ()
        elif key == Qt.Key_7 :
            self.digitButton_7.animateClick ()
        elif key == Qt.Key_8 :
            self.digitButton_8.animateClick ()
        elif key == Qt.Key_9 :
            self.digitButton_9.animateClick ()
        elif key == Qt.Key_Plus :
            self.plusButton.animateClick ()
        elif key == Qt.Key_Minus :
            self.minusButton.animateClick ()
        elif key == Qt.Key_Asterisk :
            self.timesButton.animateClick ()
        elif key == Qt.Key_Slash :
            self.divisionButton.animateClick ()
        elif key == Qt.Key_Period :
            self.pointButton.animateClick ()
        elif key == Qt.Key_Backspace :
            self.backspaceButton.animateClick ()
        elif key == Qt.Key_Delete :
            self.clearButton.animateClick ()
        elif key == Qt.Key_Escape or key == Qt.Key_End :
            self.close ()
        return QDialog.keyPressEvent ( self, event ) 

    def event ( self, event ) :
        if event.type() == QEvent.WindowDeactivate : # стандартный попап меня пока не устраивает
            self.close() 
            #return True # should return true if the event was recognized and processed
        return QDialog.event ( self, event )
        
    def positionPopup ( self, parent ) : # taken from qdatetimeedit.cpp
        pos = parent.rect().bottomLeft()
        pos2 = parent.rect().topLeft()
        pos = parent.mapToGlobal ( pos )
        pos2 = parent.mapToGlobal ( pos2 )
        screen = QApplication.desktop().availableGeometry ( pos )
        if pos.x () + self.width () > screen.right () :
            pos.setX ( max ( screen.right () - self.width (), screen.left () ) )
        if pos.y () + self.height () > screen.bottom () :
            pos.setY ( pos2.y () - self.height () )
        if pos.y () < screen.top () :
            pos.setY ( screen.top () )
        if pos.y () + self.height () > screen.bottom () :
            pos.setY ( screen.bottom () - self.height () )
        self.move ( pos )
        

class deEventFilter ( QObject ) : # event filter for m_DecimalEdit's lineEdit
    
    def __init__ ( self, parent = None ) :
        QObject.__init__ ( self,  parent )
    
    def eventFilter ( self, target, event ) : # target - lineEdit
        if event.type() == QEvent.Wheel :
#            _date = target.parent().value
#            def wheelEvent ( self, event ) :
#                cursorAt = target.cursorPositionAt ( event.pos () )
#                numSteps = event.delta() / 120
#                print("{0} {1}".format(cursorAt, numSteps))
#                # if wheel after dot - add/subtract 0.01, if before - 1
            return True
        elif event.type() == QEvent.KeyPress :
            key = event.key ()
            if event.modifiers () == Qt.NoModifier :
                if key == Qt.Key_Insert :
                    target.parent().popupCalculator ()
                    return True
                if ( ( key == Qt.Key_Backspace ) or ( key == Qt.Key_Delete ) ) and ( not target.hasSelectedText () ) :
                    txt = target.text ()
                    cur_pos = target.cursorPosition ()
                    if key == Qt.Key_Backspace :
                        posvaluenext = cur_pos - 1 # position to check for character
                        pos_move = cur_pos - 1 # position to move to
                    elif key == Qt.Key_Delete :
                        posvaluenext = cur_pos
                        pos_move = cur_pos + 1
                    if ( posvaluenext >= 0 ) and ( posvaluenext < len ( txt ) ) :
                        charvaluenext = txt [ posvaluenext ] 
                        if ( charvaluenext == target.parent().decimalMarker ) or ( charvaluenext == target.parent().thousandsSeparator ) : # the cursor is on next to a dot or thousands separator
                            target.setCursorPosition ( pos_move ) # "skip" dot on delete
#        elif event.type() == QEvent.FocusOut :
#            target.parent().value = target.text()
        elif event.type() == QEvent.MouseButtonDblClick :
            if event.button () == Qt.LeftButton :
                target.selectAll () # select all on double click, otherwise only group of digits will be selected
                return True

        return QObject.eventFilter ( self, target, event ) # standard event processing

    def addDays ( self, target, section, number ) : # target - lineEdit
        _date = target.parent().value
        _cur = target.cursorPosition ()
        if section == 1 : # day was 'wheeled'
            _date = _date.addDays ( number )
        elif section == 2 : # month was 'wheeled'
            _date = _date.addMonths ( number )
        elif section == 3 : # year was 'wheeled'
            _date = _date.addYears ( number )
        target.parent().value = _date
        target.setCursorPosition ( _cur )


class m_DecimalEdit ( QWidget, Ui_m_DecimalEdit ) :
    """Custom widget - for editing decimals. 
    You can specify total number of digits, number of digits 
    after decimal point, symbol representing decimal point,
    symbol representing separator of thousands."""
    
    _deEventFilter = deEventFilter () # static member
    valueChanged = pyqtSignal ()
    
    def __init__ ( self, parent = None ):
        QWidget.__init__ ( self,  parent )
        self.__digitsTotal = 12
        self.__decimalPlaces = 2
        self.__decimalMarker = "."
        self.__thousandsSeparator = ","
        self.__value = 0.0
        self.setupUi ( self )
        self.horizontalLayout.setMargin ( 0 )
        self.setLayout ( self.horizontalLayout )
        self.selector.clicked.connect ( self.popupCalculator )
        self.lineEdit.textEdited.connect ( self.on_textEdited )
        self.lineEdit.installEventFilter ( self._deEventFilter )

    def getDigitsTotal ( self ) :
        return self.__digitsTotal
        
    def setDigitsTotal ( self, value ) :
        self.__digitsTotal = value
        
    digitsTotal = pyqtProperty ( int, getDigitsTotal, setDigitsTotal ) # http://www.python.org/download/releases/2.2/descrintro/#property

    def getDecimalPlaces ( self ) :
        return self.__decimalPlaces
        
    def setDecimalPlaces ( self, value ) :
        self.__decimalPlaces = value
        
    decimalPlaces = pyqtProperty ( int, getDecimalPlaces, setDecimalPlaces )

    def getDecimalMarker ( self ) :
        return self.__decimalMarker
        
    def setDecimalMarker ( self, value ) :
        self.__decimalMarker = value

    decimalMarker = pyqtProperty ( str, getDecimalMarker, setDecimalMarker )
    
    def getThousandsSeparator ( self ) :
        return self.__thousandsSeparator
        
    def setThousandsSeparator ( self, value ) :
        self.__thousandsSeparator = value
        
    thousandsSeparator = pyqtProperty ( str, getThousandsSeparator, setThousandsSeparator )
    
    def getValue ( self ) :
        return self.__value
        
    def setValue ( self, value ) :
        self.__value = value
        self.lineEdit.setText ( value )
        # todo : convert to string and show
        
    value = pyqtProperty ( float, getValue, setValue )
    
    def on_textEdited ( self,  _txt ) :
        txt = list ( str ( _txt ) + self.__decimalMarker + "00" )
        cur_pos = self.lineEdit.cursorPosition ()
        dot_pos = -1
        i = 0
        negative = False
        while i < len ( txt ) :
            _i = txt [ i ]
            _del = False # delete current symbol
            if _i == self.__decimalMarker :
                if dot_pos == -1 : # found first fot
                    dot_pos = i
                else: _del = True # found next dot
            elif ( i == 0 ) and ( _i == "0" ) : _del = True # leading zero
            elif _i == "-" : 
                negative = not negative
                _del = True
            elif not _i.isdigit() : _del = True # non-digit
            elif dot_pos != -1 :
                if i > dot_pos + self.__decimalPlaces : _del = True # digits number before dot limit reached
            elif i >= self.__digitsTotal - self.__decimalPlaces : _del = True # dot should already be present
            
            if _del : # delete current symbol
                del txt [ i ]
                if i < cur_pos : cur_pos -= 1
            else : i += 1
            
        i = dot_pos
        while True :
            i -= 3
            if i <= 0 : break
            txt.insert ( i, self.__thousandsSeparator )
            if i < cur_pos : cur_pos += 1
        if negative : # show negative number in red
            txt.insert ( 0, "-" )
            cur_pos += 1
            self.lineEdit.setStyleSheet ( "color: red" );
        else :
            self.lineEdit.setStyleSheet ( "color: black" );
        self.lineEdit.setText ( "".join(txt) )
        self.lineEdit.setCursorPosition ( cur_pos )

    def popupCalculator ( self ) :
        m_PopupCalculator ( self )
