#! /usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from ui_m_PopupCalendar import Ui_m_PopupCalendar 
from ui_m_DateEdit import Ui_m_DateEdit

class calEventFilter ( QObject ) : # event filter for calendar widget
    def __init__ ( self, parent, mde ) :
        QObject.__init__ ( self,  parent )
        self.mde = mde # m_DateEdit

    def eventFilter ( self, target, event ) : # target - calendarWidget or any of its children
#        if event.type() == QEvent.Wheel :
#            if event.delta () > 0 :
#                self.mde.prevMonth.animateClick()
#            else :
#                self.mde.nextMonth.animateClick()
#            return True
        if event.type() == QEvent.KeyPress :
            key = event.key ()
            if event.modifiers () == Qt.NoModifier :
                if key == Qt.Key_PageDown :
                    self.mde.nextMonth.animateClick()
                    return True
                if key == Qt.Key_PageUp :
                    self.mde.prevMonth.animateClick()
                    return True
            elif event.modifiers () == Qt.ShiftModifier :
                if key == Qt.Key_PageDown :
                    self.mde.nextYear.animateClick()
                    return True
                elif key == Qt.Key_PageUp :
                    self.mde.prevYear.animateClick()
                    return True
        elif event.type() == QEvent.MouseButtonPress :
            if event.button () == Qt.RightButton :
                self.mde.specialDate.animateClick()
                return True
        return QObject.eventFilter ( self, target, event ) # standard event processing        

class m_PopupCalendar ( QDialog, Ui_m_PopupCalendar ) :
    """
    Popup window to select date interactively by showing a month calendar
    """
    def __init__ ( self, parent, date = None):
        QDialog.__init__ ( self, parent,  Qt.CustomizeWindowHint )
        self.setupUi ( self )
        #self.setLayout ( self.gridLayout )
        self.positionPopup ( parent )
        parent.setFocus ()

        today_format = QTextCharFormat ()
        today_format.setFontWeight ( QFont.Bold )
        today_format.setFontUnderline ( True )
        self.calendarWidget.setDateTextFormat ( QDate.currentDate (), today_format ) # emphasize today date in calendar

        self.calendarWidget.activated.connect ( self.accept )
        self.calendarWidget.clicked.connect ( self.accept )
        self.calendarWidget.currentPageChanged.connect ( self.currentPageChanged )
        self.calendarWidget.selectionChanged.connect ( self.selectionChanged )
        self.nextMonth.clicked.connect ( self.calendarWidget.showNextMonth )
        self.nextYear.clicked.connect ( self.calendarWidget.showNextYear )
        self.prevMonth.clicked.connect ( self.calendarWidget.showPreviousMonth )
        self.prevYear.clicked.connect ( self.calendarWidget.showPreviousYear )
        self.specialDate.clicked.connect ( self.showMenu )
        self.accepted.connect ( self._accepted )
        
        if isinstance ( date , QDate ) :
            self.calendarWidget.setSelectedDate ( date )
            self.selectionChanged ()
        else :
            self.selectToday ()

        self._calEventFilter = calEventFilter ( self, self )
        self.calendarWidget.installEventFilter ( self._calEventFilter )
        for child in self.calendarWidget.findChildren ( QWidget ) :
            child.installEventFilter ( self._calEventFilter )

        self.show ()
        self.calendarWidget.setFocus ()

    def showMenu ( self ) :
        menu = QMenu ( self )
        selectTodayAction = menu.addAction ( "Today" )
        result = menu.exec_ ( QCursor.pos () )
        if result == selectTodayAction :
            self.selectToday()
        
    def selectToday ( self ) :
        self.calendarWidget.setSelectedDate ( QDate.currentDate () )
        self.selectionChanged ()

    def selectionChanged ( self ) :
        self.labelSelectedDate.setText ( self.calendarWidget.selectedDate().toString ( "dd MMM yyyy" ) )

    def currentPageChanged ( self, year,  month ) :
        months_offset = ( year - self.calendarWidget.selectedDate().year () ) * 12 + month - self.calendarWidget.selectedDate().month ()
        self.calendarWidget.setSelectedDate ( self.calendarWidget.selectedDate().addMonths ( months_offset ) )

    def event ( self, event ) :
        if event.type() == QEvent.WindowDeactivate : # стандартный попап меня пока не устраивает
            self.close() 
            return True # should return true if the event was recognized and processed
        return QDialog.event ( self, event )

    def positionPopup ( self, parent ) : # taken from qdatetimeedit.cpp
        if parent is None : return
        pos = parent.rect().bottomLeft()
        pos2 = parent.rect().topLeft()
        pos = parent.mapToGlobal ( pos )
        pos2 = parent.mapToGlobal ( pos2 )
        screen = QApplication.desktop().availableGeometry(pos)
        if pos.x () + self.width () > screen.right () :
            pos.setX ( max ( screen.right () - self.width (), screen.left () ) )
        if pos.y () + self.height () > screen.bottom () :
            pos.setY ( pos2.y () - self.height () )
        if pos.y () < screen.top () :
            pos.setY ( screen.top () )
        if pos.y () + self.height () > screen.bottom () :
            pos.setY ( screen.bottom () - self.height () )
        self.move ( pos )
        
    def _accepted ( self ) :
        self.parent().value = self.calendarWidget.selectedDate()
    
    def keyPressEvent ( self, event ) : # keyPress on form
        key = event.key ()
        if event.modifiers () == Qt.NoModifier :
            if key == Qt.Key_Insert :
                self.accept ()
                return True # pressing againg Insert closes popup calendar
        return QDialog.keyPressEvent ( self, event )

dateFormat = "dd.MM.yyyy"


class deEventFilter ( QObject ) : # event filter for m_DateEdit's lineEdit
    
    def __init__ ( self, parent = None ) :
        QObject.__init__ ( self,  parent )
    
    def eventFilter ( self, target, event ) : # target - lineEdit
        if event.type() == QEvent.Wheel :
            _date = target.parent().value
            if _date.isValid() :
                _numSteps = event.delta() / 120
                _cur = target.cursorPositionAt ( event.pos () )
                if _cur <= 2 : # day was 'wheeled'
                    self.addDays ( target, 1, _numSteps )
                elif _cur <= 5 : # month was 'wheeled'
                    self.addDays ( target, 2, _numSteps )
                else : # year was 'wheeled'
                    self.addDays ( target, 3, _numSteps )
            return True
        elif event.type() == QEvent.MouseButtonDblClick :
            if event.button () == Qt.LeftButton :
                target.selectAll () # select all on double click, otherwise only group of digits will be selected
                return True
        elif event.type() == QEvent.KeyPress :
            key = event.key ()
            if event.modifiers () == Qt.NoModifier :
                if key == Qt.Key_Insert :
                    target.parent().popupCalendar ()
                    return True
                elif key == Qt.Key_Down :
                    self.addDays ( target, 1, -1 )
                    return True
                elif key == Qt.Key_Up :
                    self.addDays ( target, 1, 1 )
                    return True
                elif key == Qt.Key_PageDown :
                    self.addDays ( target, 2, -1 )
                    return True
                elif key == Qt.Key_PageUp :
                    self.addDays ( target, 2, 1 )
                    return True
            elif event.modifiers () == Qt.ShiftModifier :
                if key == Qt.Key_PageDown :
                    self.addDays ( target, 3, -1 )
                    return True
                elif key == Qt.Key_PageUp :
                    self.addDays ( target, 3, 1 )
                    return True
            elif not target.hasSelectedText () :
                pass
#                if key in ( Qt.Key_Backspace, Qt.Key_Delete, Qt.Key_0, Qt.Key_1, Qt.Key_2, Qt.Key_3, 
#                           Qt.Key_4, Qt.Key_5, Qt.Key_6, Qt.Key_7, Qt.Key_8, Qt.Key_9 ) :
#                    txt = target.text ()
#                    cur_pos = target.cursorPosition ()
#                    if key == Qt.Key_Backspace :
#                        posvaluenext = cur_pos - 1 # position to check for character
#                        pos_move = cur_pos - 1 # position to move to
#                    else : # delete or digit
#                        posvaluenext = cur_pos
#                        pos_move = cur_pos + 1
#                    if 0 <= posvaluenext < len ( txt ) :
#                        if txt [ posvaluenext ] == '.' : # the cursor is next to a point
#                            target.setCursorPosition ( pos_move ) # "skip" point on delete
        elif event.type() == QEvent.FocusOut :
            target.parent().value = target.text()
        return QObject.eventFilter ( self, target, event ) # standard event processing

    def addDays ( self, target, section, number ) : # target - lineEdit
        _date = target.parent().value
        _cur = target.cursorPosition ()
        if section == 1 : # day was 'wheeled'
            _date = _date.addDays ( number )
        elif section == 2 : # month was 'wheeled'
            _date = _date.addMonths ( number )
        elif section == 3 : # year was 'wheeled'
            _date = _date.addYears ( number )
        target.parent().value = _date
        target.setCursorPosition ( _cur )

class m_DateEdit ( QWidget, Ui_m_DateEdit ) :
    """
    Custom widget for editing dates. 
    Allows selecting a date using a popup calendar.
    """
    _deEventFilter = deEventFilter () # static member
    def __init__ ( self, parent = None ) :
        QWidget.__init__ ( self,  parent )
        self.__date = QDate ()
        self.setupUi ( self )
        self.horizontalLayout.setMargin ( 0 )
        self.setLayout ( self.horizontalLayout )
        self.selector.clicked.connect ( self.popupCalendar )
        self.lineEdit.textEdited.connect ( self.on_textEdited )
        self.lineEdit.installEventFilter ( self._deEventFilter )

    def on_textEdited ( self, _txt ) :
        txt = list ( str ( _txt ) )
        cur_pos = self.lineEdit.cursorPosition ()
        i = 0
        while i < len ( txt ) :
            _i = txt [ i ]
            if not ( _i.isdigit() or _i == '_' ) : 
                del txt [ i ]
                if i < cur_pos : cur_pos -= 1 # курсор должен находится все после той же цифры
            else : 
                i += 1
        _len = 8 # standard length (__.__.____)
        fst_part = txt [ : min ( cur_pos, _len ) ]
        lst_part = txt [ max ( len ( fst_part ), len ( txt ) - _len + len ( fst_part ) ) : len ( txt ) ]
        mid_part = [ '_' for i in range ( _len - len ( fst_part ) - len ( lst_part ) ) ]
        a = "".join ( fst_part + mid_part + lst_part )
        a = a [ 0 : 2 ] + '.' + a [ 2 : 4 ] + '.' + a [ 4 : ]
        if cur_pos > 4 :
           cur_pos += 2 # поправка курсора из-за вставленной точки
        elif cur_pos > 2 :
           cur_pos += 1
        self.lineEdit.setText ( a )
        self.lineEdit.setCursorPosition ( cur_pos )

    def popupCalendar ( self ) :
        m_PopupCalendar ( self, self.value )

    def getShowSelector ( self ) :
        return self.selector.isVisible()
        
    def setShowSelector ( self, value ) :
        self.selector.setVisible ( value )
            
    showSelector = pyqtProperty ( bool, getShowSelector, setShowSelector )

    def getDate ( self ) :
        return self.__date
        
    def setDate ( self, value ) :
        if isinstance ( value , QDate ) :
            self.__date = value
        elif isinstance ( value , str ) or isinstance ( value , QString ):
            self.__date = QDate.fromString ( value, dateFormat )
        else :
            self.__date = QDate ()
        if self.__date.isValid() :
            self.lineEdit.setText ( self.__date.toString ( dateFormat ) )
        else :
            self.lineEdit.setText ( "__.__.____" )
            
    value = pyqtProperty ( QDate, getDate, setDate )
