#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Script to compile all .ui and .qrc files to Python source.
"""

import sys, os, subprocess

_path = os.path.dirname ( os.path.abspath ( sys.argv [ 0 ] ) )

for dirpath, _, filenames in os.walk ( _path ) : 
    for filename in filenames :

        def file_fresh ( _in,  _out ) : # is there a need to process the file? let's compare the modification times
            try :
                return os.path.getmtime ( _in ) <= os.path.getmtime ( _out ) # if out file is older then in file - need to process it again, because in file was changed
            except : # file doesn't exist or other error
                return False
            
        
        if filename.endswith ( '.ui' ) :
            py_file = os.path.join ( dirpath, 'ui_' + filename [ : -3 ] + '.py' )
            if not file_fresh ( filename, py_file ) :
                print ( "Compiling: " + filename )
                retcode = subprocess.call ( [ 'pyuic4', filename, '-o', py_file ] )
        elif filename.endswith ( '.qrc' ) :
            py_file = os.path.join ( dirpath, filename [ : -4 ] + '_rc.py' )
            if not file_fresh ( filename, py_file ) :
                print ( "Compiling: " + filename )
                retcode = subprocess.call ( [ "pyrcc4", filename, '-o', py_file ] )
            

