# -*- coding: utf-8 -*-

"""
Этот модуль содержит основные классы и функции для работы пользовательских модулей
"""

import sys, os, imp, traceback
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import uic

app_dir = os.path.dirname ( os.path.abspath ( sys.argv [ 0 ] ) )
conf_dir = None # home directory of loaded configuration
global_module = None # theoretically there could be cases when there is no global module
form_module_index = 0

def exec_func ( func_name, context ) :
    try :
        func = getattr ( context, func_name )
    except AttributeError :
        return None
    if not hasattr ( func, "__call__" ) : # is it callable?
        return None
  
    try :
        res = func ()
        return res
    except :
        message_window.printMessage ( traceback.format_exc().replace ('\n', '<br>') )
#        try :
#            exc_type, exc_value, trace_back = sys.exc_info ()
#            info = ''
#            while trace_back :
#                co = trace_back.tb_frame.f_code
#                info += "{0} Line {1}<br>".format ( co.co_filename, traceback.tb_lineno ( trace_back ) ) 
#                trace_back = trace_back.tb_next
#            info += "et = {0}<br>ev = {1}".format ( str ( exc_type ), str ( exc_value ) )
#            message_window.printMessage ( info )
#        finally : # http://docs.python.org/library/sys.html
#            del trace_back # Assigning the traceback return value to a local variable in a function that is handling an exception will cause a circular reference
        return None

def open_form ( fileName ) :
        fileName = str ( fileName )
        ui_filename = os.path.join ( os.path.dirname ( fileName ), "form.ui" )
        
        form_class, base_class = uic.loadUiType ( ui_filename )
        class m_form_class ( base_class, form_class ) : # base_class must be QDialog 
            def __init__ ( self, parent ) :
                base_class.__init__ ( self, parent )
                self.setupUi ( self ) 
                if self.minimumSizeHint().isEmpty () :
                    self.setMinimumSize ( self.width (), self.height () )
                self.setLayout ( self.layout ) # form should have QLayout widget with name 'layout'
                #change size policy if layout is given?
                self.finished.connect ( self._finished )
            def _finished ( self ) :
                self.close ()
            def closeEvent ( self,  event ) :
                if exec_func ( "on_Form_close", self.Module ) == False :
                    event.ignore()
                    self.show()
                    return
                self.parentWidget().close() # close sub window
                #print sys.getrefcount ( self.module ) # http://stackoverflow.com/questions/437589/how-do-i-unload-reload-a-python-module/487718#487718
                for k, v in sys.modules.iteritems() :
                    if v == self.Module :
                        del sys.modules [ k ]
                        del self.Module
                        break

        global form_module_index
        form_module_index += 1
        
        try :
            module = imp.load_source ( "form_module_" + str ( form_module_index ), fileName )
            exec 'from PyQt4.QtCore import *; from PyQt4.QtGui import *' in module.__dict__
            module.Gm = global_module
            module.m_ = global_module.m_

            if exec_func ( "on_Module_load", module ) == False :
                return 

            form = m_form_class ( app.main_window.mdi_area )

            window = QMdiSubWindow ()
            window.setAttribute ( Qt.WA_DeleteOnClose )
            window.setWidget ( form )
            app.main_window.mdi_area.addSubWindow ( window )
            #form.setWindowTitle ( "Catalog_item" )
            window.show ()

            module.Form = form
            form.Module = module
            exec_func ( "on_Form_load", module )
            
            for child in form.children() :
                child_name = child.objectName()

                def bind ( signal_name ) :
                    try :
                        getattr ( child,  signal_name ).connect ( getattr ( module, "on_{0}_{1}".format( child_name, signal_name ) ) )
                    except Exception, err:
                        pass # message_window.printMessage ( 'Binding signals notice: %s\n' % str(err) )

                if isinstance ( child, QTextEdit ) :
                    bind ( "textChanged" )
                elif isinstance ( child, QCheckBox ) :
                    bind ( "stateChanged" )
                elif isinstance ( child, QLineEdit ) :
                    bind ( "textEdited" )
                elif isinstance ( child, QPushButton ) :
                    bind ( "clicked" )

        except Exception, err:
            message_window.printMessage ( 'Error importing module "{0}".'.format ( fileName ) )
            raise
