# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import math, random

class Liss ( QWidget ) :
    def __init__ ( self, parent = None ) :
        QWidget.__init__ ( self, parent )

        self.timer = QTimer ()
        self.timer.timeout.connect ( self.NextStep )

        self.resetParams ()

        self.painter = QPainter ()
        self.antialiasing = True

        self.pen1 = QPen ( QColor ( "yellow" ), 2, Qt.SolidLine )
        self.pen2 = QPen ( QColor ( "white" ), 2, Qt.SolidLine )
        
        self.NextStep ()


    def start ( self ) :
        self.timer.start ( 40 )

    def stop ( self ) :
        self.timer.stop ()

    def resetParams ( self ) : # default values
        self.M = random.randint ( 10, 10000 )
        self.L = random.randint ( 10, 10000 )
        self.N = random.randint ( 5, 40 ) # number of line strokes
        self.B = 2 * math.pi / self.N # intermediar coeficient
        self.step = 0 # current step
        self.SPT = 100 # spt - steps per transition from one figure to another
        self.d = 0 # current delta which depends on frame, intermediar coeficient representing current step
        self.pause = 0 # number of steps to wait when a transition is over
        self.step_direction = 1

    def NextStep ( self ) : # increase step and calculate coeficients for it
        if self.pause > 0:
            self.pause -= 1
            return
        self.step += self.step_direction
        if self.step > self.SPT or self.step < 0:
            self.step = ( self.step + self.SPT ) % self.SPT
            self.M += self.step_direction
            self.L += self.step_direction
            self.pause = 20
        self.d = 0.5 * ( 1 - math.cos ( math.pi * self.step / self.SPT ) ) # angular step
        self.l = ( self.L + self.d ) * self.B
        self.m = ( self.M + self.d ) * self.B
        self.update ()

    def paintEvent ( self, event ) :
        if not self.pixmap : return
        self.pixmap.fill ( QColor ( "black" ) )

        w2 = int ( self.w / 2 ) #center
        h2 = int ( self.h / 2 )
        x1 = w2
        y1 = h2 * 2
        
        self.painter.begin ( self.pixmap )
        self.painter.setRenderHint ( QPainter.Antialiasing, self.antialiasing )
        for k in range ( 1, self.N + 1 ):
            x2 = int ( w2 * ( math.sin ( k * self.m ) + 1 ) + 0.5 )
            y2 = int ( h2 * ( math.cos ( k * self.l ) + 1 ) + 0.5 )
            self.painter.setPen ( self.pen1 if k % 2 else self.pen2 )
            self.painter.drawLine ( x1, y1, x2, y2 )
            x1, y1 = x2, y2

        self.painter.end ()

        self.painter.begin ( self )
        self.painter.drawPixmap ( 0, 0, self.pixmap )
        self.painter.end ()

    def resizeEvent (self, event ) :
        self.w = self.width ()
        self.h = self.height ()
        self.pixmap = QPixmap ( self.w, self.h )



def on_Form_load () : # event called by m_py after it loads Form
    global dt
    dt = Liss ()
    Form.verticalLayout.addWidget (dt)
    dt.show()
    dt.antialiasing = True
    Form.antialiasing.setCheckState ( Qt.Checked )
    #Form.parentWidget().setWindowState ( Qt.WindowMaximized )

def on_buttonStart_clicked ( _checked = False ) : 
    if dt.timer.isActive () :
        dt.stop ()
        Form.buttonStart.setText ( 'Start' )
    else :
        dt.start ()
        Form.buttonStart.setText ( 'Stop' )

def on_buttonReset_clicked ( _checked = False ) : 
    dt.resetParams()

def on_antialiasing_stateChanged ( _state ) : 
    dt.antialiasing = _state
