/*
    explorer-,     .
()   orefkov@gmail.com
*/
#if !defined(AFX_FOLDERPANEL_H__FCA1AF8E_6C26_4F15_9BF7_A14E50C7943C__INCLUDED_)
#define AFX_FOLDERPANEL_H__FCA1AF8E_6C26_4F15_9BF7_A14E50C7943C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FolderPanel.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CFolderPanel html view

class CFolderPanel : public CWnd,
	IShellBrowser,IServiceProvider,ICommDlgBrowser
{
protected:
	DECLARE_DYNCREATE(CFolderPanel)

// html Data
public:
	IShellFolder*	m_pDesktop;
	IMalloc*		m_pMalloc;
	IShellFolder*	m_pFolder;
	IShellView*		m_pView;
	HWND			m_hFolderView;
	CString			m_path;
	CFont			m_hFont;
	int				m_tHeight;
	LPITEMIDLIST	m_pIdl;

	void Navigate(LPCTSTR path);
	void Navigate(LPCITEMIDLIST pidl);

	CFolderPanel();
	virtual ~CFolderPanel();
	//{{AFX_DATA(CFolderPanel)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA
	STDMETHOD(QueryInterface)(REFIID riid, LPVOID * ppvObj);
	STDMETHOD_(ULONG,AddRef)(){return 1;}
	STDMETHOD_(ULONG,Release)(){return 1;}

	// *** IOleWindow methods ***
	STDMETHOD(GetWindow)(HWND *lphwnd){*lphwnd=m_hWnd;return S_OK;}
	STDMETHOD(ContextSensitiveHelp)(BOOL fEnterMode){return E_NOTIMPL;}

	// *** IShellBrowser methods *** (same as IOleInPlaceFrame)
	STDMETHOD(InsertMenusSB)(HMENU hmenuShared,LPOLEMENUGROUPWIDTHS lpMenuWidths){return S_OK;}
	STDMETHOD(SetMenuSB)(HMENU hmenuShared, HOLEMENU holemenuReserved,HWND hwndActiveObject){return S_OK;}
	STDMETHOD(RemoveMenusSB)(HMENU hmenuShared){return S_OK;}
	STDMETHOD(SetStatusTextSB)(LPCOLESTR lpszStatusText)
	{
		CString txt=lpszStatusText;
		pBkEndUI->DoStatusLine(txt);
		return S_OK;
	}
	STDMETHOD(EnableModelessSB)(BOOL fEnable){return E_NOTIMPL;}
	STDMETHOD(TranslateAcceleratorSB)(LPMSG lpmsg, WORD wID)
	{
		return S_OK;
	}

	// *** IShellBrowser methods ***
	STDMETHOD(BrowseObject)(LPCITEMIDLIST pidl, UINT wFlags);
	STDMETHOD(GetViewStateStream)(DWORD grfMode,LPSTREAM  *ppStrm){return E_NOTIMPL;}
	STDMETHOD(GetControlWindow)(UINT id, HWND* lphwnd);
	STDMETHOD(SendControlMsg)(UINT id, UINT uMsg, WPARAM wParam,LPARAM lParam, LRESULT * pret);
	STDMETHOD(QueryActiveShellView)(IShellView** ppshv)
	{
		*ppshv=m_pView;
		return S_OK;
	}
	STDMETHOD(OnViewWindowActive)(IShellView* ppshv)
	{
		SetToolBar();
		return S_OK;
	}
	STDMETHOD(SetToolbarItems)(LPTBBUTTON lpButtons, UINT nButtons,UINT uFlags)
	{
		return S_OK;
	}

	// IServiceProvider
	STDMETHOD(QueryService)(REFGUID guidService,REFIID riid,void** ppvObject)
	{
		if(riid==IID_IShellBrowser)
		{
			*ppvObject=(IShellBrowser*)this;
			return S_OK;
		}
		return E_NOINTERFACE;
	}

	// ICommDlgBrowser
    STDMETHOD(OnDefaultCommand)(IShellView* ppshv);
    STDMETHOD(OnStateChange)(IShellView* ppshv,ULONG uChange);
    STDMETHOD(IncludeObject)(IShellView* ppshv,LPCITEMIDLIST pidl);


// Operations
public:
	bool OpenFiles(CStringArray& files,bool ForceOpen);
	void CopyPIDL(LPCITEMIDLIST pidl,LPITEMIDLIST& dest);
	void GoUp();
	bool GetSelectedObjects(CStringArray& files);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFolderPanel)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CFolderPanel)
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnPaint();
	afx_msg void OnOpenFile();
	afx_msg void OnUpdateOpenFile(CCmdUI* pCmdUI);
	afx_msg void OnGoup();
	afx_msg void OnUpdateGoup(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FOLDERPANEL_H__FCA1AF8E_6C26_4F15_9BF7_A14E50C7943C__INCLUDED_)
