// FolderPanel.cpp : implementation file
//

#include "stdafx.h"
#include "FolderPanel.h"

IMPLEMENT_DYNCREATE(CFolderPanel, CWnd)

CFolderPanel::CFolderPanel()
{
	SHGetDesktopFolder(&m_pDesktop);
	SHGetMalloc(&m_pMalloc);
	m_pFolder=NULL;
	m_pView=NULL;
	m_hFolderView=NULL;
	m_pIdl=NULL;

	//{{AFX_DATA_INIT(CFolderPanel)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CFolderPanel::~CFolderPanel()
{
	if(m_pIdl)
		delete [] m_pIdl;
	m_pDesktop->Release();
	m_pMalloc->Release();
}

STDMETHODIMP CFolderPanel::QueryInterface(REFIID riid, LPVOID * ppvObj)
{
	*ppvObj=NULL;
	if(riid==IID_IOleWindow)
		*ppvObj=(IOleWindow*)this;
	else if(riid==IID_IShellBrowser)
		*ppvObj=(IShellBrowser*)this;
	else if(riid==IID_IUnknown)
		*ppvObj=(IUnknown*)(IShellBrowser*)this;
	else if(riid==IID_IServiceProvider)
		*ppvObj=(IServiceProvider*)this;
	else if(riid==IID_ICommDlgBrowser)
		*ppvObj=(ICommDlgBrowser*)this;
	if(*ppvObj)
		return S_OK;	// AddRef  ,      
	return E_NOINTERFACE;
}

BEGIN_MESSAGE_MAP(CFolderPanel, CWnd)
	//{{AFX_MSG_MAP(CFolderPanel)
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_SETFOCUS()
	ON_WM_PAINT()
	ON_COMMAND(ID_OPEN_FILE, OnOpenFile)
	ON_UPDATE_COMMAND_UI(ID_OPEN_FILE, OnUpdateOpenFile)
	ON_COMMAND(ID_GOUP, GoUp)
	ON_UPDATE_COMMAND_UI(ID_GOUP, OnUpdateGoup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CFolderPanel::Navigate(LPCTSTR path)
{
	_bstr_t bPath=path;
	ULONG ul;
	LPITEMIDLIST pidl;

	if(S_OK==m_pDesktop->ParseDisplayName(m_hWnd,NULL,bPath,&ul,&pidl,NULL))
	{
		Navigate(pidl);
		m_pMalloc->Free(pidl);
	}
}

void CFolderPanel::Navigate(LPCITEMIDLIST pidl)
{
	if(!pidl)
		return;
	if(m_pFolder)
	{
		m_pFolder->Release();
		m_pFolder=NULL;
	}
		
	IShellView* shView=NULL;
	HWND hNewView=NULL;
	HRESULT hr;
	if(!pidl->mkid.cb)
		hr=SHGetDesktopFolder(&m_pFolder);
	else
		hr=m_pDesktop->BindToObject(pidl,NULL,IID_IShellFolder,(void**)&m_pFolder);
	CopyPIDL(pidl,m_pIdl);
	if(S_OK==hr && m_pFolder)
	{
		if((S_OK==m_pFolder->CreateViewObject(m_hWnd,IID_IShellView,(void**)&shView)) && shView)
		{
			//   
			m_path="";
			char txt[MAX_PATH];
			if(pidl->mkid.cb && SHGetPathFromIDList(pidl,txt))
				m_path=txt;
			else
			{
				STRRET ret;
				if(S_OK==m_pDesktop->GetDisplayNameOf(pidl,SHGDN_INCLUDE_NONFILESYS|SHGDN_FORADDRESSBAR,&ret))
				{
					switch(ret.uType)
					{
					case STRRET_CSTR:
						m_path=ret.cStr;
						break;
					case STRRET_WSTR:
						m_path=ret.pOleStr;
						m_pMalloc->Free(ret.pOleStr);
						break;
					}
				}
			}
			FOLDERSETTINGS fs;
			if(m_pView)
				m_pView->GetCurrentInfo(&fs);
			else
				fs.ViewMode=FVM_DETAILS;
			fs.fFlags=/*FWF_SINGLESEL|*/FWF_NOCLIENTEDGE/*|0x10000*/;//FWF_NOWEBVIEW;
			CRect rc;
			GetClientRect(rc);
			rc.top=m_tHeight;
			if(S_OK==shView->CreateViewWindow(m_pView,&fs,this,&rc,&hNewView))
			{
				bool focus=false;
				HWND hOld=::GetFocus();
				if(hOld==m_hFolderView || ::IsChild(m_hFolderView,hOld))
					focus=true;
				::ShowWindow(hNewView,SW_SHOW);
				HWND hh=::GetWindow(hNewView,GW_CHILD);
				while(hh)
				{
					::ShowWindow(hh,SW_SHOW);
					hh=::GetWindow(hh,GW_CHILD);
				}
				shView->Refresh();
				if(focus)
				{
					::SetFocus(hNewView);
					shView->UIActivate(SVUIA_ACTIVATE_FOCUS);
				}
			}
			else
			{
				shView->Release();
				shView=NULL;
				hNewView=NULL;
			}
		}
	}
	if(m_pView)
	{
		m_pView->DestroyViewWindow();
		m_pView->Release();
	}
	m_pView=shView;
	m_hFolderView=hNewView;
	Invalidate();
	UpdateWindow();
}

STDMETHODIMP CFolderPanel::BrowseObject(LPCITEMIDLIST pidl, UINT wFlags)
{
	Navigate(pidl);
	return S_OK;
}

void CFolderPanel::OnDestroy() 
{
	if(m_pView)
	{
		if(m_hFolderView)
			m_pView->DestroyViewWindow();
		m_pView->Release();
	}
	if(m_pFolder)
		m_pFolder->Release();
	CWnd::OnDestroy();
}

void CFolderPanel::OnSize(UINT nType, int cx, int cy) 
{
	if(m_hFolderView)
	{
		CRect rc;
		GetClientRect(rc);
		::MoveWindow(m_hFolderView,0,m_tHeight,rc.right,rc.bottom-m_tHeight,TRUE);
	}
}

void CFolderPanel::OnSetFocus(CWnd* pOldWnd) 
{
	CWnd::OnSetFocus(pOldWnd);
	if(m_pView)
	{
		if(m_hFolderView)
			::SetFocus(m_hFolderView);
		m_pView->UIActivate(SVUIA_ACTIVATE_FOCUS);
	}
	SetToolBar();
}

BOOL CFolderPanel::PreTranslateMessage(MSG* pMsg) 
{
	if(m_pView && pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam=='\b')
		{
			// backspace.  ,  
			//   ,  ,   
			char buf[MAX_PATH];
			GetClassName(::GetFocus(),buf,MAX_PATH);
			if(stricmp("edit",buf))
			{
				GoUp();
				return TRUE;
			}
		}
		else if(pMsg->wParam==VK_RETURN)
		{
			if(GetKeyState(VK_SHIFT) & 0x8000)
			{
				CStringArray files;
				if(GetSelectedObjects(files))
					OpenFiles(files,true);
				return TRUE;
			}
		}
		if(S_OK==m_pView->TranslateAccelerator(pMsg))
			return TRUE;
	}
	return FALSE;
}

STDMETHODIMP CFolderPanel::GetControlWindow(UINT id, HWND* lphwnd)
{
	*lphwnd=NULL;
	return S_OK;
}

STDMETHODIMP CFolderPanel::SendControlMsg(UINT id, UINT uMsg, WPARAM wParam,LPARAM lParam, LRESULT * pret)
{
	return S_OK;
}

void CFolderPanel::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CGdiObject* pOldFont=dc.SelectObject(&m_hFont);
	dc.SetBkMode(TRANSPARENT);
	dc.SetTextColor(RGB(255,255,255));
	CRect rc;
	GetClientRect(rc);
	rc.left=3;
	rc.top=1;

	char buf[MAX_PATH+4];
	strcpy(buf,m_path);
	dc.DrawText(buf,-1,rc,DT_PATH_ELLIPSIS|DT_MODIFYSTRING|DT_SINGLELINE);
	HDC hdc=dc;
	HGDIOBJ hOldPen=::SelectObject(hdc,GetStockObject(WHITE_PEN));
	dc.MoveTo(0,0);
	dc.LineTo(32000,0);
	dc.MoveTo(0,m_tHeight-2);
	dc.LineTo(32000,m_tHeight-2);

	dc.MoveTo(0,0);
	dc.LineTo(0,m_tHeight-2);

	dc.MoveTo(rc.right-1,0);
	dc.LineTo(rc.right-1,m_tHeight-2);

	::SelectObject(hdc,hOldPen);
	dc.SelectObject(pOldFont);
}

STDMETHODIMP CFolderPanel::OnDefaultCommand(IShellView* ppshv)
{
	CStringArray files;
	if(GetSelectedObjects(files))
	{
		if(OpenFiles(files,false))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CFolderPanel::OnStateChange(IShellView* ppshv,ULONG uChange)
{
	return S_OK;
}

STDMETHODIMP CFolderPanel::IncludeObject(IShellView* ppshv,LPCITEMIDLIST pidl)
{
	/*
	Allows the common dialog to filter objects that the view displays. 
	The browser should return S_OK to include the object in the view, or S_FALSE to hide it. 
	ppshv  - IShellFolder interface address of the view. 
	pidl   - Address of an identifier list (IDLIST) that is relative to the folder
	*/
	return S_OK;
}

bool CFolderPanel::GetSelectedObjects(CStringArray &files)
{
	IDataObjectPtr dobj;
	if((S_OK==m_pView->GetItemObject(SVGIO_SELECTION,IID_IDataObject,(void**)&dobj)) && dobj!=NULL)
	{
		FORMATETC fmt;
		STGMEDIUM stg;
		fmt.cfFormat=CF_HDROP;
		fmt.tymed=TYMED_HGLOBAL;
		if(S_OK==dobj->GetData(&fmt,&stg))
		{
			DROPFILES* df=(DROPFILES*)GlobalLock(stg.hGlobal);
			if(df->fWide)
			{
				WCHAR* ptr=(WCHAR*)(((char*)df)+df->pFiles);
				while(*ptr)
				{
					CString file=ptr;
					files.Add(file);
					ptr+=file.GetLength()+1;
				}
			}
			else
			{
				LPCTSTR ptr=(LPCTSTR)(((char*)df)+df->pFiles);
				while(*ptr)
				{
					CString file=ptr;
					files.Add(file);
					ptr+=file.GetLength()+1;
				}
			}
			GlobalUnlock(stg.hGlobal);
			GlobalFree(stg.hGlobal);
			if(stg.pUnkForRelease)
				stg.pUnkForRelease->Release();
			return true;
		}
	}
	return false;
}

void CFolderPanel::GoUp()
{
	if(!m_pIdl)
		return;
	LPITEMIDLIST pidl=NULL,fnd,prev=NULL;
	CopyPIDL(m_pIdl,pidl);
	fnd=pidl;
	while(fnd->mkid.cb)
	{
		prev=fnd;
		fnd=(LPITEMIDLIST)(((LPBYTE)fnd)+fnd->mkid.cb);
	}
	if(prev)
	{
		if(!::IsChild(m_hWnd,::GetFocus()))
		{
			::SetFocus(m_hFolderView);
			m_pView->UIActivate(SVUIA_ACTIVATE_FOCUS);
		}
		prev->mkid.cb=0;
		Navigate(pidl);
		delete [] pidl;
	}
}

void CFolderPanel::CopyPIDL(LPCITEMIDLIST pidl,LPITEMIDLIST& dest)
{
	if(dest)
	{
		delete [] dest;
		dest=NULL;
	}
	if(!pidl)
		return;
	int size=0,cb;
	LPCITEMIDLIST ptr=pidl;
	do{
		cb=ptr->mkid.cb;
		size+=cb;
		ptr=(LPCITEMIDLIST)(((char*)ptr)+cb);
	}while(cb);
	size+=sizeof(*ptr);
	dest=(LPITEMIDLIST)new char[size];
	memcpy(dest,pidl,size);
}

bool CFolderPanel::OpenFiles(CStringArray &files, bool ForceOpen)
{
	bool opened=false;
	int size=files.GetSize();
	for(int i=0;i<size;i++)
	{
		CString file=files[i];
		if(IsFileExist(file))
		{
			int OpenIn=0;	// 0 -  , 1 -  Configurator, 2 -   
			int dec=file.ReverseFind('.');
			if(dec>-1)
			{
				CString ext=file.Mid(dec) + "\\";
				ext.MakeLower();
				if(strstr(".ert\\.mxl\\.txt\\.prm\\.spl\\",ext))
					OpenIn=1;
			}
			if(!OpenIn)
			{
				//      
				if(ForceOpen)
					OpenIn=2;
			}
			if(OpenIn==1)
				opened=pConfSvc->OpenFile(file)!=NULL;
			else if(OpenIn==2)
				opened=CScriptEditDoc::OpenFile(file)!=NULL;
		}
	}
	return opened;
}

void CFolderPanel::OnOpenFile() 
{
	CStringArray files;
	GetSelectedObjects(files);
	OpenFiles(files,true);
}

void CFolderPanel::OnUpdateOpenFile(CCmdUI* pCmdUI) 
{
	CStringArray files;
	GetSelectedObjects(files);
	bool enabled=false;
	int s=files.GetSize();
	for(int i=0;i<s;i++)
	{
		if(IsFileExist(files[i]))
		{
			enabled=true;
			break;
		}
	}
	pCmdUI->Enable(enabled);
}

void CFolderPanel::OnUpdateGoup(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_pIdl->mkid.cb);
}

BOOL CFolderPanel::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	BOOL ret=CWnd::CreateEx(WS_EX_CLIENTEDGE,
		AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,NULL,(HBRUSH)GetStockObject(LTGRAY_BRUSH)),NULL,
		WS_CHILD|WS_TABSTOP|WS_CLIPCHILDREN,rect,pParentWnd,nID,pContext);
	if(ret)
	{
		LOGFONT lf;
		HFONT hFont=(HFONT)GetStockObject(DEFAULT_GUI_FONT);
		GetObject(hFont,sizeof(lf),&lf);
		//lf.lfHeight*=5;
		//lf.lfHeight/=4;
		lf.lfWeight=800;
		m_hFont.CreateFontIndirect(&lf);
		CDC* pDC=GetDC();
		CGdiObject* pOldFont=pDC->SelectObject(&m_hFont);
		m_tHeight=pDC->GetTextExtent(" ").cy+4;
		pDC->SelectObject(pOldFont);
		ReleaseDC(pDC);
	}
	return ret;
}
