VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{C368D713-CC5F-40ED-9F53-F84FE197B96A}#3.0#0"; "mapwingis.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "MapWinGIS Sample Project"
   ClientHeight    =   7935
   ClientLeft      =   150
   ClientTop       =   540
   ClientWidth     =   13005
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7935
   ScaleWidth      =   13005
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin MapWinGIS.Map Map1 
      Height          =   4815
      Left            =   4200
      TabIndex        =   39
      Top             =   3000
      Width           =   8655
      _Version        =   196608
      _ExtentX        =   15266
      _ExtentY        =   8493
      _StockProps     =   0
   End
   Begin VB.CommandButton btnColorLayer 
      Caption         =   "Color the layer with a gradient color sheme"
      Height          =   1095
      Left            =   120
      TabIndex        =   36
      Top             =   6120
      Width           =   1215
   End
   Begin VB.CommandButton btnAddImage 
      Caption         =   "Set the selected layer Image if it is a  Point Shapefile"
      Height          =   1215
      Left            =   120
      Picture         =   "frmMain.frx":0000
      Style           =   1  'Graphical
      TabIndex        =   35
      Top             =   4800
      Width           =   1215
   End
   Begin VB.Frame Frame5 
      Caption         =   "Drawings"
      Height          =   2175
      Left            =   10320
      TabIndex        =   31
      Top             =   600
      Width           =   2535
      Begin VB.OptionButton ScreenReferenced 
         Caption         =   "Screen Referenced"
         Height          =   195
         Left            =   360
         TabIndex        =   38
         Top             =   1800
         Width           =   1935
      End
      Begin VB.OptionButton SpatiallyReferenced 
         Caption         =   "Spatially Referenced"
         Height          =   195
         Left            =   360
         TabIndex        =   37
         Top             =   1440
         Value           =   -1  'True
         Width           =   1935
      End
      Begin VB.CommandButton btnClearDrawings 
         Caption         =   "Clear Drawings"
         Height          =   375
         Left            =   240
         TabIndex        =   34
         Top             =   960
         Width           =   1935
      End
      Begin VB.CommandButton btnDrawPoint 
         Caption         =   "Draw a Point"
         Height          =   375
         Left            =   240
         TabIndex        =   33
         Top             =   600
         Width           =   1935
      End
      Begin VB.CommandButton btnDrawLine 
         Caption         =   "Draw a Line"
         Height          =   375
         Left            =   240
         TabIndex        =   32
         Top             =   240
         Width           =   1935
      End
   End
   Begin VB.CommandButton btnMoveLayerDown 
      Caption         =   "Move Seleted Layer down"
      Height          =   735
      Left            =   120
      TabIndex        =   30
      Top             =   3960
      Width           =   1215
   End
   Begin VB.CommandButton btnMoveLayerUp 
      Caption         =   "Move Seleted Layer up"
      Height          =   735
      Left            =   120
      TabIndex        =   29
      Top             =   3120
      Width           =   1215
   End
   Begin MSComctlLib.ListView lvLegend 
      Height          =   4815
      Left            =   1440
      TabIndex        =   28
      Top             =   3000
      Width           =   2655
      _ExtentX        =   4683
      _ExtentY        =   8493
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      Checkboxes      =   -1  'True
      FullRowSelect   =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.Frame Frame4 
      Caption         =   "Labeling"
      Height          =   2175
      Left            =   6360
      TabIndex        =   19
      Top             =   600
      Width           =   3855
      Begin VB.CommandButton btnClearLabels 
         Caption         =   "Clear All Labels"
         Height          =   300
         Left            =   1440
         TabIndex        =   27
         Top             =   1440
         Width           =   1440
      End
      Begin VB.ComboBox cbFieldToUse 
         Height          =   315
         Left            =   1200
         Style           =   2  'Dropdown List
         TabIndex        =   26
         Top             =   720
         Width           =   2415
      End
      Begin VB.ComboBox cbLayerToLabel 
         Height          =   315
         Left            =   1200
         Style           =   2  'Dropdown List
         TabIndex        =   25
         Top             =   360
         Width           =   2415
      End
      Begin VB.CommandButton cmdFontColor 
         BackColor       =   &H00000000&
         Height          =   255
         Left            =   1200
         Style           =   1  'Graphical
         TabIndex        =   24
         Top             =   1080
         Width           =   495
      End
      Begin VB.CommandButton cmdLabel 
         Caption         =   "Label Shapes"
         Height          =   300
         Left            =   120
         TabIndex        =   20
         Top             =   1440
         Width           =   1200
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "Label Color:"
         Height          =   195
         Left            =   120
         TabIndex        =   23
         Top             =   1080
         Width           =   840
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "Field to use:"
         Height          =   195
         Left            =   120
         TabIndex        =   22
         Top             =   720
         Width           =   855
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Layer to label:"
         Height          =   195
         Left            =   120
         TabIndex        =   21
         Top             =   360
         Width           =   990
      End
   End
   Begin MSComDlg.CommonDialog cdlOpen 
      Left            =   7800
      Top             =   8040
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame3 
      Caption         =   "Layer Functions"
      Height          =   975
      Left            =   1800
      TabIndex        =   14
      Top             =   600
      Width           =   4455
      Begin VB.CommandButton cmdClearLayers 
         Caption         =   "Clear All"
         Height          =   300
         Left            =   1440
         TabIndex        =   17
         Top             =   240
         Width           =   1200
      End
      Begin VB.CommandButton cmdRemoveLayer 
         Caption         =   "Remove Layer"
         Height          =   300
         Left            =   120
         TabIndex        =   16
         Top             =   600
         Width           =   1200
      End
      Begin VB.CommandButton cmdAddLayer 
         Caption         =   "Add Layer"
         Height          =   300
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Width           =   1200
      End
      Begin VB.Label Label2 
         Caption         =   "(Also add shapefile by dragging it to the map.)"
         Height          =   615
         Left            =   2760
         TabIndex        =   18
         Top             =   240
         Width           =   1455
         WordWrap        =   -1  'True
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Zoom Functions"
      Height          =   1095
      Left            =   1800
      TabIndex        =   2
      Top             =   1680
      Width           =   4455
      Begin VB.CommandButton cmdZoomToShape 
         Caption         =   "To Shape"
         Height          =   300
         Left            =   2760
         TabIndex        =   13
         Top             =   600
         Width           =   1200
      End
      Begin VB.CommandButton cmdZoomFull 
         Caption         =   "Full Extents"
         Height          =   300
         Left            =   120
         TabIndex        =   7
         Top             =   240
         Width           =   1200
      End
      Begin VB.CommandButton cmdZoomPrev 
         Caption         =   "Prev Extents"
         Height          =   300
         Left            =   120
         TabIndex        =   6
         Top             =   600
         Width           =   1200
      End
      Begin VB.CommandButton cmdZoomIn 
         Caption         =   "Zoom In"
         Height          =   300
         Left            =   1440
         TabIndex        =   5
         Top             =   240
         Width           =   1200
      End
      Begin VB.CommandButton cmdZoomOut 
         Caption         =   "Zoom Out"
         Height          =   300
         Left            =   1440
         TabIndex        =   4
         Top             =   600
         Width           =   1200
      End
      Begin VB.CommandButton cmdZoomToLayer 
         Caption         =   "To Layer"
         Height          =   300
         Left            =   2760
         TabIndex        =   3
         Top             =   240
         Width           =   1200
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Cursor Mode"
      Height          =   2295
      Left            =   120
      TabIndex        =   1
      Top             =   600
      Width           =   1455
      Begin VB.OptionButton optCursorMode 
         Caption         =   "None"
         Height          =   375
         Index           =   4
         Left            =   120
         TabIndex        =   12
         Top             =   1800
         Width           =   1200
      End
      Begin VB.OptionButton optCursorMode 
         Caption         =   "Select"
         Height          =   375
         Index           =   3
         Left            =   120
         TabIndex        =   11
         Top             =   1440
         Width           =   1200
      End
      Begin VB.OptionButton optCursorMode 
         Caption         =   "Pan"
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   10
         Top             =   1080
         Width           =   1200
      End
      Begin VB.OptionButton optCursorMode 
         Caption         =   "Zoom Out"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   9
         Top             =   720
         Width           =   1200
      End
      Begin VB.OptionButton optCursorMode 
         Caption         =   "Zoom In"
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   8
         Top             =   360
         Value           =   -1  'True
         Width           =   1200
      End
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "MapWinGIS Sample Project: Shapefile Viewing Functions"
      BeginProperty Font 
         Name            =   "Times New Roman"
         Size            =   14.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   -1  'True
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000080&
      Height          =   315
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   6735
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Sample VB6 Project Using MapWinGIS
'Dan Ames, Eric Wahlstrom
'August 29, 2003

Option Explicit

Private Sub btnAddImage_Click()
    Dim handle As Long
    Dim sf As MapWinGIS.Shapefile
    Dim image As New MapWinGIS.image
    
    If lvLegend.SelectedItem Is Nothing Then Exit Sub
    
    'get the shapefile back
    handle = lvLegend.SelectedItem.Tag
    Set sf = Map1.GetObject(handle)
    
    'set the image for this layer if it is a point shapefile
    If sf.ShapefileType = SHP_POINT Then
    
        Set image.Picture = btnAddImage.Picture
        image.UseTransparencyColor = True
        image.TransparencyColor = RGB(255, 255, 255)
        Set Map1.UDPointType(handle) = image
        Map1.ShapeLayerPointSize(handle) = 1
        Map1.ShapeLayerPointType(handle) = ptUserDefined
    Else
        MsgBox ("This layer is not a point shapefile")
    End If
   
End Sub

Private Sub btnClearDrawings_Click()
    'clear all of the drawings
    Map1.ClearDrawings
End Sub

Private Sub btnClearLabels_Click()
    Dim i As Long, handle As Long
    
    'clear all labels for each layer
    For i = 0 To Map1.NumLayers - 1
        handle = Map1.LayerHandle(i)
        Map1.ClearLabels handle
    Next
End Sub

Private Sub btnColorLayer_Click()
    Dim handle As Long, i As Long, fieldIndex As Long
    Dim colorScheme As New MapWinGIS.ShapefileColorScheme
    Dim sf As MapWinGIS.Shapefile
    Dim break As MapWinGIS.ShapefileColorBreak
     
     'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
    
    On Error GoTo Cancel
    'get the field index to color by
    fieldIndex = InputBox("Enter the Field index to color by.", "Field Index", 0)
            
    'create a coloring scheme on the field index value
    handle = lvLegend.SelectedItem.Tag
    Set sf = Map1.GetObject(handle)
    
    'find the max and min values for that field
    Dim min As Double, max As Double
    min = sf.CellValue(0, 0)
    max = sf.CellValue(0, 0)
    For i = 0 To sf.NumShapes - 1
        If (sf.CellValue(fieldIndex, i) < min) Then
            min = sf.CellValue(fieldIndex, i)
        End If
        
        If (sf.CellValue(fieldIndex, i) > max) Then
            max = sf.CellValue(fieldIndex, i)
        End If
    Next
    
    With colorScheme
       .LayerHandle = handle
       
       'the field value to color by
        colorScheme.fieldIndex = fieldIndex
        
        'create a new break object
        Set break = New MapWinGIS.ShapefileColorBreak
        break.Caption = "test"
        break.StartColor = RGB(255, 0, 0)
        break.EndColor = RGB(0, 0, 255)
        break.StartValue = min
        break.EndValue = max
                
        'add the break
        colorScheme.Add break
    End With
    
    'apply the coloring scheme for this layer
    Map1.ApplyLegendColors colorScheme

Cancel:
End Sub

Private Sub btnDrawPoint_Click()
    Dim hDraw As Long

    Dim xProjCenter As Double, yProjCenter As Double
    Dim xScreenCenter As Double, yScreenCenter As Double
    Dim extents As MapWinGIS.extents
    Set extents = Map1.extents
     
    'find the center of the view
    xProjCenter = extents.xMin + ((extents.xMax - extents.xMin) / 2)
    yProjCenter = extents.yMin + ((extents.yMax - extents.yMin) / 2)
    
    'create a new drawing surface
    If (SpatiallyReferenced.Value = True) Then
        hDraw = Map1.NewDrawing(dlSpatiallyReferencedList)
        Map1.DrawPoint xProjCenter, yProjCenter, 50, RGB(255, 0, 0)
    Else
        Map1.ProjToPixel xProjCenter, yProjCenter, xScreenCenter, yScreenCenter
        hDraw = Map1.NewDrawing(dlScreenReferencedList)
        Map1.DrawPoint xScreenCenter, yScreenCenter, 50, RGB(255, 0, 0)
    End If
   
End Sub

Private Sub btnDrawLine_Click()
    Dim hDraw As Long

    Dim yProjCenter As Double, xProjMin As Double, xProjMax As Double
    Dim yScreenCenter As Double, xScreenMin As Double, xScreenMax As Double
    Dim extents As MapWinGIS.extents
    Set extents = Map1.extents
     
    'find the center of the view
    yProjCenter = extents.yMin + ((extents.yMax - extents.yMin) / 2)
    xProjMin = extents.xMin
    xProjMax = extents.xMax
    
    'create a new drawing surface
    If (SpatiallyReferenced.Value = True) Then
        hDraw = Map1.NewDrawing(dlSpatiallyReferencedList)
        Map1.DrawLine xProjMin, yProjCenter, xProjMax, yProjCenter, 5, RGB(0, 255, 0)
    Else
        Map1.ProjToPixel xProjMin, yProjCenter, xScreenMin, yScreenCenter
        Map1.ProjToPixel xProjMax, yProjCenter, xScreenMax, yScreenCenter
        hDraw = Map1.NewDrawing(dlScreenReferencedList)
        Map1.DrawLine xScreenMin, yScreenCenter, xScreenMax, yScreenCenter, 5, RGB(0, 255, 0)
    End If
End Sub

Private Sub lvLegend_ItemCheck(ByVal Item As MSComctlLib.ListItem)
    Dim handle As Long
    Dim i As Long
    
    'cycle through all of the layers to set visibility
    For i = 1 To lvLegend.ListItems.Count
    
        'get the handle of the layer
        handle = lvLegend.ListItems(i).Tag
       
        If (lvLegend.ListItems(i).Checked = True) Then
            Map1.LayerVisible(handle) = True
        Else
            Map1.LayerVisible(handle) = False
        End If
    Next
    
End Sub

Private Sub btnMoveLayerDown_Click()
    Dim handle As Long
    Dim name As String
    Dim index As Long
    Dim Item As ListItem
    Dim retval As Boolean
    Dim visible As Boolean
    
    'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
           
    handle = lvLegend.SelectedItem.Tag
    index = lvLegend.SelectedItem.index
    name = lvLegend.SelectedItem.text
    visible = lvLegend.SelectedItem.Checked
    
    'move the selected layer down
    If index < lvLegend.ListItems.Count Then
        retval = Map1.MoveLayerDown(Map1.LayerPosition(handle))
              
        lvLegend.ListItems.Remove index
        Set Item = lvLegend.ListItems.Add(index + 1, , name)
        Item.ListSubItems.Add , , handle
        Item.Tag = handle
        Item.Checked = visible
    End If
End Sub

Private Sub btnMoveLayerUp_Click()
    Dim handle As Long
    Dim name As String
    Dim index As Long
    Dim Item As ListItem
    Dim retval As Boolean
    Dim visible As Boolean
    
    'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
            
    handle = lvLegend.SelectedItem.Tag
    index = lvLegend.SelectedItem.index
    name = lvLegend.SelectedItem.text
    visible = lvLegend.SelectedItem.Checked
    
    'move the selected layer up
    If (index > 1) Then
        retval = Map1.MoveLayerUp(Map1.LayerPosition(handle))
             
        lvLegend.ListItems.Remove index
        Set Item = lvLegend.ListItems.Add(index - 1, , name)
        Item.ListSubItems.Add , , handle
        Item.Tag = handle
        Item.Checked = visible
    End If
End Sub

Private Sub btnZoomToSelLayer_Click()
    Dim handle As Long
    If (Not lvLegend.SelectedItem.Tag Is Nothing) Then
        handle = lvLegend.SelectedItem.Tag
        Map1.ZoomToLayer handle
    End If
End Sub

Private Sub cbFieldToUse_DropDown()
    'clear all the items in the combo box
     cbFieldToUse.Clear
    
    Dim i As Long, handle As Long
    
    'add all the fields for this layer to the combo box
    If cbLayerToLabel.ListCount > 0 And cbLayerToLabel.text <> "" Then
        handle = Split(cbLayerToLabel.text, " - ")(0)
        
        Dim sf As MapWinGIS.Shapefile
        Set sf = Map1.GetObject(handle)
        
        For i = 0 To sf.NumFields - 1
           cbFieldToUse.AddItem (i & " - " & sf.Field(i).name)
        Next
       
    End If
End Sub

Private Sub cbLayerToLabel_DropDown()
    'clear all the items in the combo box
    cbLayerToLabel.Clear
    
    'add all the layers of the map to the combo box
    Dim i As Long, handle As Long, layerName As String
    For i = 0 To Map1.NumLayers - 1
        handle = Map1.LayerHandle(i)
        layerName = Map1.layerName(handle)
        cbLayerToLabel.AddItem (handle & " - " & layerName)
    Next
End Sub

Private Sub cmdAddLayer_Click()
    Dim Filename As String
    Dim FileSys As New Scripting.FileSystemObject
    Dim sf As New MapWinGIS.Shapefile
    cdlOpen.CancelError = True
    On Error GoTo ERRORHANDLER
        cdlOpen.Filter = sf.CdlgFilter 'this gives you a filter for shapefiles
        cdlOpen.ShowOpen
        Filename = cdlOpen.Filename
        If FileSys.FileExists(Filename) = False Then
            MsgBox "The file, " & Filename & " was not found.", vbCritical
            Exit Sub
        Else
            AddShapefile Filename
        End If
    Exit Sub
ERRORHANDLER:
    'dialog was cancelled
End Sub

Private Sub cmdClearLayers_Click()
    On Error Resume Next
    Map1.RemoveAllLayers
    
    'remove all layers in the legend
    lvLegend.ListItems.Clear
End Sub

Private Sub cmdFontColor_Click()
    Dim newColor As Long
    cdlOpen.CancelError = True
    On Error GoTo ERRORHANDLER
    cdlOpen.ShowColor
    On Error GoTo 0
    newColor = cdlOpen.Color
    cmdFontColor.BackColor = newColor
ERRORHANDLER:
    'cancel was clicked
End Sub

Private Sub cmdLabel_Click()
    Dim sf As MapWinGIS.Shapefile
    Dim handle As Long
    Dim fieldIndex As Long
    Dim text As String
    Dim i As Long
  
    If (cbLayerToLabel.text = "" Or cbFieldToUse = "") Then Exit Sub
        
    On Error Resume Next
    
    'get the layer handle
    handle = Split(cbLayerToLabel, " - ")(0)
    
    'get the field index
    fieldIndex = Split(cbFieldToUse, " - ")(0)
    
    Set sf = Map1.GetObject(handle)
    For i = 0 To sf.NumShapes - 1
        text = sf.CellValue(fieldIndex, i)
        Map1.AddLabel handle, text, cmdFontColor.BackColor, sf.Shape(i).extents.xMin, sf.Shape(i).extents.yMin, hjCenter
    Next i
End Sub

Private Sub cmdRemoveLayer_Click()
    Dim handle As Long
    
    'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
    
    handle = lvLegend.SelectedItem.Tag
    
    'remove this layer from the map
    Map1.RemoveLayer (handle)
    
    'remove this layer from the legend
    Dim i As Long
    For i = 1 To lvLegend.ListItems.Count
        If (lvLegend.ListItems(i).Tag = handle) Then
            lvLegend.ListItems.Remove (i)
        End If
    Next
End Sub

Private Sub Form_Load()
    Map1.CursorMode = cmZoomIn
    optCursorMode(0).Value = True
    Map1.SendSelectBoxFinal = True
    Map1.SendMouseUp = True

    'add the header to the list view
    lvLegend.ColumnHeaders.Add , , "Name"
    lvLegend.ColumnHeaders.Add , , "Handle"
End Sub

Private Sub cmdZoomFull_Click()
    Map1.ZoomToMaxExtents
End Sub

Private Sub cmdZoomIn_Click()
    Map1.ZoomIn (0.3)
End Sub

Private Sub cmdZoomOut_Click()
    Map1.ZoomOut (0.3)
End Sub

Private Sub cmdZoomPrev_Click()
    Map1.ZoomToPrev
End Sub

Private Sub cmdZoomToLayer_Click()
    Dim handle As Long
    On Error GoTo ERRORHANDLER
    
    'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
    
    handle = lvLegend.SelectedItem.Tag
    Map1.ZoomToLayer (handle)
ERRORHANDLER:
    'cancel was clicked
End Sub

Private Sub cmdZoomToShape_Click()
    Dim shpIndex As Integer
    Dim handle As Long
    
     'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
    
    On Error GoTo ERRORHANDLER
    handle = lvLegend.SelectedItem.Tag
    shpIndex = InputBox("Enter the shape index to zoom to.", "Zoom to shape", 0)
    Map1.ZoomToShape handle, shpIndex
ERRORHANDLER:
    'cancel was clicked
End Sub


Private Sub lvLegend_ItemClick(ByVal Item As MSComctlLib.ListItem)
    Dim i As Long, handle As Long
    
    'cycle through all the layers and unselect any selected shapes
    For i = 0 To Map1.NumLayers - 1
       handle = Map1.LayerHandle(i)
       Map1.ShapeLayerLineColor(handle) = Map1.ShapeLayerLineColor(handle)
       Map1.ShapeLayerFillColor(handle) = Map1.ShapeLayerFillColor(handle)
    Next
End Sub

Private Sub Map1_FileDropped(ByVal Filename As String)
    'If a shapefile is dropped on the map then load it
    AddShapefile (Filename)
End Sub

Private Sub AddShapefile(Filename As String)
    Dim FileSys As New Scripting.FileSystemObject
    Dim sf As MapWinGIS.Shapefile, handle As Long
    Dim ErrMsg As String
    Dim Item As ListItem
    
    If LCase(Right(Filename, 3)) = "shp" Then
        Set sf = New MapWinGIS.Shapefile
        If sf.Open(Filename) = False Then
            ErrMsg = sf.ErrorMsg(sf.LastErrorCode)
            MsgBox "The file, " & Filename & " failed to open for the following reason:" & vbCrLf & ErrMsg, vbCritical
            Exit Sub
        Else
            handle = Map1.AddLayer(sf, True)
            
            'exit if this is not a vaild layer handle
            If handle < 0 Then Exit Sub
            
            'set the name of this layer
            Map1.layerName(handle) = FileSys.GetFileName(sf.Filename)
            
            'add the layer to the legend
            Set Item = lvLegend.ListItems.Add(1, , Map1.layerName(handle))
            Item.ListSubItems.Add , , handle
            Item.Tag = handle
            Item.Checked = True
                                   
            'set random colors for the fill color and outline color
            Map1.ShapeLayerFillColor(handle) = RGB((255 - 1) * Rnd, (255 - 1) * Rnd, (255 - 1) * Rnd)
            Map1.ShapeLayerLineColor(handle) = RGB((255 - 1) * Rnd, (255 - 1) * Rnd, (255 - 1) * Rnd)
        End If
    Else
        MsgBox "The file, " & Filename & " is not a shapefile."
    End If
End Sub

Private Sub Map1_MouseUp(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Long, ByVal y As Long)
    'Example of selection using a mouse click
    'For this event to be called, you must have set the property:     Map1.SendMouseUp = True
    Dim sf As MapWinGIS.Shapefile
    Dim ex As New MapWinGIS.extents
    Dim xProjected As Double, yProjected As Double
    Dim Result As Boolean
    Dim ShapeIDs As Variant '() As Long
    Dim handle As Long
    Dim i As Long
    
    On Error GoTo Cancel
    
    'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
    handle = lvLegend.SelectedItem.Tag
    
    'exit if were not in selection mode
    If Map1.CursorMode <> cmSelection Then Exit Sub
    
    If Map1.NumLayers > 0 Then
        'get the shapefile object
        Set sf = Map1.GetObject(handle)
        
        'test to see if any shapes for this area lie withing the seleted bounds
        Map1.PixelToProj x, y, xProjected, yProjected
        ex.SetBounds xProjected, yProjected, 0, xProjected, yProjected, 0
        Result = sf.SelectShapes(ex, 0, INTERSECTION, ShapeIDs)
        
        'if we found some selected shapes then mark as selected
        If Result = True Then
            Map1.ShapeLayerFillColor(handle) = Map1.ShapeLayerFillColor(handle) 'reset the color of the shapes
            Map1.ShapeLayerLineColor(handle) = Map1.ShapeLayerLineColor(handle)
            For i = 0 To UBound(ShapeIDs)
                Map1.ShapeFillColor(handle, ShapeIDs(i)) = vbYellow
                Map1.ShapeLineColor(handle, ShapeIDs(i)) = vbRed
            Next i
        Else
            'reset as unseleted - reset the color of the shapes
            Map1.ShapeLayerFillColor(handle) = Map1.ShapeLayerFillColor(handle)
            Map1.ShapeLayerLineColor(handle) = Map1.ShapeLayerLineColor(handle)
        End If
    End If
    
Cancel:

End Sub

Private Sub Map1_SelectBoxFinal(ByVal Left As Long, ByVal Right As Long, ByVal Bottom As Long, ByVal Top As Long)
    'Example of selection using a bounding box
    'For this event to be called, you must have set the property:     Map1.SendSelectBoxFinal = True
    'Find all of the shapes in layer 0 that are selected by this box
    Dim sf As MapWinGIS.Shapefile
    Dim ex As New MapWinGIS.extents
    Dim xMin As Double, yMin As Double, xMax As Double, yMax As Double
    Dim Result As Boolean
    Dim ShapeIDs As Variant '() As Long
    Dim handle As Long
    Dim i As Long
    
     'check to make sure the selected item is not nothing
    If (lvLegend.SelectedItem Is Nothing) Then Exit Sub
    handle = lvLegend.SelectedItem.Tag
        
    If Map1.CursorMode <> cmSelection Then Exit Sub
    If Map1.NumLayers > 0 Then
        Set sf = Map1.GetObject(handle)
        Map1.PixelToProj Left, Bottom, xMin, yMin
        Map1.PixelToProj Right, Top, xMax, yMax
        ex.SetBounds xMin, yMin, 0, xMax, yMax, 0
        Result = sf.SelectShapes(ex, 0, INTERSECTION, ShapeIDs)
        If Result = True Then
            Map1.ShapeLayerFillColor(handle) = Map1.ShapeLayerFillColor(handle) 'reset the color of the shapes
            Map1.ShapeLayerLineColor(handle) = Map1.ShapeLayerLineColor(handle)
            For i = 0 To UBound(ShapeIDs)
                Map1.ShapeFillColor(handle, ShapeIDs(i)) = vbYellow
                Map1.ShapeLineColor(handle, ShapeIDs(i)) = vbRed
            Next i
        End If
    End If
End Sub

Private Sub optCursorMode_Click(index As Integer)
    Select Case index
    Case 0
        Map1.CursorMode = cmZoomIn
    Case 1
        Map1.CursorMode = cmZoomOut
    Case 2
        Map1.CursorMode = cmPan
    Case 3
        Map1.CursorMode = cmSelection
    Case 4
        Map1.CursorMode = cmNone
    End Select
End Sub

