// Presents a dialog box containing all of the script engines that
// implement the standard IActiveScriptParse object. We present this dialog
// to the user when we can't figure out which engine to use based
// upon the extension of the script's filename. (ie, No engine has
// set up an association with a particular file extension). In this
// case, we let the user choose the engine to use for a given script.

#include <windows.h>
#include <tchar.h>
#include <objbase.h>
#include <comcat.h>
#include <activscp.h>
#include "Resource.h"
#include "Extern.h"





/************************ engineDlgProc() **********************
 * The message handler for the "Choose engine" dialog box.
 */

static BOOL CALLBACK engineDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	register HWND	hwndChild;

	switch (uMsg)
	{
		case WM_COMMAND:
		{
			// There is only the one listbox, so if we get a WM_COMMAND, it must be
			// the listbox. Hence, we'll skip checking the LOWORD of wParam for the
			// ID of the listbox.

			// Doubleclick in the listbox? If not, ignore this
			if(HIWORD(wParam) != LBN_DBLCLK)
out:			return(0);

			// Get the engines listbox
			hwndChild = (HWND)lParam;

			// Get the selected engine
			if (LB_ERR != (lParam = SendMessage(hwndChild, LB_GETCURSEL, 0, 0)))
			{
				GUID	*guid;

				// Copy GUID to caller's GUID buffer
				if (!(guid = (GUID *)SendMessage(hwndChild, LB_GETITEMDATA, (WPARAM)lParam, 0))) goto out;
				CopyMemory((void *)GetWindowLong(hwnd, DWL_USER), guid, sizeof(GUID));
			}
		}

		// Fall through to close the Dialog

		// ================== User wants to close window ====================
		case WM_CLOSE:
		{
			register DWORD		i;

			// Delete all GlobalAlloc'ed memory
			hwndChild = GetDlgItem(hwnd, IDC_ENGINELIST);
			i = SendMessage(hwndChild, LB_GETCOUNT, 0, 0);
			for (wParam = 0; wParam < i; wParam++)
			{
				GUID	*guid;

				if ((guid = (GUID *)SendMessage(hwndChild, LB_GETITEMDATA, (WPARAM)wParam, 0))) GlobalFree(guid);
			}

			// Close the Dialog
			EndDialog(hwnd, uMsg == WM_CLOSE);
			break;
		}

		// ======================= Dialog Initialization =====================
		case WM_INITDIALOG:
		{
			// Save the GUID * in the dialog's DWL_USER field
			SetWindowLong(hwnd, DWL_USER, lParam);

			{
			HICON	icon;

			// Load/set icon for System menu on the window. I put my icon
			// in this executable's resources. Note that windows frees this
			// when my window is closed.
			if ((icon = LoadIcon(InstanceHandle,MAKEINTRESOURCE(IDI_MAIN_ICON))))
				SetClassLong(hwnd, GCL_HICON, (LONG)icon);
			}

			{
			ICatInformation		*catManager;
			register HRESULT	hr;

			// Get the Engines listbox
			hwndChild = GetDlgItem(hwnd, IDC_ENGINELIST);

			// Get the component category manager for this machine
			if (!(hr = CoCreateInstance(&CLSID_StdComponentCategoriesMgr, 0, CLSCTX_ALL, &IID_ICatInformation, (void **)&catManager)))
			{
				CATID		rgcatidImpl[1];
				IEnumCLSID	*parseableEngines;

				// Get the list of parseable script engines
				rgcatidImpl[0] = CATID_ActiveScriptParse;
				if (!(hr = catManager->lpVtbl->EnumClassesOfCategories(catManager, 1, rgcatidImpl, 0, 0, &parseableEngines)))
				{
					// Add the ProgIDs to the listbox
					CLSID	rgclsid[1];
					ULONG	cActual;
					do
					{
						cActual = 0;
						parseableEngines->lpVtbl->Next(parseableEngines, 1, &rgclsid[0], &cActual);
						if (cActual)
						{
							OLECHAR		*pwszProgID;

							if (!ProgIDFromCLSID(&rgclsid[0], &pwszProgID))
							{
#ifdef UNICODE
								hr = SendMessage(hwndChild, LB_ADDSTRING, 0, (LPARAM)pwszProgID);
#else
								TCHAR	buffer[180];
								WideCharToMultiByte(CP_ACP, 0, pwszProgID, -1, &buffer[0], sizeof(buffer), 0, 0);
								hr = SendMessage(hwndChild, LB_ADDSTRING, 0, (LPARAM)&buffer[0]);
#endif
								CoTaskMemFree(pwszProgID);

								// Save the GUID as the itemdata
								if (hr != (HRESULT)-1)
								{
									GUID	*guid;

									if ((guid = (GUID *)GlobalAlloc(GMEM_FIXED, sizeof(GUID))))
									{
										CopyMemory(guid, &rgclsid[0], sizeof(GUID));
										SendMessage(hwndChild, LB_SETITEMDATA, (WPARAM)hr, (LPARAM)guid);
									}
									else
										display_sys_error(0);
								}
							}
						}

					} while (cActual);

					parseableEngines->lpVtbl->Release(parseableEngines);
				}
				else
					display_COM_error("Can't get parseable script engine category", hr);

				catManager->lpVtbl->Release(catManager);
			}
			else
				display_COM_error("Can't load category manager", hr);
			}

			// Let Windows set control focus
			return(1);
		}
	}

	return(0);
}





/************************* chooseEngineDlg() ***********************
 * Presents the "Choose engine" dialog box to the user, to get his
 * choice of script engine.
 */

int chooseEngineDlg(GUID *guid)
{
	int		result;

	// Create and operate the dialog
	if ((result = DialogBoxParam(InstanceHandle, MAKEINTRESOURCE(IDD_ENGINELIST), MainWindow, engineDlgProc, (LPARAM)guid)) == -1)
		display_sys_error(0);
	return(result);
}
