// Implements displaying text to our MainWindow's IDC_TRACE EDIT control
// just like it was a console window.

#include <windows.h>
#include <objbase.h>
#include <activscp.h>
#include <tchar.h>
#include "resource.h"
#include "tracewin.h"
#include "extern.h"


static const TCHAR		Separator[] = _T(" : ");
static const TCHAR		Comma[] = _T(", ");
static const TCHAR		NoStr[] = _T("$NOSTR$");
static const TCHAR		Opening[] = _T(" : [");
static const TCHAR		Closing[] = _T("]\r\n");
static const TCHAR		ChangeFrom[] = _T("Changing State from ");
static const TCHAR		ChangeTo[] = _T(" to ");
static const TCHAR		EngineStates[] = {"UNINITIALIZED\0\
STARTED\0\
CONNECTED\0\
DISCONNECTED\0\
CLOSED\0\
INITIALIZED\0\
UNKNOWN\0"};
static const TCHAR		LongValueStr[] = _T("%s : [%ld]\r\n");





static void indent(HWND edit, LPTSTR ptr)
{
	register DWORD	i, indent;

	// Get current value of indent
	indent = GetWindowLong(edit, GWL_USERDATA);

	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

	if ((i = indent))
	{
		while (i--)
		{
			lstrcpy(ptr, "  ");
			ptr += (2 * sizeof(TCHAR));
		}

		*ptr = 0;

		SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)ptr);
		SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);
	}
}





static void newline(HWND edit)
{
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&Closing[1]);
	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);
}





void traceEnterFunc(LPCTSTR pszfuncName)
{
	TCHAR			buffer[120];
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	indent(edit, &buffer[0]);
	newline(edit);
	indent(edit, &buffer[0]);
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)pszfuncName);
	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);
	newline(edit);

	// Increment indent
	SetWindowLong(edit, GWL_USERDATA, GetWindowLong(edit, GWL_USERDATA) + 1);
}





void traceShowArgs(LPCTSTR pszMsg, DWORD cArgs, VARIANT *rgpvarArgs)
{
	DWORD		i;
	TCHAR		buffer[256];
	VARIANTARG	varDest;
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	indent(edit, &buffer[0]);
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)pszMsg);
	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&Separator[0]);
	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

	for (i = 0; i < cArgs; i++)
	{
		VariantInit(&varDest);
		if (!VariantChangeType(&varDest, &(rgpvarArgs[i]), 0, VT_BSTR))
		{
			WideCharToMultiByte(CP_ACP, 0, varDest.bstrVal, -1, &buffer[0], sizeof(buffer), 0, 0);
			VariantClear(&varDest);
			SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&buffer[0]);
		}
		else
			SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&NoStr[0]);
		SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

		if (i+1 != cArgs)
		{
			SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&Comma[0]);
			SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);
		}
	}

	newline(edit);
}





void traceShowState(DWORD dwstFrom, DWORD dwstTo)
{
	TCHAR	buffer[256];
	LPTSTR	ptr;
	LPCTSTR	state;
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	indent(edit, &buffer[0]);

	ptr = &buffer[0];
	lstrcpy(ptr, &ChangeFrom[0]);
	ptr += lstrlen(ptr);

	state = &EngineStates[0];
	while (*state && dwstFrom--) state += (lstrlen(state) + 1);
	lstrcpy(ptr, state);
	ptr += lstrlen(ptr);

	lstrcpy(ptr, &ChangeTo[0]);
	ptr += lstrlen(ptr);		

	state = &EngineStates[0];
	while (*state && dwstTo--) state += (lstrlen(state) + 1);
	lstrcpy(ptr, state);

	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&buffer[0]);
	newline(edit);
}





void traceShowInt(LPCTSTR pszMsg, DWORD dwParam)
{
	TCHAR			buffer[256];
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	indent(edit, &buffer[0]);
	wsprintf(&buffer[0], &LongValueStr[0], pszMsg, dwParam);
	SendMessage(edit, WM_SETTEXT, 0, (LPARAM)&buffer[0]);
}





void traceShowStr(LPCTSTR pszMsg, LPCOLESTR pwzParam)
{
	TCHAR			buffer[256];
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	indent(edit, &buffer[0]);
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)pszMsg);
	SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

	if (pwzParam)
	{
		SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&Opening[0]);
		SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

#ifndef UNICODE
		WideCharToMultiByte(CP_ACP, 0, pwzParam, -1, buffer, sizeof(buffer), 0, 0);
		SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&buffer[0]);
#else
		SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)pwzParam);
#endif
		SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);

		SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&Closing[0]);
	}
}





void traceShowWStr(LPCOLESTR pwzParam, DWORD nl)
{
	TCHAR			buffer[256];
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	indent(edit, &buffer[0]);

#ifndef UNICODE
	WideCharToMultiByte(CP_ACP, 0, pwzParam, -1, &buffer[0], sizeof(buffer), 0, 0);
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)&buffer[0]);
#else
	SendMessage(edit, EM_REPLACESEL, 0, (LPARAM)pwzParam);
#endif

	if (nl)
	{
		SendMessage(edit, EM_SETSEL, (WPARAM)-1, -1);
		newline(edit);
	}
}





void traceLeaveFunc(void)
{
	register HWND	edit;

	edit = GetDlgItem(MainWindow, IDC_TRACE);
	SetWindowLong(edit, GWL_USERDATA, GetWindowLong(edit, GWL_USERDATA) - 1);
}
