// AddIn.cpp

#include "stdafx.h"
#include "AddIn.h"
#include <oledlg.h>
#include "WtsApi32.h"

#pragma comment (lib,"WtsApi32.Lib")


CString IntToStr(int i){
	CString s; s.Format("%d",i);
	return s;
}

/////////////////////////////////////////////////////////////////////////////
// CAddIn
/////////////////////////////////////////////////////////////////////////////

BOOL CAddIn::LoadProperties()
{  
    return TRUE;
}

void CAddIn::SaveProperties()
{
}
  
  // This function is useful in ILanguageExtender implementation
CString CAddIn::TermString(UINT uiResID,long nAlias)
{
  CString cs;
  cs.LoadString(uiResID);
  int iInd = cs.Find(',');
  if (iInd == -1)
    return cs;
  switch(nAlias)
    { case 0: // First language
        return cs.Left(iInd);
      case 1: // Second language
        return cs.Right(cs.GetLength()-iInd-1);
      default:
        return CString("");
    };
}

  /* 
     These two methods is convenient way to access function 
     parameters from SAFEARRAY vector of variants
  */
VARIANT CAddIn::GetNParam(SAFEARRAY *pArray,long lIndex)
{
  ASSERT(pArray);
  ASSERT(pArray->fFeatures | FADF_VARIANT);
  
  VARIANT vt;
  HRESULT hRes = SafeArrayGetElement(pArray,&lIndex,&vt);
  ASSERT(hRes == S_OK);

  return vt;
}

void CAddIn::PutNParam(SAFEARRAY *pArray,long lIndex,VARIANT vt)
{
  ASSERT(pArray);
  ASSERT(pArray->fFeatures | FADF_VARIANT);
  
  HRESULT hRes = SafeArrayPutElement(pArray,&lIndex,&vt);
  ASSERT(hRes == S_OK);
}



/////////////////////////////////////////////////////////////////////////////
// IInitDone

STDMETHODIMP CAddIn::Init(IDispatch *pConnection)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    
     m_iErrorLog = NULL;
     pConnection->QueryInterface(IID_IErrorLog,(void **)&m_iErrorLog);
//     
//     CString csProfileName = "AddIn Profile Name";
//     m_iProfile = NULL;
//     pConnection->QueryInterface(IID_IPropertyProfile,(void **)&m_iProfile);
//     m_iProfile->RegisterProfileAs(csProfileName.AllocSysString());
// 
//     m_iStatusLine = NULL;
//     pConnection->QueryInterface(IID_IStatusLine,(void **)&m_iStatusLine);
// 
//     m_iAsyncEvent = NULL;
//     pConnection->QueryInterface(IID_IAsyncEvent,(void **)&m_iAsyncEvent);

     if (LoadProperties() == FALSE) return E_FAIL;

	return S_OK;
}

STDMETHODIMP CAddIn::Done()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    SaveProperties();

//     if (m_iStatusLine) m_iStatusLine->Release();
//     if (m_iProfile) m_iProfile->Release();
     if (m_iErrorLog) m_iErrorLog->Release();
//     if (m_iAsyncEvent) m_iAsyncEvent->Release();
    
	return S_OK;
}

STDMETHODIMP CAddIn::GetInfo(SAFEARRAY **pInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

      // Component should put supported component technology version 
      // in VARIANT at index 0     
    long lInd = 0;
    VARIANT varVersion;
    V_VT(&varVersion) = VT_I4;
      // This component supports 1.0 version
    V_I4(&varVersion) = 1000;
    SafeArrayPutElement(*pInfo,&lInd,&varVersion);
    
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// ILanguageExtender

STDMETHODIMP CAddIn::RegisterExtensionAs(BSTR *bstrExtensionName)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// You may delete next lines and add your own implementation code here

      // Name of extension should be changed avoiding conflicts 
    CString csExtenderName = "WTSApi";
    *bstrExtensionName = csExtenderName.AllocSysString();

	return NULL;
}

STDMETHODIMP CAddIn::GetNProps(long *plProps)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// You may delete next lines and add your own implementation code here

    *plProps = LastProp;

	return S_OK;
}

STDMETHODIMP CAddIn::FindProp(BSTR bstrPropName,long *plPropNum)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    // TODO: Add your implementation code here

	*plPropNum = -1;

    /* 
        Assign proper value to plPropNum if property named bstrPropName is found
    */

    if (*plPropNum == -1) return S_FALSE;

	return S_OK;
}

STDMETHODIMP CAddIn::GetPropName(long lPropNum,long lPropAlias,BSTR *pbstrPropName)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
 
     CString csPropName = "";     
//     switch(lPropNum)
//       { 
//         /* 
//           Differentiate cases here:
//             case Prop1: ...
//             case Prop2: ...
//              ...
//         */
//         default:
//           *pbstrPropName = csPropName.AllocSysString();
//           return S_FALSE;
//       }
//     
     *pbstrPropName = csPropName.AllocSysString();

	return S_OK;
}

STDMETHODIMP CAddIn::GetPropVal(long lPropNum,VARIANT *pvarPropVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    VariantInit(pvarPropVal);
//     switch(lPropNum)
//       { 
//         /* 
//           Differentiate cases here:
//             case Prop1: ...
//             case Prop2: ...
//              ...
//         */
//         default:
//           return S_FALSE;
//       }

	return S_OK;
}

STDMETHODIMP CAddIn::SetPropVal(long lPropNum,VARIANT *pvarPropVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

//     switch(lPropNum)
//       { 
//         /* 
//           Differentiate cases here:
//             case Prop1: ...
//             case Prop2: ...
//              ...
//         */
//         default:
//           return S_FALSE;
//       }

	return S_OK;
}

STDMETHODIMP CAddIn::IsPropReadable(long lPropNum,BOOL *pboolPropRead)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

//     switch(lPropNum)
//       { 
//         /* 
//           Differentiate cases here:
//             case Prop1: ...
//             case Prop2: ...
//              ...
//         */
//         default:
//           return S_FALSE;
//       }

	return S_OK;
}

STDMETHODIMP CAddIn::IsPropWritable(long lPropNum,BOOL *pboolPropWrite)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

//     switch(lPropNum)
//       { 
//         /* 
//           Differentiate cases here:
//             case Prop1: ...
//             case Prop2: ...
//              ...
//         */
//         default:
//           return S_FALSE;
//       }

    return S_OK;
}

STDMETHODIMP CAddIn::GetNMethods(long *plMethods)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		
	*plMethods = LastMethod;
	
	return S_OK;
}

STDMETHODIMP CAddIn::FindMethod(BSTR bstrMethodName,long *plMethodNum)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    USES_CONVERSION;

	*plMethodNum = -1;
	CString csPropName = OLE2T(bstrMethodName);
    if ((TermString(IDS_TERM_GETSESSIONINFO,0)==csPropName) || ((TermString(IDS_TERM_GETSESSIONINFO,1)==csPropName))) *plMethodNum = 0;


    if (*plMethodNum == -1) return S_FALSE;

	return S_OK;
}

STDMETHODIMP CAddIn::GetMethodName(long lMethodNum,long lMethodAlias,BSTR *pbstrMethodName)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	CString csMethodName = "";     
    switch(lMethodNum){ 
	case methGetSessionInfo:
		csMethodName = TermString(IDS_TERM_GETSESSIONINFO,lMethodAlias);
		break;

	default:
		*pbstrMethodName = csMethodName.AllocSysString();
		return S_FALSE;
	}
    
    *pbstrMethodName = csMethodName.AllocSysString();

	return S_OK;
}

STDMETHODIMP CAddIn::GetNParams(long lMethodNum,long *plParams)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		
	*plParams = 0;
	switch(lMethodNum){ 
		case methGetSessionInfo:
			*plParams = 1;
			break;
		default:
			return S_FALSE;
	}
    
	return S_OK;
}

STDMETHODIMP CAddIn::GetParamDefValue(long lMethodNum,long lParamNum,VARIANT *pvarParamDefValue)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    VariantInit(pvarParamDefValue);
//     switch(lMethodNum)
//       { 
//         /* 
//           Differentiate cases here:
//             case Method1: ...
//             case Method2: ...
//              ...
//         */
//         default:
//           return S_FALSE;
//       }

	return S_OK;
}

STDMETHODIMP CAddIn::HasRetVal(long lMethodNum,BOOL *pboolRetValue)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	switch(lMethodNum){
		case methGetSessionInfo:
			*pboolRetValue = TRUE;
			break;
		
        default:
			return S_FALSE;
	}

	return S_OK;
}


STDMETHODIMP CAddIn::CallAsProc(long lMethodNum,SAFEARRAY **paParams)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	
// 	switch(lMethodNum){
// 		case 0:
// 		break;
// 
// 	default:
// 		return S_FALSE;
// 	}
    
	return S_OK;
}

void CAddIn::ErrorMessage(CString msg, AddInErrors err){
	EXCEPINFO ei;
	ei.wCode = err;
	ei.bstrSource = L"WTSApi";
	ei.bstrDescription = msg.AllocSysString();
	m_iErrorLog->AddError(NULL,&ei);
}

STDMETHODIMP CAddIn::CallAsFunc(long lMethodNum,VARIANT* pvarRetValue,SAFEARRAY **paParams)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	USES_CONVERSION;
	switch(lMethodNum){ 
		case methGetSessionInfo:{
			int iParam = V_INT(&GetNParam(*paParams,0));

			if ((iParam<0) || (iParam>16))	ErrorMessage(" .   0 - 16.");
			CString strRet;

			LPTSTR pData = NULL;
			DWORD cbReturned = 0;
			if (WTSQuerySessionInformation(WTS_CURRENT_SERVER_HANDLE,WTS_CURRENT_SESSION,(WTS_INFO_CLASS)iParam,&pData, &cbReturned)){
				switch (iParam){
					case WTSInitialProgram:
					case WTSApplicationName:
					case WTSWorkingDirectory:
					case WTSUserName:
					case WTSWinStationName:
					case WTSDomainName:
					case WTSClientName:
					case WTSClientDirectory:
						strRet.Format("%s",pData);
						break;

					case WTSOEMId:
						strRet.Format("%d",0) ; //not used
						break;

					case WTSSessionId:
					case WTSClientBuildNumber:
					case WTSClientHardwareId:
						strRet.Format("%d",*(ULONG*)pData);
						break;

					case WTSClientProductId:
					case WTSClientProtocolType: //0 - The console session. 1 - This value is retained for legacy purposes. 2 - The RDP protocol.
						strRet.Format("%d",*(USHORT*)pData);
						break;

					case WTSConnectState:{
						switch (*(WTS_CONNECTSTATE_CLASS*)pData){
							case WTSActive: strRet = "Active"; break;
							case WTSConnected: strRet = "Connected"; break;
							case WTSConnectQuery: strRet = "ConnectQuery"; break;
							case WTSShadow: strRet = "Shadow"; break;
							case WTSDisconnected: strRet = "Disconnected"; break;
							case WTSIdle: strRet = "Idle"; break;
							case WTSListen: strRet = "Listen"; break;
							case WTSReset: strRet = "Reset"; break;
							case WTSDown: strRet = "Down"; break;
							case WTSInit: strRet = "Init"; break;
						}
					}
					break;

					case WTSClientDisplay:{
						WTS_CLIENT_DISPLAY* pCd = (WTS_CLIENT_DISPLAY*)pData;
						strRet.Format("%dx%d",pCd->HorizontalResolution,pCd->VerticalResolution);
					}
					break;

					case WTSClientAddress:{
						WTS_CLIENT_ADDRESS* pIpAddress = (WTS_CLIENT_ADDRESS*)pData;
						strRet.Format("%d.%d.%d.%d",pIpAddress->Address[2],pIpAddress->Address[3],pIpAddress->Address[4],pIpAddress->Address[5]);
					}
					break;
				}

			} else ErrorMessage("   - WTSQuerySessionInformation");

			WTSFreeMemory(pData);
			VARIANT v; VariantInit(&v); v.vt = VT_BSTR; v.bstrVal = strRet.AllocSysString();
			*pvarRetValue = v;
		}
		break;
	default:
		return S_FALSE;
	}
	
	return S_OK;
}










/////////////////////////////////////////////////////////////////////////////
// IPropertyPage

STDMETHODIMP CAddIn::SetPageSite(IPropertyPageSite *pPageSite)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
    return IPropertyPageImpl<CAddIn>::SetPageSite(pPageSite);
}

STDMETHODIMP CAddIn::Activate(HWND hWndParent,LPCRECT prc,BOOL bModal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Activate(hWndParent,prc,bModal);
}

STDMETHODIMP CAddIn::Deactivate()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Deactivate();
}

STDMETHODIMP CAddIn::GetPageInfo(PROPPAGEINFO *pPageInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::GetPageInfo(pPageInfo);
}

STDMETHODIMP CAddIn::SetObjects(ULONG cObjects,IUnknown **ppUnk)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::SetObjects(cObjects,ppUnk);
}

STDMETHODIMP CAddIn::Show(UINT nCmdShow)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Show(nCmdShow);
}

STDMETHODIMP CAddIn::Move(LPCRECT prc)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Move(prc);
}

STDMETHODIMP CAddIn::IsPageDirty()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::IsPageDirty();
}

STDMETHODIMP CAddIn::Apply()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
    return IPropertyPageImpl<CAddIn>::Apply();
}

STDMETHODIMP CAddIn::Help(LPCOLESTR pszHelpDir)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Help(pszHelpDir);
}

STDMETHODIMP CAddIn::TranslateAccelerator(LPMSG pMsg)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
    return IPropertyPageImpl<CAddIn>::TranslateAccelerator(pMsg);
}



LRESULT CAddIn::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	// TODO: Add your implementation code here

    SetDirty(FALSE);
    m_pPageSite->OnStatusChange(0);
    bHandled = FALSE;

    return 0; 
}

LRESULT CAddIn::OnCommand(WORD wNotifyCode, WORD nID, HWND hWndCtl, BOOL& bHandled)
{
	// TODO: Add your implementation code here

    SetDirty(TRUE);
    bHandled = FALSE;

    return 0;
} 



// WTSActive A user is logged on to the WinStation.
// WTSConnected The WinStation is connected to the client.
// WTSConnectQuery The WinStation is in the process of connecting to the client.
// WTSShadow The WinStation is shadowing another WinStation.
// WTSDisconnected The WinStation is active but the client is disconnected.
// WTSIdle The WinStation is waiting for a client to connect.
// WTSListen The WinStation is listening for a connection. A listener session waits for requests for new client connections. No user is logged on a listener session. A listener session cannot be reset, shadowed, or changed to a regular client session.
// WTSReset The WinStation is being reset.
// WTSDown The WinStation is down due to an error.
// WTSInit	The WinStation is initializing.


// WTSInitialProgram
// A null-terminated string containing the name of the initial program that Remote Desktop Services runs when the user logs on.
// 
// WTSApplicationName
// A null-terminated string containing the published name of the application that the session is running.
// 
// WTSWorkingDirectory
// A null-terminated string containing the default directory used when launching the initial program.
// 
// WTSOEMId
// This value is not used.
// 
// WTSSessionId
// A ULONG value containing the session identifier.
// 
// WTSUserName
// A null-terminated string containing the name of the user associated with the session.
// 
// WTSWinStationName
// A null-terminated string containing the name of the Remote Desktop Services session. 
// 
// Note  Despite its name, specifying this type does not return the window station name. Rather, it returns the name of the Remote Desktop Services session. Each Remote Desktop Services session is associated with an interactive window station. Currently, since the only supported window station name for an interactive window station is "WinSta0", each session is associated with its own "WinSta0" window station. For more information, see Window Stations.
// 
// WTSDomainName
// A null-terminated string containing the name of the domain to which the logged-on user belongs.
// 
// WTSConnectState
// The session's current connection state. For more information, see WTS_CONNECTSTATE_CLASS.
// 
// WTSClientBuildNumber
// A ULONG value containing the build number of the client.
// 
// WTSClientName
// A null-terminated string containing the name of the client.
// 
// WTSClientDirectory
// A null-terminated string containing the directory in which the client is installed.
// 
// WTSClientProductId
// A USHORT client-specific product identifier.
// 
// WTSClientHardwareId
// A ULONG value containing a client-specific hardware identifier.
// 
// WTSClientAddress
// The network type and network address of the client. For more information, see WTS_CLIENT_ADDRESS.
// 
// The IP address is offset by two bytes from the start of the Address member of the WTS_CLIENT_ADDRESS structure.
// 
// WTSClientDisplay
// Information about the display resolution of the client. For more information, see WTS_CLIENT_DISPLAY.
// 
// WTSClientProtocolType
// A USHORT value specifying information about the protocol type for the session. This is one of the following values:
// 
// Value Meaning 
// 0
// The console session.
// 
// 1
// This value is retained for legacy purposes.
// 
// 2
// The RDP protocol


										   

// typedef struct _WTSINFO {
// 	WTS_CONNECTSTATE_CLASS State;
// 	DWORD                  SessionId;
// 	DWORD                  IncomingBytes;
// 	DWORD                  OutgoingBytes;
// 	DWORD                  IncomingCompressedBytes;
// 	DWORD                  OutgoingCompressedBytes;
// 	WCHAR                  WinStationName;
// 	WCHAR                  Domain;
// 	WCHAR                  UserName;
// 	LARGE_INTEGER          ConnectTime;
// 	LARGE_INTEGER          DisconnectTime;
// 	LARGE_INTEGER          LastInputTime;
// 	LARGE_INTEGER          LogonTime;
// 	LARGE_INTEGER          CurrentTime;
// }WTSINFO, *PWTSINFO;

// typedef struct _WTSINFOEX_LEVEL1 {
// 	ULONG                  SessionId;
// 	WTS_CONNECTSTATE_CLASS SessionState;
// 	LONG                   SessionFlags;
// 	WCHAR                  WinStationName[WINSTATIONNAME_LENGTH + 1];
// 	WCHAR                  UserName[USERNAME_LENGTH + 1];
// 	WCHAR                  DomainName[DOMAIN_LENGTH + 1];
// 	LARGE_INTEGER          LogonTime;
// 	LARGE_INTEGER          ConnectTime;
// 	LARGE_INTEGER          DisconnectTime;
// 	LARGE_INTEGER          LastInputTime;
// 	LARGE_INTEGER          CurrentTime;
// 	DWORD                  IncomingBytes;
// 	DWORD                  OutgoingBytes;
// 	DWORD                  IncomingFrames;
// 	DWORD                  OutgoingFrames;
// 	DWORD                  IncomingCompressedBytes;
// 	DWORD                  OutgoingCompressedBytes;
// }WTSINFOEX_LEVEL1, *PWTSINFOEX_LEVEL1;

// typedef union _WTSINFOEX_LEVEL {
// 	WTSINFOEX_LEVEL1 WTSInfoExLevel1;
// }WTSINFOEX_LEVEL, *PWTSINFOEX_LEVEL;

// typedef struct _WTSINFOEX {
// 	DWORD           Level;
// 	WTSINFOEX_LEVEL Data;
// }WTSINFOEX, *PWTSINFOEX;

// typedef enum _WTS_INFO_CLASS {
// 	WTSInitialProgram          = 0,
// 		WTSApplicationName         = 1,
// 		WTSWorkingDirectory        = 2,
// 		WTSOEMId                   = 3,
// 		WTSSessionId               = 4,
// 		WTSUserName                = 5,
// 		WTSWinStationName          = 6,
// 		WTSDomainName              = 7,
// 		WTSConnectState            = 8,
// 		WTSClientBuildNumber       = 9,
// 		WTSClientName              = 10,
// 		WTSClientDirectory         = 11,
// 		WTSClientProductId         = 12,
// 		WTSClientHardwareId        = 13,
// 		WTSClientAddress           = 14,
// 		WTSClientDisplay           = 15,
// 		WTSClientProtocolType      = 16,
// 		WTSIdleTime                = 17,
// 		WTSLogonTime               = 18,
// 		WTSIncomingBytes           = 19,
// 		WTSOutgoingBytes           = 20,
// 		WTSIncomingFrames          = 21,
// 		WTSOutgoingFrames          = 22,
// 		WTSClientInfo              = 23,
// 		WTSSessionInfo             = 24,
// 		WTSSessionInfoEx           = 25,
// 		WTSConfigInfo              = 26,
// 		WTSValidationInfo          = 27,
// 		WTSSessionAddressV4        = 28,
// 		WTSIsRemoteSession         = 29 
// } WTS_INFO_CLASS;


