unit PropPage;

interface

uses SysUtils, Windows, Messages, Classes, Graphics, Controls, StdCtrls,
  ExtCtrls, Forms, ComServ, ComObj, StdVcl, AxCtrls, AddInLib;

type
  TAddInPropPage = class(TPropertyPage)
    IsEnabled: TCheckBox;
    Slogan: TStaticText;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure UpdatePropertyPage; override;
    procedure UpdateObject; override;
  end;

const
  Class_AddInPropPage: TGUID = '{ED3045F0-25AE-11D1-A4CB-004095E1DAEA}';

implementation

{$R *.DFM}

procedure TAddInPropPage.UpdatePropertyPage;
var  iCheck : Integer;
     pLink : IPropertyLink;
begin
  { Update your controls from OleObject }
  pLink := IUnknown(OleObject) as IPropertyLink;
  if (pLink <> nil) then
     begin
       pLink.get_Enabled(iCheck);
       if (iCheck <> 0) then
         IsEnabled.Checked := True
         else IsEnabled.Checked := False;
     end;
end;

procedure TAddInPropPage.UpdateObject;
var  pLink : IPropertyLink;
begin
  { Update OleObject from your controls }
  pLink := IUnknown(OleObject) as IPropertyLink;
  if (pLink <> nil) then
     begin
       if (IsEnabled.Checked = True) then
         pLink.put_Enabled(1)
         else pLink.put_Enabled(0);
     end;
end;


initialization
  TActiveXPropertyPageFactory.Create(
    ComServer,
    TAddInPropPage,
    Class_AddInPropPage);
end.
