unit AddInObj;

interface

uses ComServ, ComObj, ActiveX, AddInLib, PropPage,
SysUtils, Windows, Messages, Classes, Graphics, Controls, StdCtrls,
  ExtCtrls, Forms, StdVcl, AxCtrls;

resourcestring
     strIsEnabled = 'IsEnabled,';
     strIsTimerPresent = 'IsTimerPresent,';
     strEnable = 'Enable,';
     strDisable = 'Disable,';
     strShowInStatusLine = 'ShowInStatusLine,';
     strStartTimer = 'StartTimer,';
     strStopTimer = 'StopTimer,';
     strContext = 'Context,';

const
            { This GUID should be changed}
     CLSID_AddInObject : TGUID = '{DBF10CE5-6A81-40b1-8479-4122220D85D7}';

type

TProperties = ( propIsEnabled, propIsTimerPresent, propContext, LastProp );
TMethods = ( methEnable, methDisable, methShowInStatusLine, methStartTimer, methStopTimer, LastMethod );

TAddInObject = class (TComObject, IDispatch, IInitDone, ISpecifyPropertyPages,
                                        ILanguageExtender,IPropertyLink)
      { Attributes }
    boolIsEnabled : Integer;
    Timer : TTimer;

    p1C : OleVariant;
    pCurrentConnection: IDispatch;
    CurrentContext : OleVariant;

      { Interfaces }
    pErrorLog : IErrorLog;
    pEvent : IAsyncEvent;
    pProfile : IPropertyProfile;
    pStatusLine : IStatusLine;

    function CallEventProcedure(ProcedureName: String; GlobalContext: Boolean): Integer;

    function LoadProperties: Boolean;
    procedure SaveProperties;
      { This function is useful in ILanguageExtender implementation }
    function TermString(strTerm: string; iAlias: Integer): string;
      {These two methods is convenient way to access function
       parameters from SAFEARRAY vector of variants }
    function GetNParam(var pArray : PSafeArray; lIndex: Integer ): OleVariant;
    procedure PutNParam(var pArray: PSafeArray; lIndex: Integer; var varPut: OleVariant);

      { Interface implementation }
      { IInitDone implementation }
    function Init(pConnection: IDispatch): HResult; stdcall;
    function Done: HResult; stdcall;
    function GetInfo(var pInfo: PSafeArray{(OleVariant)}): HResult; stdcall;
      { ISpecifyPropertyPages implementation }
    function GetPages(out Pages: TCAGUID) : HResult; stdcall;
      { ILanguageExtender implementation }
    function RegisterExtensionAs(var bstrExtensionName: WideString): HResult; stdcall;
    function GetNProps(var plProps: Integer): HResult; stdcall;
    function FindProp(const bstrPropName: WideString; var plPropNum: Integer): HResult; stdcall;
    function GetPropName(lPropNum, lPropAlias: Integer; var pbstrPropName: WideString): HResult; stdcall;
    function GetPropVal(lPropNum: Integer; var pvarPropVal: OleVariant): HResult; stdcall;
    function SetPropVal(lPropNum: Integer; var varPropVal: OleVariant): HResult; stdcall;
    function IsPropReadable(lPropNum: Integer; var pboolPropRead: Integer): HResult; stdcall;
    function IsPropWritable(lPropNum: Integer; var pboolPropWrite: Integer): HResult; stdcall;
    function GetNMethods(var plMethods: Integer): HResult; stdcall;
    function FindMethod(const bstrMethodName: WideString; var plMethodNum: Integer): HResult; stdcall;
    function GetMethodName(lMethodNum, lMethodAlias: Integer; var pbstrMethodName: WideString): HResult; stdcall;
    function GetNParams(lMethodNum: Integer; var plParams: Integer): HResult; stdcall;
    function GetParamDefValue(lMethodNum, lParamNum: Integer; var pvarParamDefValue: OleVariant): HResult; stdcall;
    function HasRetVal(lMethodNum: Integer; var pboolRetValue: Integer): HResult; stdcall;
    function CallAsProc(lMethodNum: Integer; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
    function CallAsFunc(lMethodNum: Integer; var pvarRetValue: OleVariant; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
      { IPropertyLink implementation }
    function get_Enabled(var IsEnabled : Integer): HResult; stdcall;
    function put_Enabled(IsEnabled : Integer): HResult; stdcall;

    procedure OnMyTimer(Sender: TObject);

        { IDispatch }
    function GetIDsOfNames(const IID: TGUID; Names: Pointer;
      NameCount, LocaleID: Integer; DispIDs: Pointer): HResult; virtual; stdcall;
    function GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult; virtual; stdcall;
    function GetTypeInfoCount(out Count: Integer): HResult; virtual; stdcall;
    function Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult; virtual; stdcall;
end;

implementation

function TAddInObject.CallEventProcedure(ProcedureName: String; GlobalContext: Boolean): Integer;
var MethodID: Integer;
    DispParams: TDispParams;
    ExcepInfo: TExcepInfo;
    Status: HResult;
    VarResult, obj, t: Variant;
    lMethodName: WideString;
begin
   Result := 0;

   if GlobalContext then
     begin
       obj := OleVariant(pCurrentConnection).AppDispatch;
       IDispatch(obj)._AddRef;
    end
   else
     begin
       obj := CurrentContext;
     end;

   if (VarType(obj) And VarTypeMask) <> varDispatch then Exit;
   lMethodName := ProcedureName;
   //t := obj.OnTimer;
   if IDispatch(obj).GetIDsOfNames(GUID_NULL, @lMethodName, 1, LOCALE_USER_DEFAULT , @MethodID) = S_OK then
      begin
         //   
         //Args[0] := ConnectServer^.GUID;
         //Args[1] := ConnectServer^.ReadStr;

         DispParams.rgvarg:= nil; //@Args;   //  Variant
         DispParams.rgdispidNamedArgs := nil;
         DispParams.cArgs := 0;
         DispParams.cNamedArgs := 0;

         //Status := IDispatch(obj).Invoke(MethodID, GUID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, DispParams, @VarResult, @ExcepInfo, @ArgErr);
         Status := IDispatch(obj).Invoke(MethodID, GUID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, DispParams, @VarResult, @ExcepInfo, nil);
         if Status <> S_OK then
         begin
            //DispatchInvokeError(Status, ExcepInfo);
         end;
      end
   else
      begin
         //t := obj.MethodNotFounded(OleVariant(ProcedureName), OLEVariant(MethodID));
      end;

   obj := Unassigned;
end;

function TAddInObject.LoadProperties: Boolean;
var
   iRes : Integer;
   varRead : OleVariant;
begin

   VarClear(varRead);
     { SImply cast OleVariant to Integer (VT_I4) }
   varRead := 0;
   iRes := pProfile. Read('Enabled:0',varRead,nil);
   if (iRes <> S_OK) then
     begin
       LoadProperties := False;
       Exit;
     end;

   boolIsEnabled := varRead;

   LoadProperties := True;

end;

procedure TAddInObject.SaveProperties;
var
   varSave : OleVariant;
begin

   varSave := boolIsEnabled;
   pProfile. Write('Enabled:0',varSave);

end;

function TAddInObject.TermString(strTerm: string; iAlias: Integer): string;
var
     iSemicolon: Integer;
begin
     iSemicolon := Pos(',',strTerm);
     if (iAlias = 0) then
       if (iSemicolon = 0) then
         TermString := strTerm
         else
           TermString := Copy(strTerm,1,iSemicolon-1)
       else { iAlias = 1}
         if (iSemicolon = 0) then
           TermString := ''
           else
             TermString := Copy(strTerm,iSemicolon+1,Length(strTerm) - iSemicolon);
end;

function TAddInObject.GetNParam(var pArray : PSafeArray; lIndex: Integer ): OleVariant;
var varGet : OleVariant;
begin
   SafeArrayGetElement(pArray,lIndex,varGet);
   GetNParam := varGet;
end;

procedure TAddInObject.PutNParam(var pArray: PSafeArray; lIndex: Integer; var varPut: OleVariant);
begin
  SafeArrayPutElement(pArray,lIndex,varPut);
end;

{ IInitDone interface }

function TAddInObject.Init(pConnection: IDispatch): HResult; stdcall;
var iRes : Integer;
begin

     pErrorLog := nil;
     pConnection.QueryInterface(IID_IErrorLog,pErrorLog);

     pEvent := nil;
     pConnection.QueryInterface(IID_IAsyncEvent,pEvent);

     pProfile := nil;
     iRes := pConnection.QueryInterface(IID_IPropertyProfile,pProfile);
     if (iRes = S_OK) then
        begin
             pProfile.RegisterProfileAs('Sample AddIn Profile Name');
             if (LoadProperties() <> True) then
               begin
                 Init := E_FAIL;
                 Exit;
               end;
        end;

     pStatusLine := nil;
     pConnection.QueryInterface(IID_IStatusLine,pStatusLine);

     Timer := TTimer.Create(NIL);
     Timer.Enabled := False;
     Timer.OnTimer := OnMyTimer;

     pCurrentConnection := pConnection;

     {if VarType(p1C) And varTypeMask = varEmpty then
     begin
        p1C := OleVariant(pConnection).AppDispatch;
        IDispatch(p1C)._AddRef;
     end;}

     Init := S_OK;
end;

function TAddInObject.Done: HResult; stdcall;
begin

     SaveProperties();

     if (pErrorLog <> nil) then
       pErrorLog._Release();

     if (pEvent <> nil) then
       pEvent._Release();

     if (pProfile <> nil) then
       pProfile._Release();

     if (pStatusLine <> nil) then
       pStatusLine._Release();

     {if (IDispatch(CurrentContext) <> nil) then
       (IDispatch(CurrentContext)._Release();}
       CurrentContext := Unassigned;

     if (pCurrentConnection <> nil) then
       pCurrentConnection._Release();

     Timer.Destroy();
     Done := S_OK;
end;

function TAddInObject.GetInfo(var pInfo: PSafeArray{(OleVariant)}): HResult; stdcall;
var  varInfo : OleVariant;
begin
     varInfo := '2000';
     PutNParam(pInfo,0,varInfo);
     GetInfo := S_OK;
end;

{ ISpecifyPropertyPages interface }

function TAddInObject.GetPages(out Pages: TCAGUID) : HResult; stdcall;
begin
     Pages.cElems := 1;
     Pages.pElems := CoTaskMemAlloc(SizeOf(TGUID));
     (Pages.pElems)[0] := Class_AddInPropPage;
     GetPages := S_OK;
end;

{ ILanguageExtender interface }

function TAddInObject.RegisterExtensionAs(var bstrExtensionName: WideString): HResult; stdcall;
begin
     bstrExtensionName := 'AddInExtension';
     RegisterExtensionAs := S_OK;
end;

function TAddInObject.GetNProps(var plProps: Integer): HResult; stdcall;
begin
     plProps := Integer(LastProp);
     GetNProps := S_OK;
end;

function TAddInObject.FindProp(const bstrPropName: WideString; var plPropNum: Integer): HResult; stdcall;
begin
     plPropNum := -1;

     if (bstrPropName = TermString(strIsEnabled,0)) then plPropNum := 0;
     if (bstrPropName = TermString(strIsEnabled,1)) then plPropNum := 0;
     if (bstrPropName = TermString(strIsTimerPresent,0)) then plPropNum := 1;
     if (bstrPropName = TermString(strIsTimerPresent,1)) then plPropNum := 1;
     if (bstrPropName = TermString(strContext,0)) then plPropNum := 2;
     if (bstrPropName = TermString(strContext,1)) then plPropNum := 2;


     if (plPropNum = -1) then
       begin
         FindProp := S_FALSE;
         Exit;
       end;

     FindProp := S_OK;
end;

function TAddInObject.GetPropName(lPropNum, lPropAlias: Integer; var pbstrPropName: WideString): HResult; stdcall;
begin
     pbstrPropName := '';
     case TProperties(lPropNum) of
          propIsEnabled:
            begin
                 pbstrPropName := TermString(strIsEnabled,lPropAlias);
            end;
          propIsTimerPresent:
            begin
                 pbstrPropName := TermString(strIsTimerPresent,lPropAlias);
            end;
          propContext:
            begin
                 pbstrPropName := TermString(strContext,lPropAlias);
            end;
          else
            GetPropName := S_FALSE;
            Exit;
     end;

     GetPropName := S_OK;
end;

function TAddInObject.GetPropVal(lPropNum: Integer; var pvarPropVal: OleVariant): HResult; stdcall;
begin

     VarClear(pvarPropVal);
     case TProperties(lPropNum) of
          propIsEnabled:
            begin
                 pvarPropVal := boolIsEnabled;
            end;
          propIsTimerPresent:
            begin
                 pvarPropVal := True;
            end;
          propContext:
            begin
                 pvarPropVal := OleVariant(CurrentContext);
            end;
         else
            GetPropVal := S_FALSE;
            Exit;
     end;

     GetPropVal := S_OK;

end;

function TAddInObject.SetPropVal(lPropNum: Integer; var varPropVal: OleVariant): HResult; stdcall;
begin

     case TProperties(lPropNum) of
          propIsEnabled:
            begin
                 boolIsEnabled := varPropVal;
            end;
          propIsTimerPresent:
            begin
            end;
          propContext:
            begin
                 CurrentContext := varPropVal;
            end;
         else
            SetPropVal := S_FALSE;
            Exit;
     end;

     SetPropVal := S_OK;

end;

function TAddInObject.IsPropReadable(lPropNum: Integer; var pboolPropRead: Integer): HResult; stdcall;
begin

     case TProperties(lPropNum) of
          propIsEnabled:
            begin
                 pboolPropRead := 1;
            end;
          propIsTimerPresent:
            begin
                 pboolPropRead := 1;
            end;
          propContext:
            begin
                 pboolPropRead := 1;
            end;
          else
            IsPropReadable := S_FALSE;
            Exit;
     end;

     IsPropReadable := S_OK;

end;

function TAddInObject.IsPropWritable(lPropNum: Integer; var pboolPropWrite: Integer): HResult; stdcall;
begin
     case TProperties(lPropNum) of
          propIsEnabled:
            begin
                 pboolPropWrite := 1;
            end;
          propIsTimerPresent:
            begin
                 pboolPropWrite := 0;
            end;
          propContext:
            begin
                 pboolPropWrite := 1;
            end;
          else
            IsPropWritable := S_FALSE;
            Exit;
     end;

     IsPropWritable := S_OK;

end;

function TAddInObject.GetNMethods(var plMethods: Integer): HResult; stdcall;
begin
     plMethods := Integer(LastMethod);
     GetNMethods := S_OK;
end;

function TAddInObject.FindMethod(const bstrMethodName: WideString; var plMethodNum: Integer): HResult; stdcall;
begin
     plMethodNum := -1;

     if (bstrMethodName = TermString(strEnable,0)) then plMethodNum := 0;
     if (bstrMethodName = TermString(strEnable,1)) then plMethodNum := 0;
     if (bstrMethodName = TermString(strDisable,0)) then plMethodNum := 1;
     if (bstrMethodName = TermString(strDisable,1)) then plMethodNum := 1;
     if (bstrMethodName = TermString(strShowInStatusLine,0)) then plMethodNum := 2;
     if (bstrMethodName = TermString(strShowInStatusLine,1)) then plMethodNum := 2;
     if (bstrMethodName = TermString(strStartTimer,0)) then plMethodNum := 3;
     if (bstrMethodName = TermString(strStartTimer,1)) then plMethodNum := 3;
     if (bstrMethodName = TermString(strStopTimer,0)) then plMethodNum := 4;
     if (bstrMethodName = TermString(strStopTimer,1)) then plMethodNum := 4;

     if (plMethodNum = -1) then
       begin
         FindMethod := S_FALSE;
         Exit;
       end;

     FindMethod := S_OK;

end;

function TAddInObject.GetMethodName(lMethodNum, lMethodAlias: Integer; var pbstrMethodName: WideString): HResult; stdcall;
begin

     pbstrMethodName := '';

     case TMethods(lMethodNum) of
          methEnable:
            begin
              pbstrMethodName := TermString(strEnable,lMethodAlias);
            end;
          methDisable:
            begin
              pbstrMethodName := TermString(strDisable,lMethodAlias);
            end;
          methShowInStatusLine:
            begin
              pbstrMethodName := TermString(strShowInStatusLine,lMethodAlias);
            end;
          methStartTimer:
            begin
              pbstrMethodName := TermString(strStartTimer,lMethodAlias);
            end;
          methStopTimer:
            begin
              pbstrMethodName := TermString(strStopTimer,lMethodAlias);
            end;
          else
            begin
               GetMethodName := S_FALSE;
               Exit;
            end;
     end;

     GetMethodName := S_OK;

end;

function TAddInObject.GetNParams(lMethodNum: Integer; var plParams: Integer): HResult; stdcall;
begin

     plParams := 0;

     case TMethods(lMethodNum) of
          methEnable:
            begin
              plParams := 0;
            end;
          methDisable:
            begin
              plParams := 0;
            end;
          methShowInStatusLine:
            begin
              plParams := 1;
            end;
          methStartTimer:
            begin
              plParams := 0;
            end;
          methStopTimer:
            begin
              plParams := 0;
            end;
          else
            begin
               GetNParams := S_FALSE;
               Exit;
            end;
     end;

     GetNParams := S_OK;

end;

function TAddInObject.GetParamDefValue(lMethodNum, lParamNum: Integer; var pvarParamDefValue: OleVariant): HResult; stdcall;
begin
       { Ther is no default value for any parameter }
     VarClear(pvarParamDefValue);
     GetParamDefValue := S_OK;
end;

function TAddInObject.HasRetVal(lMethodNum: Integer; var pboolRetValue: Integer): HResult; stdcall;
begin
     pboolRetValue := 0;
     HasRetVal := S_OK;
end;

function TAddInObject.CallAsProc(lMethodNum: Integer; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
begin

     case TMethods(lMethodNum) of
          methEnable:
            begin
              boolIsEnabled := 1;
            end;
          methDisable:
            begin
              boolIsEnabled := 0;
            end;
          methShowInStatusLine:
            begin
              pStatusLine.SetStatusLine(GetNParam(paParams,0));
              Sleep(5000);
            end;
          methStartTimer:
            begin
              Timer.Enabled := True;
            end;
          methStopTimer:
            begin
              Timer.Enabled := False;
            end;
          else
            begin
               CallAsProc := S_FALSE;
               Exit;
            end;
     end;

     CallAsProc := S_OK;
end;

function TAddInObject.CallAsFunc(lMethodNum: Integer; var pvarRetValue: OleVariant; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
begin
     CallAsFunc := S_FALSE;
end;

function TAddInObject.get_Enabled(var IsEnabled : Integer): HResult; stdcall;
begin
     IsEnabled := boolIsEnabled;
     get_Enabled := S_OK;
end;

function TAddInObject.put_Enabled(IsEnabled : Integer): HResult; stdcall;
begin
     boolIsEnabled := IsEnabled;
     if (boolIsEnabled = 0) then
       begin
          pEvent.ExternalEvent('','','0')
       end
     else
       begin
          pEvent.ExternalEvent('','','1');
       end;
     put_Enabled := S_OK;
end;

procedure TAddInObject.OnMyTimer(Sender: TObject);
begin
     if (pEvent <> nil)then
       begin
          CallEventProcedure('OnTimer', True);
          CallEventProcedure('OnTimer', False);
          pEvent.ExternalEvent('','',FormatDateTime('hh:mm:ss',Time));
       end;
end;

function TAddInObject.GetIDsOfNames(const IID: TGUID; Names: Pointer;
  NameCount, LocaleID: Integer; DispIDs: Pointer): HResult;
begin
  Result := E_NOTIMPL;
end;

function TAddInObject.GetTypeInfo(Index, LocaleID: Integer;
  out TypeInfo): HResult;
begin
  Result := E_NOTIMPL;
end;

function TAddInObject.GetTypeInfoCount(out Count: Integer): HResult;
begin
  Result := E_NOTIMPL;
end;

function TAddInObject.Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult;
begin
  Result := E_NOTIMPL;
end;

initialization

ComServer.SetServerName('AddIn');
TComObjectFactory.Create(ComServer,TAddInObject,CLSID_AddInObject,
                        'AddIn','V7 AddIn 2.0',ciMultiInstance);

end.
